/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.SetMatcher;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PartitionBinarySelectRule
extends ExplorationCascadesRule<SelectExpression> {
    private static final BindingMatcher<Quantifier> leftQuantifierMatcher = QuantifierMatchers.anyQuantifier();
    private static final BindingMatcher<Quantifier> rightQuantifierMatcher = QuantifierMatchers.anyQuantifier();
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(SetMatcher.exactlyInAnyOrder(leftQuantifierMatcher, rightQuantifierMatcher));

    public PartitionBinarySelectRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ExplorationCascadesRuleCall call) {
        Quantifier newRightQuantifier;
        Quantifier newLeftQuantifier;
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        Quantifier leftQuantifier = bindings.get(leftQuantifierMatcher);
        CorrelationIdentifier leftAlias = leftQuantifier.getAlias();
        Quantifier rightQuantifier = bindings.get(rightQuantifierMatcher);
        CorrelationIdentifier rightAlias = rightQuantifier.getAlias();
        ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> fullCorrelationOrder = selectExpression.getCorrelationOrder().getTransitiveClosure();
        ImmutableCollection rightDependencies = fullCorrelationOrder.get((Object)rightAlias);
        boolean rightDependsOnLeft = rightDependencies.contains(leftAlias);
        ImmutableCollection leftDependencies = fullCorrelationOrder.get((Object)leftAlias);
        boolean leftDependsOnRight = leftDependencies.contains(rightAlias);
        ImmutableList.Builder leftPredicatesBuilder = ImmutableList.builder();
        ImmutableList.Builder rightPredicatesBuilder = ImmutableList.builder();
        for (QueryPredicate queryPredicate : selectExpression.getPredicates()) {
            Set<CorrelationIdentifier> correlatedTo = queryPredicate.getCorrelatedTo();
            boolean correlatedToRight = correlatedTo.contains(rightQuantifier.getAlias());
            if (!rightDependsOnLeft || !correlatedToRight) {
                leftPredicatesBuilder.add(queryPredicate);
                continue;
            }
            rightPredicatesBuilder.add(queryPredicate);
        }
        ImmutableCollection leftPredicates = leftPredicatesBuilder.build();
        ImmutableCollection immutableCollection = rightPredicatesBuilder.build();
        if (leftPredicates.isEmpty() && immutableCollection.isEmpty()) {
            return;
        }
        Value resultValue = selectExpression.getResultValue();
        Set<CorrelationIdentifier> resultValueCorrelatedTo = resultValue.getCorrelatedTo();
        GraphExpansion.Builder graphExpansionBuilder = GraphExpansion.builder();
        graphExpansionBuilder.addQuantifier(leftQuantifier);
        graphExpansionBuilder.addAllPredicates(leftPredicates);
        if (!leftPredicates.isEmpty()) {
            SelectExpression leftSelectExpression;
            if (resultValueCorrelatedTo.contains(leftAlias) || rightDependsOnLeft) {
                Verify.verify(leftQuantifier instanceof Quantifier.ForEach);
                leftSelectExpression = graphExpansionBuilder.build().buildSimpleSelectOverQuantifier((Quantifier.ForEach)leftQuantifier);
            } else {
                graphExpansionBuilder.addResultValue(LiteralValue.ofScalar(1));
                leftSelectExpression = graphExpansionBuilder.build().buildSelect();
            }
            newLeftQuantifier = ((Quantifier.ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias(leftQuantifier.getAlias())).build(call.memoizeExploratoryExpression(leftSelectExpression));
        } else {
            newLeftQuantifier = leftQuantifier;
        }
        graphExpansionBuilder = GraphExpansion.builder();
        graphExpansionBuilder.addQuantifier(rightQuantifier);
        graphExpansionBuilder.addAllPredicates(immutableCollection);
        if (!immutableCollection.isEmpty()) {
            SelectExpression rightSelectExpression;
            if (resultValueCorrelatedTo.contains(rightAlias) || leftDependsOnRight) {
                Verify.verify(rightQuantifier instanceof Quantifier.ForEach);
                rightSelectExpression = graphExpansionBuilder.build().buildSimpleSelectOverQuantifier((Quantifier.ForEach)rightQuantifier);
            } else {
                graphExpansionBuilder.addResultValue(LiteralValue.ofScalar(1));
                rightSelectExpression = graphExpansionBuilder.build().buildSelect();
            }
            newRightQuantifier = ((Quantifier.ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias(rightQuantifier.getAlias())).build(call.memoizeExploratoryExpression(rightSelectExpression));
        } else {
            newRightQuantifier = rightQuantifier;
        }
        graphExpansionBuilder = GraphExpansion.builder();
        graphExpansionBuilder.addQuantifier(newLeftQuantifier);
        graphExpansionBuilder.addQuantifier(newRightQuantifier);
        SelectExpression newSelectExpression = graphExpansionBuilder.build().buildSelectWithResultValue(resultValue);
        call.yieldExploratoryExpression(newSelectExpression);
    }
}

