/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PartitionSelectRule
extends ExplorationCascadesRule<SelectExpression> {
    private static final CollectionMatcher<Quantifier> combinationQuantifierMatcher = MultiMatcher.all(QuantifierMatchers.anyQuantifier());
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(CollectionMatcher.combinations(combinationQuantifierMatcher, c -> 0, Collection::size));

    public PartitionSelectRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ExplorationCascadesRuleCall call) {
        SelectExpression upperSelectExpression;
        RecordQueryPlannerConfiguration plannerConfiguration;
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        if (selectExpression.getQuantifiers().size() < 3) {
            return;
        }
        ImmutableSet<CorrelationIdentifier> lowerAliases = ((Collection)((Object)bindings.get(combinationQuantifierMatcher))).stream().map(Quantifier::getAlias).collect(ImmutableSet.toImmutableSet());
        if (lowerAliases.isEmpty()) {
            return;
        }
        ImmutableSet.Builder upperAliasesBuilder = ImmutableSet.builder();
        for (Quantifier quantifier2 : selectExpression.getQuantifiers()) {
            CorrelationIdentifier alias2 = quantifier2.getAlias();
            if (lowerAliases.contains(alias2)) continue;
            upperAliasesBuilder.add(alias2);
        }
        ImmutableCollection upperAliases = upperAliasesBuilder.build();
        if (upperAliases.isEmpty()) {
            return;
        }
        Set<Set<CorrelationIdentifier>> set = selectExpression.getIndependentQuantifiersPartitioning();
        if (set.size() > 1 && (plannerConfiguration = call.getContext().getPlannerConfiguration()).shouldDeferCrossProducts() && !this.isCrossProduct(set, lowerAliases, (Set<CorrelationIdentifier>)((Object)upperAliases))) {
            return;
        }
        Map<CorrelationIdentifier, ? extends Quantifier> aliasToQuantifierMap = selectExpression.getAliasToQuantifierMap();
        ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> fullCorrelationOrder = selectExpression.getCorrelationOrder().getTransitiveClosure();
        ImmutableSet uppersDependingOnLowersAliases = upperAliases.stream().filter(upperAlias -> !Sets.intersection(lowerAliases, fullCorrelationOrder.get(upperAlias)).isEmpty()).collect(ImmutableSet.toImmutableSet());
        if (lowerAliases.stream().anyMatch(lowerAlias -> !Sets.intersection(uppersDependingOnLowersAliases, fullCorrelationOrder.get(lowerAlias)).isEmpty())) {
            return;
        }
        ImmutableSet lowersCorrelatedToByUpperAliases = upperAliases.stream().flatMap(upperAlias -> Sets.intersection(lowerAliases, fullCorrelationOrder.get(upperAlias)).stream()).collect(ImmutableSet.toImmutableSet());
        if (lowersCorrelatedToByUpperAliases.size() > 1) {
            return;
        }
        CorrelationIdentifier lowerAliasCorrelatedToByUpperAliases = lowersCorrelatedToByUpperAliases.isEmpty() ? Quantifier.uniqueId() : (CorrelationIdentifier)Iterables.getOnlyElement(lowersCorrelatedToByUpperAliases);
        ImmutableList.Builder lowersCorrelatedToByUppersBuilder = ImmutableList.builder();
        Value resultValue = selectExpression.getResultValue();
        Sets.SetView<CorrelationIdentifier> resultCorrelatedToLowers = Sets.intersection(lowerAliases, resultValue.getCorrelatedTo());
        lowersCorrelatedToByUppersBuilder.addAll(resultCorrelatedToLowers);
        ImmutableList.Builder lowerPredicatesBuilder = ImmutableList.builder();
        ImmutableList.Builder upperPredicatesBuilder = ImmutableList.builder();
        ImmutableList.Builder deeplyCorrelatedPredicatesBuilder = ImmutableList.builder();
        for (QueryPredicate queryPredicate : selectExpression.getPredicates()) {
            Set<CorrelationIdentifier> correlatedTo = queryPredicate.getCorrelatedTo();
            Sets.SetView<CorrelationIdentifier> correlatedToLowerAliases = Sets.intersection(lowerAliases, correlatedTo);
            Sets.SetView correlatedToUpperAliases = Sets.intersection(upperAliases, correlatedTo);
            if (!correlatedToUpperAliases.isEmpty()) {
                if (!correlatedToLowerAliases.isEmpty()) {
                    if (Sets.intersection(correlatedToUpperAliases, uppersDependingOnLowersAliases).isEmpty()) {
                        lowerPredicatesBuilder.add(queryPredicate);
                        continue;
                    }
                    upperPredicatesBuilder.add(queryPredicate);
                    lowersCorrelatedToByUppersBuilder.addAll(correlatedToLowerAliases);
                    continue;
                }
                upperPredicatesBuilder.add(queryPredicate);
                continue;
            }
            if (!correlatedToLowerAliases.isEmpty()) {
                lowerPredicatesBuilder.add(queryPredicate);
                continue;
            }
            deeplyCorrelatedPredicatesBuilder.add(queryPredicate);
        }
        ImmutableCollection lowerPredicates = lowerPredicatesBuilder.build();
        ImmutableCollection immutableCollection = upperPredicatesBuilder.build();
        ImmutableCollection deeplyCorrelatedPredicates = deeplyCorrelatedPredicatesBuilder.build();
        ImmutableCollection lowersCorrelatedToByUppers = lowersCorrelatedToByUppersBuilder.build();
        if (!lowersCorrelatedToByUpperAliases.isEmpty()) {
            if (lowersCorrelatedToByUppers.size() > 1) {
                return;
            }
            if (lowersCorrelatedToByUppers.size() == 1 && !((CorrelationIdentifier)Iterables.getOnlyElement(lowersCorrelatedToByUppers)).equals(lowerAliasCorrelatedToByUpperAliases)) {
                return;
            }
        }
        if (lowerAliases.size() == 1 && lowerPredicates.isEmpty()) {
            return;
        }
        GraphExpansion.Builder lowerGraphExpansionBuilder = GraphExpansion.builder();
        lowerGraphExpansionBuilder.addAllQuantifiers(lowerAliases.stream().map(alias -> Verify.verifyNotNull((Quantifier)aliasToQuantifierMap.get(alias))).collect(ImmutableList.toImmutableList()));
        lowerGraphExpansionBuilder.addAllPredicates(lowerPredicates);
        lowerGraphExpansionBuilder.addAllPredicates(deeplyCorrelatedPredicates);
        if (lowersCorrelatedToByUpperAliases.isEmpty() && lowersCorrelatedToByUppers.isEmpty()) {
            lowerGraphExpansionBuilder.addResultValue(LiteralValue.ofScalar(1));
            SelectExpression lowerSelectExpression = lowerGraphExpansionBuilder.build().buildSelect();
            GraphExpansion.Builder upperGraphExpansionBuilder = GraphExpansion.builder();
            upperGraphExpansionBuilder.addQuantifier(((Quantifier.ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias(lowerAliasCorrelatedToByUpperAliases)).build(call.memoizeExploratoryExpression(lowerSelectExpression)));
            upperGraphExpansionBuilder.addAllQuantifiers(upperAliases.stream().map(alias -> Verify.verifyNotNull((Quantifier)aliasToQuantifierMap.get(alias))).collect(ImmutableList.toImmutableList()));
            upperGraphExpansionBuilder.addAllPredicates(immutableCollection);
            upperSelectExpression = upperGraphExpansionBuilder.build().buildSelectWithResultValue(resultValue);
        } else if (!lowersCorrelatedToByUpperAliases.isEmpty() || lowersCorrelatedToByUppers.size() == 1) {
            CorrelationIdentifier lowerAlias2 = lowersCorrelatedToByUpperAliases.isEmpty() ? (CorrelationIdentifier)Iterables.getOnlyElement(lowersCorrelatedToByUppers) : lowerAliasCorrelatedToByUpperAliases;
            SelectExpression lowerSelectExpression = lowerGraphExpansionBuilder.build().buildSelectWithResultValue(Verify.verifyNotNull(aliasToQuantifierMap.get(lowerAlias2)).getFlowedObjectValue());
            GraphExpansion.Builder upperGraphExpansionBuilder = GraphExpansion.builder();
            upperGraphExpansionBuilder.addQuantifier(((Quantifier.ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias(lowerAlias2)).build(call.memoizeExploratoryExpression(lowerSelectExpression)));
            upperGraphExpansionBuilder.addAllQuantifiers(upperAliases.stream().map(alias -> Verify.verifyNotNull((Quantifier)aliasToQuantifierMap.get(alias))).collect(ImmutableList.toImmutableList()));
            upperGraphExpansionBuilder.addAllPredicates(immutableCollection);
            upperSelectExpression = upperGraphExpansionBuilder.build().buildSelectWithResultValue(resultValue);
        } else {
            ImmutableList<Column<? extends Value>> lowerResultColumns = lowersCorrelatedToByUppers.stream().map(lowerAlias -> Verify.verifyNotNull((Quantifier)aliasToQuantifierMap.get(lowerAlias))).map(quantifier -> QuantifiedObjectValue.of(quantifier)).map(Column::unnamedOf).collect(ImmutableList.toImmutableList());
            RecordConstructorValue joinedResultValue = RecordConstructorValue.ofColumns(lowerResultColumns);
            SelectExpression lowerSelectExpression = lowerGraphExpansionBuilder.build().buildSelectWithResultValue(joinedResultValue);
            Quantifier.ForEach newUpperQuantifier = ((Quantifier.ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias(lowerAliasCorrelatedToByUpperAliases)).build(call.memoizeExploratoryExpression(lowerSelectExpression));
            RegularTranslationMap.Builder translationMapBuilder = TranslationMap.regularBuilder();
            int i = 0;
            while (i < lowerResultColumns.size()) {
                Column lowerResultColumn = (Column)lowerResultColumns.get(i);
                CorrelationIdentifier lowerAlias3 = ((QuantifiedObjectValue)lowerResultColumn.getValue()).getAlias();
                int index = i++;
                translationMapBuilder.when(lowerAlias3).then((sourceAlias, oldLeafValue) -> FieldValue.ofOrdinalNumber(QuantifiedObjectValue.of(newUpperQuantifier), index));
            }
            RegularTranslationMap translationMap = translationMapBuilder.build();
            ImmutableList newUpperPredicates = immutableCollection.stream().map(upperPredicate -> (QueryPredicate)upperPredicate.replaceLeavesMaybe(leafPredicate -> leafPredicate.translateLeafPredicate(translationMap, false)).orElseThrow(() -> new RecordCoreException("unable to map leaf predicate", new Object[0]))).collect(ImmutableList.toImmutableList());
            Value newResultValue = resultValue.translateCorrelations(translationMap);
            GraphExpansion.Builder upperGraphExpansionBuilder = GraphExpansion.builder();
            upperGraphExpansionBuilder.addQuantifier(newUpperQuantifier);
            upperGraphExpansionBuilder.addAllQuantifiers(upperAliases.stream().map(alias -> Verify.verifyNotNull((Quantifier)aliasToQuantifierMap.get(alias))).collect(ImmutableList.toImmutableList()));
            upperGraphExpansionBuilder.addAllPredicates(newUpperPredicates);
            upperSelectExpression = upperGraphExpansionBuilder.build().buildSelectWithResultValue(newResultValue);
        }
        call.yieldExploratoryExpression(upperSelectExpression);
    }

    private boolean isCrossProduct(@Nonnull Set<Set<CorrelationIdentifier>> independentQuantifiersPartitioning, @Nonnull Set<CorrelationIdentifier> lowerAliases, @Nonnull Set<CorrelationIdentifier> upperAliases) {
        for (Set<CorrelationIdentifier> independentPartition : independentQuantifiersPartitioning) {
            boolean isInLower = false;
            boolean isInUpper = false;
            for (CorrelationIdentifier alias : independentPartition) {
                if (lowerAliases.contains(alias)) {
                    isInLower = true;
                } else if (upperAliases.contains(alias)) {
                    isInUpper = true;
                }
                if (!isInLower || !isInUpper) continue;
                return false;
            }
        }
        return true;
    }
}

