/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.ExploratoryMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalDistinctExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUniqueExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitorWithDefaults;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PredicatePushDownRule
extends ExplorationCascadesRule<SelectExpression> {
    @Nonnull
    private static final CollectionMatcher<RelationalExpression> belowExpressionsMatcher = MultiMatcher.all(RelationalExpressionMatchers.anyExpression());
    @Nonnull
    private static final BindingMatcher<Reference> belowReferenceMatcher = ReferenceMatchers.exploratoryMembers(belowExpressionsMatcher);
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> forEachQuantifierMatcher = QuantifierMatchers.forEachQuantifierWithoutDefaultOnEmptyOverRef(belowReferenceMatcher);
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(forEachQuantifierMatcher).where(RelationalExpressionMatchers.isExploratoryExpression());

    public PredicatePushDownRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ExplorationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        Quantifier.ForEach pushQuantifier = bindings.get(forEachQuantifierMatcher);
        Set<CorrelationIdentifier> otherAliases = Quantifiers.aliases(() -> selectExpression.getQuantifiers().stream().map(quantifier -> quantifier).filter(quantifier -> !quantifier.getAlias().equals(pushQuantifier.getAlias())).iterator());
        Map partitionedPredicates = selectExpression.getPredicates().stream().collect(Collectors.partitioningBy(queryPredicate -> queryPredicate.getCorrelatedTo().stream().noneMatch(otherAliases::contains), LinkedIdentitySet.toLinkedIdentitySet()));
        Set pushablePredicates = partitionedPredicates.get(true);
        if (pushablePredicates.isEmpty()) {
            return;
        }
        Set fixedPredicates = partitionedPredicates.get(false);
        PushToVisitor pushToVisitor = new PushToVisitor(call, pushablePredicates, pushQuantifier);
        LinkedIdentitySet newBelowExpressions = new LinkedIdentitySet();
        Collection belowExpressions = (Collection)((Object)bindings.get(belowExpressionsMatcher));
        for (RelationalExpression belowExpression : belowExpressions) {
            ((Optional)pushToVisitor.visit(belowExpression)).ifPresent(newBelowExpressions::add);
        }
        if (newBelowExpressions.isEmpty()) {
            return;
        }
        Reference newRangesOverReference = call.memoizeExploratoryExpressions(newBelowExpressions);
        Quantifier.ForEach newPushQuantifier = ((Quantifier.ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias(pushQuantifier.getAlias())).build(newRangesOverReference);
        ImmutableList newOwnedQuantifiers = selectExpression.getQuantifiers().stream().map(quantifier -> quantifier.getAlias().equals(pushQuantifier.getAlias()) ? newPushQuantifier : quantifier).collect(ImmutableList.toImmutableList());
        SelectExpression newSelectExpression = new SelectExpression(selectExpression.getResultValue(), newOwnedQuantifiers, ImmutableList.copyOf(fixedPredicates));
        call.yieldExploratoryExpression(newSelectExpression);
    }

    private static class PushToVisitor
    implements RelationalExpressionVisitorWithDefaults<Optional<? extends RelationalExpression>> {
        @Nonnull
        private final ExploratoryMemoizer memoizer;
        @Nonnull
        private final Set<? extends QueryPredicate> originalPredicates;
        @Nonnull
        private final Quantifier.ForEach pushQuantifier;

        public PushToVisitor(@Nonnull ExploratoryMemoizer memoizer, @Nonnull Set<? extends QueryPredicate> originalPredicates, @Nonnull Quantifier.ForEach pushQuantifier) {
            this.memoizer = memoizer;
            this.originalPredicates = originalPredicates;
            this.pushQuantifier = pushQuantifier;
        }

        @Nonnull
        private Set<? extends QueryPredicate> getOriginalPredicates() {
            return this.originalPredicates;
        }

        @Nonnull
        private Quantifier.ForEach getPushQuantifier() {
            return this.pushQuantifier;
        }

        @Nonnull
        private List<QueryPredicate> updatedPredicates(@Nonnull TranslationMap translationMap, @Nonnull Collection<? extends QueryPredicate> preExistingPredicates) {
            ImmutableCollection.Builder predicatesBuilder = ImmutableList.builderWithExpectedSize(this.getOriginalPredicates().size() + preExistingPredicates.size()).addAll(preExistingPredicates);
            for (QueryPredicate queryPredicate : this.getOriginalPredicates()) {
                ((ImmutableList.Builder)predicatesBuilder).add(queryPredicate.translateCorrelations(translationMap, true));
            }
            return ((ImmutableList.Builder)predicatesBuilder).build();
        }

        @Nonnull
        private List<QueryPredicate> updatedPredicates(@Nonnull TranslationMap translationMap) {
            return this.updatedPredicates(translationMap, ImmutableList.of());
        }

        @Nonnull
        public Quantifier.ForEach pushOverChild(@Nonnull Quantifier.ForEach child) {
            RegularTranslationMap translationMap = TranslationMap.rebaseWithAliasMap(AliasMap.ofAliases(this.getPushQuantifier().getAlias(), child.getAlias()));
            List<QueryPredicate> newPredicates = this.updatedPredicates(translationMap);
            SelectExpression newSelect = new SelectExpression(child.getFlowedObjectValue(), ImmutableList.of(child), newPredicates);
            return Quantifier.forEach(this.memoizer.memoizeExploratoryExpression(newSelect));
        }

        @Nonnull
        public Optional<List<Quantifier>> pushOverChildren(@Nonnull RelationalExpressionWithChildren expressionWithChildren) {
            ImmutableList.Builder newChildrenBuilder = ImmutableList.builderWithExpectedSize(expressionWithChildren.getRelationalChildCount());
            for (Quantifier quantifier : expressionWithChildren.getQuantifiers()) {
                if (!(quantifier instanceof Quantifier.ForEach)) {
                    return Optional.empty();
                }
                newChildrenBuilder.add(this.pushOverChild((Quantifier.ForEach)quantifier));
            }
            return Optional.of(newChildrenBuilder.build());
        }

        @Nonnull
        public Optional<Quantifier> pushOverChildSingleChild(@Nonnull RelationalExpressionWithChildren expressionWithChildren) {
            List<? extends Quantifier> oldChildren = expressionWithChildren.getQuantifiers();
            if (oldChildren.size() != 1) {
                return Optional.empty();
            }
            Quantifier oldChild = Iterables.getOnlyElement(oldChildren);
            if (!(oldChild instanceof Quantifier.ForEach)) {
                return Optional.empty();
            }
            return Optional.of(this.pushOverChild((Quantifier.ForEach)oldChild));
        }

        @Override
        @Nonnull
        public Optional<SelectExpression> visitLogicalFilterExpression(@Nonnull LogicalFilterExpression logicalFilterExpression) {
            Quantifier inner = logicalFilterExpression.getInner();
            if (!(inner instanceof Quantifier.ForEach)) {
                return Optional.empty();
            }
            RegularTranslationMap translationMap = TranslationMap.rebaseWithAliasMap(AliasMap.ofAliases(this.getPushQuantifier().getAlias(), inner.getAlias()));
            List<QueryPredicate> newPredicates = this.updatedPredicates(translationMap, logicalFilterExpression.getPredicates());
            return Optional.of(new SelectExpression(inner.getFlowedObjectValue(), ImmutableList.of(inner), newPredicates));
        }

        @Override
        @Nonnull
        public Optional<SelectExpression> visitSelectExpression(@Nonnull SelectExpression selectExpression) {
            RegularTranslationMap translationMap = TranslationMap.regularBuilder().when(this.getPushQuantifier().getAlias()).then((sourceAlias, leafValue) -> selectExpression.getResultValue()).build();
            List<QueryPredicate> newPredicates = this.updatedPredicates(translationMap, selectExpression.getPredicates());
            return Optional.of(new SelectExpression(selectExpression.getResultValue(), selectExpression.getQuantifiers(), newPredicates));
        }

        @Override
        @Nonnull
        public Optional<GroupByExpression> visitGroupByExpression(@Nonnull GroupByExpression groupByExpression) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<LogicalUnionExpression> visitLogicalUnionExpression(@Nonnull LogicalUnionExpression unionExpression) {
            return this.pushOverChildren(unionExpression).map(LogicalUnionExpression::new);
        }

        @Override
        @Nonnull
        public Optional<LogicalSortExpression> visitLogicalSortExpression(@Nonnull LogicalSortExpression sortExpression) {
            return this.pushOverChildSingleChild(sortExpression).map(newChild -> new LogicalSortExpression(sortExpression.getOrdering(), (Quantifier)newChild));
        }

        @Override
        @Nonnull
        public Optional<LogicalDistinctExpression> visitLogicalDistinctExpression(@Nonnull LogicalDistinctExpression element) {
            return this.pushOverChildSingleChild(element).map(LogicalDistinctExpression::new);
        }

        @Override
        @Nonnull
        public Optional<LogicalUniqueExpression> visitLogicalUniqueExpression(@Nonnull LogicalUniqueExpression element) {
            return this.pushOverChildSingleChild(element).map(LogicalUniqueExpression::new);
        }

        @Override
        @Nonnull
        public Optional<RelationalExpression> visitDefault(@Nonnull RelationalExpression element) {
            return Optional.empty();
        }
    }
}

