/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.MatchPartition;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalDistinctExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUniqueExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MatchPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PartialMatchMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.LeafQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateWithDnfRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.Simplification;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PredicateToLogicalUnionRule
extends CascadesRule<MatchPartition> {
    public static final int DEFAULT_MAX_NUM_CONJUNCTS = 9;
    @Nonnull
    private static final BindingMatcher<Quantifier> qunMatcher = QuantifierMatchers.anyQuantifier();
    @Nonnull
    private static final CollectionMatcher<QueryPredicate> combinationPredicateMatcher = MultiMatcher.all(QueryPredicateMatchers.anyPredicate());
    @Nonnull
    private static final BindingMatcher<SelectExpression> expressionMatcher = RelationalExpressionMatchers.selectExpression(PredicateToLogicalUnionRule.nonTrivialPredicates(PredicateToLogicalUnionRule.limitedPredicateCombinations(combinationPredicateMatcher)), MultiMatcher.all(qunMatcher));
    private static final BindingMatcher<PartialMatch> anyPartialMatchMatcher = PartialMatchMatchers.anyPartialMatch();
    private static final BindingMatcher<MatchPartition> rootMatcher = MatchPartitionMatchers.ofExpressionAndMatches(expressionMatcher, MultiMatcher.all(anyPartialMatchMatcher));

    public PredicateToLogicalUnionRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(expressionMatcher);
        Value resultValue = selectExpression.getResultValue();
        List<Quantifier> quantifiers = bindings.getAll(qunMatcher);
        List<PartialMatch> matches = bindings.getAll(anyPartialMatchMatcher);
        ImmutableSet ownedForEachAliases = quantifiers.stream().filter(quantifier -> quantifier instanceof Quantifier.ForEach).map(Quantifier::getAlias).collect(ImmutableSet.toImmutableSet());
        if (ownedForEachAliases.size() != 1) {
            return;
        }
        boolean isSimpleResultValue = resultValue instanceof QuantifiedObjectValue && ownedForEachAliases.contains(((QuantifiedObjectValue)resultValue).getAlias());
        Set<CorrelationIdentifier> resultValueCorrelatedTo = resultValue.getCorrelatedTo();
        Sets.SetView<CorrelationIdentifier> referredOwnedForEachAliases = Sets.intersection(resultValueCorrelatedTo, ownedForEachAliases);
        Verify.verify(referredOwnedForEachAliases.size() <= 1);
        Optional<Object> referredAliasByResultOptional = referredOwnedForEachAliases.isEmpty() ? Optional.empty() : Optional.of(Iterables.getOnlyElement(referredOwnedForEachAliases));
        LinkedIdentitySet fixedPredicates = LinkedIdentitySet.copyOf((Iterable)((Object)bindings.get(combinationPredicateMatcher)));
        Set toBeDnfPredicates = selectExpression.getPredicates().stream().filter(predicate -> !fixedPredicates.contains(predicate)).collect(LinkedIdentitySet.toLinkedIdentitySet());
        if (toBeDnfPredicates.isEmpty()) {
            return;
        }
        LinkedIdentitySet partiallyMatchedOrs = new LinkedIdentitySet();
        for (PartialMatch match : matches) {
            MatchInfo.RegularMatchInfo matchInfo = match.getRegularMatchInfo();
            PredicateMultiMap predicateMap = matchInfo.getPredicateMap();
            predicateMap.values().stream().flatMap(predicateMapping -> predicateMapping.getMappingKind() == PredicateMultiMap.PredicateMapping.MappingKind.OR_TERM_IMPLIES_CANDIDATE ? Stream.of(predicateMapping.getOriginalQueryPredicate()) : Stream.empty()).forEach(partiallyMatchedOrs::add);
        }
        if (toBeDnfPredicates.stream().anyMatch(predicate -> predicate instanceof OrPredicate && !partiallyMatchedOrs.contains(predicate))) {
            return;
        }
        QueryPredicate conjunctedPredicate = AndPredicate.and(toBeDnfPredicates);
        Sets.SetView<CorrelationIdentifier> constantAliases = Sets.difference(conjunctedPredicate.getCorrelatedTo(), Quantifiers.aliases(selectExpression.getQuantifiers()));
        QueryPredicate dnfPredicate = Simplification.optimize(conjunctedPredicate, EvaluationContext.empty(), AliasMap.emptyMap(), constantAliases, QueryPredicateWithDnfRuleSet.ofSimplificationRules()).getUnconstrained();
        if (dnfPredicate.isAtomic() || !(dnfPredicate instanceof OrPredicate)) {
            return;
        }
        Map<CorrelationIdentifier, Quantifier> aliasToQuantifierMap = Quantifiers.aliasToQuantifierMap(quantifiers);
        Quantifier onlyNeededForEachQuantifier = aliasToQuantifierMap.get(Iterables.getOnlyElement(ownedForEachAliases));
        QuantifiedObjectValue lowerResultValue = onlyNeededForEachQuantifier.getFlowedObjectValue();
        ImmutableSet fixedPredicatesCorrelatedTo = fixedPredicates.stream().flatMap(p -> p.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet());
        Set fixedAtomicPredicates = fixedPredicates.stream().map(predicate -> predicate.withAtomicity(true)).collect(LinkedIdentitySet.toLinkedIdentitySet());
        ArrayList<Reference> references = Lists.newArrayList();
        for (QueryPredicate orTermPredicate : dnfPredicate.getChildren()) {
            Set<CorrelationIdentifier> orTermCorrelatedTo = orTermPredicate.getCorrelatedTo();
            ImmutableList neededAdditionalQuantifiers = quantifiers.stream().filter(quantifier -> quantifier instanceof Quantifier.Existential && (orTermCorrelatedTo.contains(quantifier.getAlias()) || fixedPredicatesCorrelatedTo.contains(quantifier.getAlias()))).map(quantifier -> ((Quantifier.Existential.ExistentialBuilder)Quantifier.existentialBuilder().withAlias(quantifier.getAlias())).build(((Quantifier)aliasToQuantifierMap.get(quantifier.getAlias())).getRangesOver())).collect(ImmutableList.toImmutableList());
            ImmutableList neededForEachQuantifiers = ownedForEachAliases.stream().map(alias -> ((Quantifier.ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias((CorrelationIdentifier)alias)).build(((Quantifier)aliasToQuantifierMap.get(alias)).getRangesOver())).collect(ImmutableList.toImmutableList());
            SelectExpression selectExpressionLeg = new SelectExpression(lowerResultValue, ImmutableList.copyOf(Iterables.concat(neededForEachQuantifiers, neededAdditionalQuantifiers)), (List<? extends QueryPredicate>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)fixedAtomicPredicates)).add(orTermPredicate)).build()));
            Reference memoizedSelectExpressionLeg = call.memoizeExploratoryExpression(selectExpressionLeg);
            LogicalUniqueExpression uniqueExpressionLeg = new LogicalUniqueExpression(Quantifier.forEach(memoizedSelectExpressionLeg));
            Reference memoizedUniqueExpressionLeg = call.memoizeExploratoryExpression(uniqueExpressionLeg);
            references.add(memoizedUniqueExpressionLeg);
        }
        Memoizer.ReferenceBuilder unionReferenceBuilder = call.memoizeExploratoryExpressionBuilder(new LogicalUnionExpression(Quantifiers.forEachQuantifiers(references)));
        unionReferenceBuilder = call.memoizeExploratoryExpressionBuilder(new LogicalDistinctExpression(Quantifier.forEach(unionReferenceBuilder.reference())));
        if (!isSimpleResultValue) {
            Reference unionReference = unionReferenceBuilder.reference();
            Quantifier.ForEach unionQuantifier = referredAliasByResultOptional.map(alias -> ((Quantifier.ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias((CorrelationIdentifier)alias)).build(unionReference)).orElse(Quantifier.forEach(unionReference));
            unionReferenceBuilder = call.memoizeExploratoryExpressionBuilder(new SelectExpression(resultValue, ImmutableList.of(unionQuantifier), ImmutableList.of()));
        }
        call.yieldExploratoryExpressions(unionReferenceBuilder.members());
    }

    private static CollectionMatcher<QueryPredicate> nonTrivialPredicates(@Nonnull CollectionMatcher<? extends QueryPredicate> downstream) {
        return CollectionMatcher.fromBindingMatcher(TypedMatcherWithExtractAndDownstream.typedWithDownstream(Collection.class, Extractor.of(predicates -> predicates.stream().filter(predicate -> !predicate.isAtomic() && !(predicate instanceof LeafQueryPredicate)).collect(ImmutableList.toImmutableList()), name -> "nonTrivialPredicates(" + name + ")"), downstream));
    }

    private static CollectionMatcher<QueryPredicate> limitedPredicateCombinations(@Nonnull CollectionMatcher<? extends QueryPredicate> downstream) {
        return CollectionMatcher.combinations(downstream, (plannerConfiguration, queryPredicates) -> 0, (plannerConfiguration, queryPredicates) -> queryPredicates.size() > plannerConfiguration.getOrToUnionMaxNumConjuncts() ? Math.min(queryPredicates.size(), 1) : queryPredicates.size());
    }
}

