/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class PullUpNullOnEmptyRule
extends ExplorationCascadesRule<SelectExpression> {
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> defaultOnEmptyQuantifier = QuantifierMatchers.forEachQuantifierWithDefaultOnEmptyOverRef(ReferenceMatchers.anyRef());
    @Nonnull
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(ListMatcher.exactly(defaultOnEmptyQuantifier));

    public PullUpNullOnEmptyRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ExplorationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        Quantifier.ForEach quantifier = bindings.get(defaultOnEmptyQuantifier);
        Set<RelationalExpression> childrenExpressions = quantifier.getRangesOver().getExploratoryExpressions();
        boolean pullUpDesired = false;
        for (RelationalExpression childExpression : childrenExpressions) {
            ExpressionClassification childClassification = this.classifyExpression(selectExpression, quantifier, childExpression);
            if (childClassification == ExpressionClassification.DO_NOT_PULL_UP) {
                return;
            }
            if (childClassification != ExpressionClassification.PULL_UP) continue;
            pullUpDesired = true;
        }
        if (!pullUpDesired) {
            return;
        }
        Quantifier.ForEach newChildrenQuantifier = ((Quantifier.ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias(quantifier.getAlias())).build(quantifier.getRangesOver());
        Reference newSelectExpression = call.memoizeExploratoryExpression(GraphExpansion.builder().addQuantifier(newChildrenQuantifier).addAllPredicates(selectExpression.getPredicates()).build().buildSimpleSelectOverQuantifier(newChildrenQuantifier));
        Quantifier.ForEach topLevelSelectQuantifier = Quantifier.forEachBuilder().from(quantifier).build(newSelectExpression);
        SelectExpression topLevelSelectExpression = GraphExpansion.builder().addQuantifier(topLevelSelectQuantifier).build().buildSelectWithResultValue(selectExpression.getResultValue());
        call.yieldExploratoryExpression(topLevelSelectExpression);
    }

    private ExpressionClassification classifyExpression(@Nonnull SelectExpression selectOnTopExpression, @Nonnull Quantifier.ForEach quantifier, @Nonnull RelationalExpression expression) {
        List<? extends QueryPredicate> otherPredicates;
        if (!(expression instanceof SelectExpression)) {
            return ExpressionClassification.DO_NOT_CARE;
        }
        SelectExpression selectExpression = (SelectExpression)expression;
        if (selectExpression.getQuantifiers().size() > 1) {
            return ExpressionClassification.PULL_UP;
        }
        if (!Iterables.getOnlyElement(selectExpression.getQuantifiers()).getAlias().equals(quantifier.getAlias())) {
            return ExpressionClassification.PULL_UP;
        }
        List<? extends QueryPredicate> predicates = selectOnTopExpression.getPredicates();
        return !predicates.equals(otherPredicates = selectExpression.getPredicates()) ? ExpressionClassification.PULL_UP : ExpressionClassification.DO_NOT_PULL_UP;
    }

    private static enum ExpressionClassification {
        DO_NOT_CARE,
        DO_NOT_PULL_UP,
        PULL_UP;

    }
}

