/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RecordQueryPlanMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

public class PushDistinctBelowFilterRule
extends ImplementationCascadesRule<RecordQueryUnorderedPrimaryKeyDistinctPlan> {
    @Nonnull
    private static final BindingMatcher<? extends Reference> innerRefMatcher = ReferenceMatchers.anyRefOverOnlyPlans();
    @Nonnull
    private static final BindingMatcher<Quantifier.Physical> innerQuantifierMatcher = QuantifierMatchers.physicalQuantifierOverRef(innerRefMatcher);
    @Nonnull
    private static final BindingMatcher<RecordQueryPredicatesFilterPlan> filterPlanMatcher = RecordQueryPlanMatchers.predicatesFilter(ListMatcher.exactly(innerQuantifierMatcher));
    @Nonnull
    private static final BindingMatcher<RecordQueryUnorderedPrimaryKeyDistinctPlan> root = RecordQueryPlanMatchers.unorderedPrimaryKeyDistinct(ListMatcher.exactly(QuantifierMatchers.physicalQuantifier(filterPlanMatcher)));

    public PushDistinctBelowFilterRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        Reference inner = call.get(innerRefMatcher);
        Quantifier.Physical qun = call.get(innerQuantifierMatcher);
        RecordQueryPredicatesFilterPlan filterPlan = call.get(filterPlanMatcher);
        RecordQueryUnorderedPrimaryKeyDistinctPlan newDistinctPlan = new RecordQueryUnorderedPrimaryKeyDistinctPlan(Quantifier.physical(inner));
        Quantifier.Physical newQun = Quantifier.physical(call.memoizePlan(newDistinctPlan));
        List rebasedPredicates = filterPlan.getPredicates().stream().map(queryPredicate -> queryPredicate.rebase(Quantifiers.translate(qun, newQun))).collect(ImmutableList.toImmutableList());
        call.yieldPlan(new RecordQueryPredicatesFilterPlan(newQun, rebasedPredicates));
    }
}

