/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RecordQueryPlanMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class PushFilterThroughFetchRule
extends ImplementationCascadesRule<RecordQueryPredicatesFilterPlan> {
    @Nonnull
    private static final BindingMatcher<RecordQueryPlan> innerPlanMatcher = RecordQueryPlanMatchers.anyPlan();
    @Nonnull
    private static final BindingMatcher<RecordQueryFetchFromPartialRecordPlan> fetchPlanMatcher = RecordQueryPlanMatchers.fetchFromPartialRecordPlan(innerPlanMatcher);
    @Nonnull
    private static final BindingMatcher<Quantifier.Physical> quantifierOverFetchMatcher = QuantifierMatchers.physicalQuantifier(fetchPlanMatcher);
    @Nonnull
    private static final BindingMatcher<RecordQueryPredicatesFilterPlan> root = RecordQueryPlanMatchers.predicatesFilter(quantifierOverFetchMatcher);

    public PushFilterThroughFetchRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        RecordQueryPredicatesFilterPlan filterPlan = bindings.get(root);
        RecordQueryFetchFromPartialRecordPlan fetchPlan = bindings.get(fetchPlanMatcher);
        Quantifier.Physical quantifierOverFetch = bindings.get(quantifierOverFetchMatcher);
        RecordQueryPlan innerPlan = bindings.get(innerPlanMatcher);
        List<? extends QueryPredicate> queryPredicates = filterPlan.getPredicates();
        ImmutableList.Builder pushedPredicatesBuilder = ImmutableList.builder();
        ImmutableList.Builder residualPredicatesBuilder = ImmutableList.builder();
        CorrelationIdentifier newInnerAlias = Quantifier.uniqueId();
        for (QueryPredicate queryPredicate : queryPredicates) {
            Optional pushedPredicateOptional = queryPredicate.replaceLeavesMaybe(leafPredicate -> this.pushLeafPredicate(fetchPlan, quantifierOverFetch.getAlias(), newInnerAlias, (QueryPredicate)leafPredicate));
            if (pushedPredicateOptional.isPresent()) {
                pushedPredicatesBuilder.add((QueryPredicate)pushedPredicateOptional.get());
                continue;
            }
            residualPredicatesBuilder.add(queryPredicate);
        }
        ImmutableCollection pushedPredicates = pushedPredicatesBuilder.build();
        ImmutableCollection immutableCollection = residualPredicatesBuilder.build();
        Verify.verify(pushedPredicates.size() + immutableCollection.size() == queryPredicates.size());
        if (pushedPredicates.isEmpty()) {
            return;
        }
        Quantifier.Physical newInnerQuantifier = Quantifier.physical(call.memoizePlan(innerPlan), newInnerAlias);
        RecordQueryPredicatesFilterPlan pushedFilterPlan = new RecordQueryPredicatesFilterPlan(newInnerQuantifier, pushedPredicates);
        Quantifier.Physical newQuantifierOverFilter = Quantifier.physical(call.memoizePlan(pushedFilterPlan));
        RecordQueryFetchFromPartialRecordPlan newFetchPlan = new RecordQueryFetchFromPartialRecordPlan(newQuantifierOverFilter, fetchPlan.getPushValueFunction(), Type.Relation.scalarOf(fetchPlan.getResultType()), fetchPlan.getFetchIndexRecords());
        if (immutableCollection.isEmpty()) {
            call.yieldPlan(newFetchPlan);
        } else {
            Quantifier.Physical newQuantifierOverFetch = Quantifier.physical(call.memoizePlan(newFetchPlan));
            AliasMap translationMap = AliasMap.ofAliases(quantifierOverFetch.getAlias(), newQuantifierOverFetch.getAlias());
            ImmutableList rebasedResidualPredicates = immutableCollection.stream().map(residualPredicate -> residualPredicate.rebase(translationMap)).collect(ImmutableList.toImmutableList());
            call.yieldPlan(new RecordQueryPredicatesFilterPlan(newQuantifierOverFetch, rebasedResidualPredicates));
        }
    }

    @Nullable
    private QueryPredicate pushLeafPredicate(@Nonnull RecordQueryFetchFromPartialRecordPlan fetchPlan, @Nonnull CorrelationIdentifier oldInnerAlias, @Nonnull CorrelationIdentifier newInnerAlias, @Nonnull QueryPredicate leafPredicate) {
        if (!(leafPredicate instanceof PredicateWithValue)) {
            return leafPredicate;
        }
        PredicateWithValue predicateWithValue = (PredicateWithValue)leafPredicate;
        Optional<? extends PredicateWithValue> pushedLeafPredicateOptional = predicateWithValue.translateValueAndComparisonsMaybe(value -> fetchPlan.pushValue((Value)value, oldInnerAlias, newInnerAlias), comparison -> comparison.replaceValuesMaybe(value -> fetchPlan.pushValue((Value)value, oldInnerAlias, newInnerAlias)));
        return pushedLeafPredicateOptional.orElse(null);
    }
}

