/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RecordQueryPlanMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushInJoinThroughFetchRule<P extends RecordQueryInJoinPlan>
extends ImplementationCascadesRule<P> {
    @Nonnull
    private static final BindingMatcher<RecordQueryPlan> innerPlanMatcher = RecordQueryPlanMatchers.anyPlan();
    @Nonnull
    private static final BindingMatcher<RecordQueryFetchFromPartialRecordPlan> fetchPlanMatcher = RecordQueryPlanMatchers.fetchFromPartialRecordPlan(innerPlanMatcher);
    @Nonnull
    private static final BindingMatcher<Quantifier.Physical> quantifierOverFetchMatcher = QuantifierMatchers.physicalQuantifier(fetchPlanMatcher);

    @Nonnull
    private static <P extends RecordQueryInJoinPlan> BindingMatcher<P> root(@Nonnull Class<P> planClass) {
        return RelationalExpressionMatchers.ofTypeOwning(planClass, AnyMatcher.any(quantifierOverFetchMatcher));
    }

    public PushInJoinThroughFetchRule(@Nonnull Class<P> planClass) {
        super(PushInJoinThroughFetchRule.root(planClass));
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        RecordQueryInJoinPlan inJoinPlan = (RecordQueryInJoinPlan)bindings.get(this.getMatcher());
        RecordQueryFetchFromPartialRecordPlan fetchPlan = bindings.get(fetchPlanMatcher);
        RecordQueryPlan innerPlan = bindings.get(innerPlanMatcher);
        RecordQueryPlanWithChild pushedInJoinPlan = inJoinPlan.withChild(call.memoizePlan(innerPlan));
        RecordQueryFetchFromPartialRecordPlan newFetchPlan = new RecordQueryFetchFromPartialRecordPlan(Quantifier.physical(call.memoizePlan(pushedInJoinPlan)), fetchPlan.getPushValueFunction(), Type.Relation.scalarOf(fetchPlan.getResultType()), fetchPlan.getFetchIndexRecords());
        call.yieldPlan(newFetchPlan);
    }
}

