/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RecordQueryPlanMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushMapThroughFetchRule
extends ImplementationCascadesRule<RecordQueryMapPlan> {
    @Nonnull
    private static final BindingMatcher<RecordQueryPlan> innerPlanMatcher = RecordQueryPlanMatchers.anyPlan();
    @Nonnull
    private static final BindingMatcher<RecordQueryFetchFromPartialRecordPlan> fetchPlanMatcher = RecordQueryPlanMatchers.fetchFromPartialRecordPlan(innerPlanMatcher);
    @Nonnull
    private static final BindingMatcher<Quantifier.Physical> quantifierOverFetchMatcher = QuantifierMatchers.physicalQuantifier(fetchPlanMatcher);
    @Nonnull
    private static final BindingMatcher<RecordQueryMapPlan> root = RecordQueryPlanMatchers.map(quantifierOverFetchMatcher);

    public PushMapThroughFetchRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        RecordQueryMapPlan mapPlan = bindings.get(root);
        RecordQueryFetchFromPartialRecordPlan fetchPlan = bindings.get(fetchPlanMatcher);
        Quantifier.Physical quantifierOverFetch = bindings.get(quantifierOverFetchMatcher);
        RecordQueryPlan innerPlan = bindings.get(innerPlanMatcher);
        Value resultValue = mapPlan.getResultValue();
        CorrelationIdentifier newInnerAlias = Quantifier.uniqueId();
        Optional<Value> pushedResultValueOptional = fetchPlan.pushValue(resultValue, quantifierOverFetch.getAlias(), newInnerAlias);
        if (pushedResultValueOptional.isEmpty()) {
            return;
        }
        Quantifier.Physical newInnerQuantifier = Quantifier.physical(call.memoizePlan(innerPlan), newInnerAlias);
        RecordQueryMapPlan pushedMapPlan = new RecordQueryMapPlan(newInnerQuantifier, pushedResultValueOptional.get());
        call.yieldPlan(pushedMapPlan);
    }
}

