/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.ReferencedFieldsConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalDistinctExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushReferencedFieldsThroughDistinctRule
extends CascadesRule<LogicalDistinctExpression>
implements PlannerRule.PreOrderRule {
    private static final BindingMatcher<Reference> lowerRefMatcher = ReferenceMatchers.anyRef();
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifierOverRef(lowerRefMatcher);
    private static final BindingMatcher<LogicalDistinctExpression> root = RelationalExpressionMatchers.logicalDistinctExpression(ListMatcher.exactly(innerQuantifierMatcher));

    public PushReferencedFieldsThroughDistinctRule() {
        super(root, ImmutableSet.of(ReferencedFieldsConstraint.REFERENCED_FIELDS));
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        Reference lowerRef = bindings.get(lowerRefMatcher);
        Optional<ReferencedFieldsConstraint.ReferencedFields> referencedFieldsOptional = call.getPlannerConstraintMaybe(ReferencedFieldsConstraint.REFERENCED_FIELDS);
        if (referencedFieldsOptional.isEmpty()) {
            return;
        }
        call.pushConstraint(lowerRef, ReferencedFieldsConstraint.REFERENCED_FIELDS, referencedFieldsOptional.get());
    }
}

