/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.ReferencedFieldsConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithPredicates;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushReferencedFieldsThroughFilterRule
extends CascadesRule<LogicalFilterExpression>
implements PlannerRule.PreOrderRule {
    private static final BindingMatcher<Reference> lowerRefMatcher = ReferenceMatchers.anyRef();
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifierOverRef(lowerRefMatcher);
    private static final BindingMatcher<QueryPredicate> predicateMatcher = QueryPredicateMatchers.anyPredicate();
    private static final BindingMatcher<LogicalFilterExpression> root = RelationalExpressionMatchers.logicalFilterExpression(MultiMatcher.all(predicateMatcher), ListMatcher.exactly(innerQuantifierMatcher));

    public PushReferencedFieldsThroughFilterRule() {
        super(root, ImmutableSet.of(ReferencedFieldsConstraint.REFERENCED_FIELDS));
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        List<QueryPredicate> predicates = bindings.getAll(predicateMatcher);
        ImmutableSet<FieldValue> fieldValuesFromPredicates = RelationalExpressionWithPredicates.fieldValuesFromPredicates(predicates);
        Reference lowerRef = bindings.get(lowerRefMatcher);
        ImmutableCollection allReferencedValues = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)call.getPlannerConstraintMaybe(ReferencedFieldsConstraint.REFERENCED_FIELDS).map(ReferencedFieldsConstraint.ReferencedFields::getReferencedFieldValues).orElse(ImmutableSet.of()))).addAll(fieldValuesFromPredicates)).build();
        call.pushConstraint(lowerRef, ReferencedFieldsConstraint.REFERENCED_FIELDS, new ReferencedFieldsConstraint.ReferencedFields((Set<FieldValue>)((Object)allReferencedValues)));
    }
}

