/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.Values;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.DefaultValueSimplificationRuleSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class PushRequestedOrderingThroughGroupByRule
extends CascadesRule<GroupByExpression>
implements PlannerRule.PreOrderRule {
    private static final BindingMatcher<Reference> lowerRefMatcher = ReferenceMatchers.anyRef();
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifierOverRef(lowerRefMatcher);
    @Nonnull
    private static final BindingMatcher<GroupByExpression> root = RelationalExpressionMatchers.groupByExpression(innerQuantifierMatcher);

    public PushRequestedOrderingThroughGroupByRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        GroupByExpression groupByExpression = bindings.get(root);
        Quantifier.ForEach innerQuantifier = bindings.get(innerQuantifierMatcher);
        Reference lowerRef = bindings.get(lowerRefMatcher);
        Set requestedOrderings = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING).orElse(ImmutableSet.of());
        Set<RequestedOrdering> refinedRequestedOrderings = this.collectCompatibleOrderings(call.getEvaluationContext(), groupByExpression, innerQuantifier, requestedOrderings);
        if (!refinedRequestedOrderings.isEmpty()) {
            call.pushConstraint(lowerRef, RequestedOrderingConstraint.REQUESTED_ORDERING, refinedRequestedOrderings);
        }
    }

    @Nonnull
    private Set<RequestedOrdering> collectCompatibleOrderings(@Nonnull EvaluationContext evaluationContext, @Nonnull GroupByExpression groupByExpression, @Nonnull Quantifier innerQuantifier, @Nonnull Set<RequestedOrdering> requestedOrderings) {
        Set<CorrelationIdentifier> correlatedTo = groupByExpression.getCorrelatedTo();
        Value resultValue = groupByExpression.getResultValue();
        Value groupingValue = groupByExpression.getGroupingValue();
        ImmutableSet.Builder toBePushedRequestedOrderingsBuilder = ImmutableSet.builder();
        for (RequestedOrdering requestedOrdering : requestedOrderings) {
            if (requestedOrdering.isPreserve()) {
                toBePushedRequestedOrderingsBuilder.add(groupByExpression.getRequestedOrdering());
                continue;
            }
            RequestedOrdering pushedRequestedOrdering = requestedOrdering.pushDown(resultValue, innerQuantifier.getAlias(), evaluationContext, AliasMap.emptyMap(), correlatedTo);
            if (groupingValue == null || groupingValue.isConstant()) {
                toBePushedRequestedOrderingsBuilder.add(RequestedOrdering.preserve());
                continue;
            }
            Value currentGroupingValue = groupingValue.rebase(AliasMap.ofAliases(innerQuantifier.getAlias(), Quantifier.current()));
            List<Value> primitivesValues = Values.primitiveAccessorsForType(currentGroupingValue.getResultType(), () -> currentGroupingValue);
            List<Value> primitivesSimplifiedValues = Values.simplify(primitivesValues, DefaultValueSimplificationRuleSet.instance(), evaluationContext, AliasMap.emptyMap(), correlatedTo);
            LinkedHashSet<Value> requiredOrderingValues = new LinkedHashSet<Value>(primitivesSimplifiedValues);
            ImmutableList.Builder resultOrderingPartsBuilder = ImmutableList.builder();
            boolean isPushedAndRequiredCompatible = true;
            for (OrderingPart.RequestedOrderingPart pushedRequestedOrderingPart : pushedRequestedOrdering.getOrderingParts()) {
                if (requiredOrderingValues.remove(pushedRequestedOrderingPart.getValue())) {
                    resultOrderingPartsBuilder.add(pushedRequestedOrderingPart);
                    continue;
                }
                isPushedAndRequiredCompatible = false;
                break;
            }
            if (!isPushedAndRequiredCompatible) continue;
            if (pushedRequestedOrdering.isDistinct()) {
                if (!requiredOrderingValues.isEmpty()) continue;
            }
            requiredOrderingValues.stream().map(value -> new OrderingPart.RequestedOrderingPart((Value)value, OrderingPart.RequestedSortOrder.ANY)).forEach(resultOrderingPartsBuilder::add);
            toBePushedRequestedOrderingsBuilder.add(RequestedOrdering.ofPrimitiveParts((List<OrderingPart.RequestedOrderingPart>)((Object)resultOrderingPartsBuilder.build()), pushedRequestedOrdering.getDistinctness(), false));
        }
        return toBePushedRequestedOrderingsBuilder.build();
    }
}

