/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushRequestedOrderingThroughInLikeSelectRule
extends CascadesRule<SelectExpression>
implements PlannerRule.PreOrderRule {
    private static final BindingMatcher<ExplodeExpression> explodeExpressionMatcher = RelationalExpressionMatchers.explodeExpression();
    private static final CollectionMatcher<Quantifier.ForEach> explodeQuantifiersMatcher = MultiMatcher.some(QuantifierMatchers.forEachQuantifier(explodeExpressionMatcher));
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(explodeQuantifiersMatcher);

    public PushRequestedOrderingThroughInLikeSelectRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        Collection explodeQuantifiers;
        Optional<Set<RequestedOrdering>> requestedOrderingsOptional = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING);
        if (requestedOrderingsOptional.isEmpty()) {
            return;
        }
        Set<RequestedOrdering> requestedOrderings = requestedOrderingsOptional.get();
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        Optional<Quantifier.ForEach> innerForEachQuantifierOptional = PushRequestedOrderingThroughInLikeSelectRule.findInnerQuantifier(selectExpression, explodeQuantifiers = (Collection)((Object)bindings.get(explodeQuantifiersMatcher)), Quantifiers.aliases(explodeQuantifiers));
        if (innerForEachQuantifierOptional.isEmpty()) {
            return;
        }
        Quantifier.ForEach innerForEachQuantifier = innerForEachQuantifierOptional.get();
        Value resultValue = selectExpression.getResultValue();
        if (!(resultValue instanceof QuantifiedObjectValue) || !((QuantifiedObjectValue)resultValue).getAlias().equals(innerForEachQuantifier.getAlias())) {
            return;
        }
        Reference lowerReference = innerForEachQuantifier.getRangesOver();
        call.pushConstraint(lowerReference, RequestedOrderingConstraint.REQUESTED_ORDERING, requestedOrderings);
    }

    @Nonnull
    public static Optional<Quantifier.ForEach> findInnerQuantifier(@Nonnull SelectExpression selectExpression, @Nonnull Collection<? extends Quantifier> explodeQuantifiers, @Nonnull Set<CorrelationIdentifier> explodeAliases) {
        List<? extends Quantifier> quantifiers = selectExpression.getQuantifiers();
        if (explodeQuantifiers.size() + 1 != quantifiers.size()) {
            return Optional.empty();
        }
        Optional<Quantifier.ForEach> innerQuantifierOptional = quantifiers.stream().filter(quantifier -> quantifier instanceof Quantifier.ForEach && !explodeAliases.contains(quantifier.getAlias())).map(quantifier -> quantifier.narrow(Quantifier.ForEach.class)).findAny();
        return innerQuantifierOptional.flatMap(innerQuantifier -> {
            Set<CorrelationIdentifier> correlatedTo = innerQuantifier.getCorrelatedTo();
            return correlatedTo.containsAll(explodeAliases) ? Optional.of(innerQuantifier) : Optional.empty();
        });
    }
}

