/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.InsertExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushRequestedOrderingThroughInsertRule
extends CascadesRule<InsertExpression>
implements PlannerRule.PreOrderRule {
    private static final BindingMatcher<Reference> lowerRefMatcher = ReferenceMatchers.anyRef();
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifierOverRef(lowerRefMatcher);
    private static final BindingMatcher<InsertExpression> root = RelationalExpressionMatchers.insertExpression(innerQuantifierMatcher);

    public PushRequestedOrderingThroughInsertRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        Optional<Set<RequestedOrdering>> requestedOrderingsOptional = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING);
        if (requestedOrderingsOptional.isEmpty()) {
            return;
        }
        Set<RequestedOrdering> requestedOrderings = requestedOrderingsOptional.get();
        PlannerBindings bindings = call.getBindings();
        InsertExpression insertExpression = bindings.get(root);
        Quantifier.ForEach innerQuantifier = bindings.get(innerQuantifierMatcher);
        Reference lowerRef = bindings.get(lowerRefMatcher);
        ImmutableSet.Builder pushedRequestedOrderingsBuilder = ImmutableSet.builder();
        for (RequestedOrdering requestedOrdering : requestedOrderings) {
            if (requestedOrdering.isPreserve()) {
                pushedRequestedOrderingsBuilder.add(requestedOrdering);
                continue;
            }
            pushedRequestedOrderingsBuilder.add(requestedOrdering.pushDown(QuantifiedObjectValue.of(innerQuantifier), innerQuantifier.getAlias(), call.getEvaluationContext(), AliasMap.emptyMap(), insertExpression.getCorrelatedTo()));
        }
        call.pushConstraint(lowerRef, RequestedOrderingConstraint.REQUESTED_ORDERING, pushedRequestedOrderingsBuilder.build());
    }
}

