/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RecursiveUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushRequestedOrderingThroughRecursiveUnionRule
extends CascadesRule<RecursiveUnionExpression>
implements PlannerRule.PreOrderRule {
    @Nonnull
    private static final BindingMatcher<Reference> initialRefMatcher = ReferenceMatchers.anyRef();
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> initialQunMatcher = QuantifierMatchers.forEachQuantifierOverRef(initialRefMatcher);
    @Nonnull
    private static final BindingMatcher<Reference> recursiveRefMatcher = ReferenceMatchers.anyRef();
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> recursiveQunMatcher = QuantifierMatchers.forEachQuantifierOverRef(recursiveRefMatcher);
    @Nonnull
    private static final BindingMatcher<RecursiveUnionExpression> root = RelationalExpressionMatchers.recursiveUnionExpression(initialQunMatcher, recursiveQunMatcher);

    public PushRequestedOrderingThroughRecursiveUnionRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        Optional<Set<RequestedOrdering>> requestedOrderingsOptional = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING);
        if (requestedOrderingsOptional.isEmpty()) {
            return;
        }
        Set<RequestedOrdering> requestedOrderings = requestedOrderingsOptional.get();
        Optional<RequestedOrdering> preserveOrderingMaybe = requestedOrderings.stream().filter(RequestedOrdering::isPreserve).findFirst();
        if (preserveOrderingMaybe.isEmpty()) {
            return;
        }
        ImmutableSet<RequestedOrdering> toBePushedOrdering = ImmutableSet.of(preserveOrderingMaybe.get());
        PlannerBindings bindings = call.getBindings();
        Reference initialRef = bindings.get(initialRefMatcher);
        call.pushConstraint(initialRef, RequestedOrderingConstraint.REQUESTED_ORDERING, toBePushedOrdering);
        Reference recursiveRef = bindings.get(recursiveRefMatcher);
        call.pushConstraint(recursiveRef, RequestedOrderingConstraint.REQUESTED_ORDERING, toBePushedOrdering);
    }
}

