/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushRequestedOrderingThroughSelectRule
extends CascadesRule<SelectExpression>
implements PlannerRule.PreOrderRule {
    @Nonnull
    private static final BindingMatcher<Reference> lowerRefMatcher = ReferenceMatchers.anyRef();
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifierOverRef(lowerRefMatcher);
    @Nonnull
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(AnyMatcher.any(innerQuantifierMatcher));

    public PushRequestedOrderingThroughSelectRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        Quantifier.ForEach innerQuantifier = bindings.get(innerQuantifierMatcher);
        Reference lowerRef = bindings.get(lowerRefMatcher);
        boolean isInnerQuantifierOnlyForEach = selectExpression.getQuantifiers().stream().filter(quantifier -> quantifier instanceof Quantifier.ForEach).allMatch(quantifier -> quantifier == innerQuantifier);
        Set requestedOrderings = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING).orElse(ImmutableSet.of());
        if (!isInnerQuantifierOnlyForEach && requestedOrderings.stream().anyMatch(requestedOrdering -> !requestedOrdering.isPreserve())) {
            return;
        }
        Value resultValue = selectExpression.getResultValue();
        ImmutableSet.Builder toBePushedRequestedOrderingsBuilder = ImmutableSet.builder();
        for (RequestedOrdering requestedOrdering2 : requestedOrderings) {
            if (requestedOrdering2.isPreserve()) {
                toBePushedRequestedOrderingsBuilder.add(RequestedOrdering.preserve());
                continue;
            }
            toBePushedRequestedOrderingsBuilder.add(requestedOrdering2.pushDown(resultValue, innerQuantifier.getAlias(), call.getEvaluationContext(), AliasMap.emptyMap(), selectExpression.getCorrelatedTo()));
        }
        call.pushConstraint(lowerRef, RequestedOrderingConstraint.REQUESTED_ORDERING, toBePushedRequestedOrderingsBuilder.build());
    }
}

