/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushRequestedOrderingThroughSortRule
extends CascadesRule<LogicalSortExpression>
implements PlannerRule.PreOrderRule {
    private static final BindingMatcher<Reference> lowerRefMatcher = ReferenceMatchers.anyRef();
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifierOverRef(lowerRefMatcher);
    private static final BindingMatcher<LogicalSortExpression> root = RelationalExpressionMatchers.logicalSortExpression(ListMatcher.exactly(innerQuantifierMatcher));

    public PushRequestedOrderingThroughSortRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        LogicalSortExpression logicalSortExpression = bindings.get(root);
        Quantifier.ForEach innerQuantifier = bindings.get(innerQuantifierMatcher);
        Reference lowerRef = bindings.get(lowerRefMatcher);
        RequestedOrdering requestedOrdering = logicalSortExpression.getOrdering();
        if (requestedOrdering.isPreserve()) {
            call.pushConstraint(lowerRef, RequestedOrderingConstraint.REQUESTED_ORDERING, Set.of(requestedOrdering));
        } else {
            AliasMap translationMap = AliasMap.ofAliases(innerQuantifier.getAlias(), Quantifier.current());
            ImmutableList.Builder translatedBuilder = ImmutableList.builder();
            for (OrderingPart.RequestedOrderingPart orderingPart : requestedOrdering.getOrderingParts()) {
                translatedBuilder.add(new OrderingPart.RequestedOrderingPart(orderingPart.getValue().rebase(translationMap), (OrderingPart.RequestedSortOrder)orderingPart.getSortOrder()));
            }
            Set<RequestedOrdering> orderings = Set.of(RequestedOrdering.ofPrimitiveParts((List<OrderingPart.RequestedOrderingPart>)((Object)translatedBuilder.build()), requestedOrdering.getDistinctness(), false));
            call.pushConstraint(lowerRef, RequestedOrderingConstraint.REQUESTED_ORDERING, orderings);
        }
    }
}

