/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushRequestedOrderingThroughUnionRule
extends CascadesRule<LogicalUnionExpression>
implements PlannerRule.PreOrderRule {
    private static final BindingMatcher<Reference> lowerRefMatcher = ReferenceMatchers.anyRef();
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifierOverRef(lowerRefMatcher);
    private static final BindingMatcher<LogicalUnionExpression> root = RelationalExpressionMatchers.logicalUnionExpression(MultiMatcher.all(innerQuantifierMatcher));

    public PushRequestedOrderingThroughUnionRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        Optional<Set<RequestedOrdering>> requestedOrderingsOptional = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING);
        if (requestedOrderingsOptional.isEmpty()) {
            return;
        }
        Set<RequestedOrdering> requestedOrderings = requestedOrderingsOptional.get();
        ImmutableSet exhaustiveRequestedOrderings = requestedOrderings.stream().map(RequestedOrdering::exhaustive).collect(ImmutableSet.toImmutableSet());
        PlannerBindings bindings = call.getBindings();
        List<Quantifier.ForEach> rangesOverQuantifiers = bindings.getAll(innerQuantifierMatcher);
        for (int i = 0; i < rangesOverQuantifiers.size(); ++i) {
            Quantifier.ForEach rangesOverQuantifier = rangesOverQuantifiers.get(i);
            call.pushConstraint(rangesOverQuantifier.getRangesOver(), RequestedOrderingConstraint.REQUESTED_ORDERING, i == 0 ? exhaustiveRequestedOrderings : requestedOrderings);
        }
        Quantifier.ForEach firstQuantifier = Objects.requireNonNull(Iterables.getFirst(rangesOverQuantifiers, null));
        call.pushConstraint(firstQuantifier.getRangesOver(), RequestedOrderingConstraint.REQUESTED_ORDERING, exhaustiveRequestedOrderings);
    }
}

