/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RecordQueryPlanMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.apple.foundationdb.record.query.plan.plans.TranslateValueFunction;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushSetOperationThroughFetchRule<P extends RecordQuerySetPlan>
extends ImplementationCascadesRule<P> {
    @Nonnull
    private static final BindingMatcher<RecordQueryFetchFromPartialRecordPlan> fetchPlanMatcher = RecordQueryPlanMatchers.fetchFromPartialRecordPlan(RecordQueryPlanMatchers.anyPlan());
    @Nonnull
    private static final BindingMatcher<Quantifier.Physical> quantifierOverFetchMatcher = QuantifierMatchers.physicalQuantifier(fetchPlanMatcher);

    @Nonnull
    private static <P extends RecordQuerySetPlan> BindingMatcher<P> root(@Nonnull Class<P> planClass) {
        return RelationalExpressionMatchers.ofTypeOwning(planClass, MultiMatcher.some(quantifierOverFetchMatcher));
    }

    public PushSetOperationThroughFetchRule(@Nonnull Class<P> planClass) {
        super(PushSetOperationThroughFetchRule.root(planClass));
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        RecordQuerySetPlan setOperationPlan = (RecordQuerySetPlan)bindings.get(this.getMatcher());
        List<Quantifier.Physical> quantifiersOverFetches = bindings.getAll(quantifierOverFetchMatcher);
        if (setOperationPlan.isDynamic() ? quantifiersOverFetches.size() < setOperationPlan.getQuantifiers().size() : quantifiersOverFetches.size() <= 1) {
            return;
        }
        List<RecordQueryFetchFromPartialRecordPlan> fetchPlans = bindings.getAll(fetchPlanMatcher);
        ImmutableList<TranslateValueFunction> dependentFunctions = fetchPlans.stream().map(RecordQueryFetchFromPartialRecordPlan::getPushValueFunction).collect(ImmutableList.toImmutableList());
        Verify.verify(quantifiersOverFetches.size() == fetchPlans.size());
        Verify.verify(fetchPlans.size() == dependentFunctions.size());
        CorrelationIdentifier sourceAlias = Quantifier.uniqueId();
        List<? extends Value> requiredValues = setOperationPlan.getRequiredValues(sourceAlias, Quantifiers.getFlowedTypeForSetOperation(quantifiersOverFetches));
        Set<CorrelationIdentifier> pushableAliases = setOperationPlan.tryPushValues(dependentFunctions, quantifiersOverFetches, requiredValues, sourceAlias);
        if (setOperationPlan.isDynamic() ? pushableAliases.size() < setOperationPlan.getQuantifiers().size() : pushableAliases.size() <= 1) {
            return;
        }
        ImmutableList.Builder pushableQuantifiersBuilder = ImmutableList.builder();
        ImmutableList.Builder pushableFetchPlansBuilder = ImmutableList.builder();
        ImmutableList.Builder pushableDependentFunctionsBuilder = ImmutableList.builder();
        for (int i = 0; i < quantifiersOverFetches.size(); ++i) {
            Quantifier.Physical quantifier2 = quantifiersOverFetches.get(i);
            if (!pushableAliases.contains(quantifier2.getAlias())) continue;
            pushableQuantifiersBuilder.add(quantifier2);
            pushableFetchPlansBuilder.add(fetchPlans.get(i));
            pushableDependentFunctionsBuilder.add((TranslateValueFunction)dependentFunctions.get(i));
        }
        ImmutableCollection pushableQuantifiers = pushableQuantifiersBuilder.build();
        ImmutableCollection pushableFetchPlans = pushableFetchPlansBuilder.build();
        ImmutableCollection pushableDependentFunctions = pushableDependentFunctionsBuilder.build();
        ImmutableList nonPushableQuantifiers = setOperationPlan.getQuantifiers().stream().map(quantifier -> (Quantifier.Physical)quantifier).filter(quantifier -> !pushableAliases.contains(quantifier.getAlias())).collect(ImmutableList.toImmutableList());
        RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords = null;
        for (RecordQueryFetchFromPartialRecordPlan pushableFetchPlan : pushableFetchPlans) {
            if (fetchIndexRecords == null) {
                fetchIndexRecords = pushableFetchPlan.getFetchIndexRecords();
                continue;
            }
            if (fetchIndexRecords == pushableFetchPlan.getFetchIndexRecords()) continue;
            return;
        }
        List newPushedInnerPlans = pushableFetchPlans.stream().map(RecordQueryFetchFromPartialRecordPlan::getChild).map(call::memoizePlan).collect(ImmutableList.toImmutableList());
        Verify.verify(pushableQuantifiers.size() + nonPushableQuantifiers.size() == setOperationPlan.getQuantifiers().size());
        TranslateValueFunction combinedTranslateValueFunction = setOperationPlan.pushValueFunction((List<TranslateValueFunction>)((Object)pushableDependentFunctions));
        RecordQuerySetPlan newSetOperationPlan = setOperationPlan.withChildrenReferences(newPushedInnerPlans);
        RecordQueryFetchFromPartialRecordPlan newFetchPlan = new RecordQueryFetchFromPartialRecordPlan(Quantifier.physical(call.memoizePlan(newSetOperationPlan)), combinedTranslateValueFunction, Type.Relation.scalarOf(setOperationPlan.getResultType()), Verify.verifyNotNull(fetchIndexRecords));
        if (nonPushableQuantifiers.isEmpty()) {
            call.yieldPlan(newFetchPlan);
        } else {
            List newFetchPlanAndResidualInners = Streams.concat(Stream.of(call.memoizePlan(newFetchPlan)), nonPushableQuantifiers.stream().map(Quantifier.Physical::getRangesOver)).collect(ImmutableList.toImmutableList());
            call.yieldPlan(setOperationPlan.withChildrenReferences(newFetchPlanAndResidualInners));
        }
    }
}

