/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RecordQueryPlanMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PushTypeFilterBelowFilterRule
extends ImplementationCascadesRule<RecordQueryTypeFilterPlan> {
    private static final BindingMatcher<? extends Reference> innerMatcher = ReferenceMatchers.anyRefOverOnlyPlans();
    private static final BindingMatcher<Quantifier.Physical> qunMatcher = QuantifierMatchers.physicalQuantifierOverRef(innerMatcher);
    private static final BindingMatcher<QueryPredicate> predMatcher = QueryPredicateMatchers.anyPredicate();
    private static final BindingMatcher<RecordQueryTypeFilterPlan> root = RecordQueryPlanMatchers.typeFilter(ListMatcher.exactly(QuantifierMatchers.physicalQuantifier(RecordQueryPlanMatchers.predicatesFilter(MultiMatcher.all(predMatcher), ListMatcher.exactly(qunMatcher)))));

    public PushTypeFilterBelowFilterRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        Reference inner = bindings.get(innerMatcher);
        Quantifier.Physical qun = bindings.get(qunMatcher);
        List<QueryPredicate> predicates = bindings.getAll(predMatcher);
        Collection<String> recordTypes = bindings.get(root).getRecordTypes();
        RecordQueryTypeFilterPlan newTypeFilterPlan = new RecordQueryTypeFilterPlan(Quantifier.physical(inner), recordTypes, new Type.Any());
        Quantifier.Physical newQun = Quantifier.physical(call.memoizePlan(newTypeFilterPlan));
        List rebasedPredicates = predicates.stream().map(queryPredicate -> queryPredicate.rebase(Quantifiers.translate(qun, newQun))).collect(ImmutableList.toImmutableList());
        call.yieldPlan(new RecordQueryPredicatesFilterPlan(newQun, rebasedPredicates));
    }
}

