/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Constrained;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.ConstantFoldingRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.Simplification;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class QueryPredicateSimplificationRule
extends ExplorationCascadesRule<SelectExpression> {
    @Nonnull
    private static final CollectionMatcher<QueryPredicate> predicateMatcher = MultiMatcher.atLeastOne(QueryPredicateMatchers.anyPredicate());
    @Nonnull
    private static final BindingMatcher<SelectExpression> rootMatcher = RelationalExpressionMatchers.selectExpression(predicateMatcher, MultiMatcher.all(QuantifierMatchers.anyQuantifier())).where(RelationalExpressionMatchers.isExploratoryExpression());

    public QueryPredicateSimplificationRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ExplorationCascadesRuleCall call) {
        SelectExpression selectExpression = call.get(rootMatcher);
        Collection predicates = (Collection)((Object)call.get(predicateMatcher));
        QueryPredicate conjunction = AndPredicate.and(predicates);
        AliasMap aliasMap = AliasMap.emptyMap();
        Sets.SetView<CorrelationIdentifier> constantAliases = Sets.difference(conjunction.getCorrelatedTo(), Quantifiers.aliases(selectExpression.getQuantifiers()));
        Constrained<QueryPredicate> simplifiedConjunction = Simplification.optimize(conjunction, call.getEvaluationContext(), aliasMap, constantAliases, ConstantFoldingRuleSet.ofSimplificationRules());
        if (simplifiedConjunction.get().semanticEquals((Object)conjunction, aliasMap)) {
            return;
        }
        Value resultValue = selectExpression.getResultValue();
        List<? extends Quantifier> quantifier = selectExpression.getQuantifiers();
        SelectExpression simplifiedSelectExpression = simplifiedConjunction instanceof AndPredicate ? new SelectExpression(resultValue, quantifier, (List<? extends QueryPredicate>)((AndPredicate)((Object)simplifiedConjunction)).getChildren()) : new SelectExpression(resultValue, quantifier, ImmutableList.of(simplifiedConjunction.get()));
        call.yieldExploratoryExpression(simplifiedSelectExpression);
    }
}

