/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TableFunctionExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RangeValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamingValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

public class RemoveRangeOneRule
extends ExplorationCascadesRule<SelectExpression> {
    @Nonnull
    private static final BindingMatcher<TableFunctionExpression> tfExpression = RelationalExpressionMatchers.tableFunctionExpression();
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> middleQun = QuantifierMatchers.forEachQuantifierOverRef(ReferenceMatchers.exploratoryMember(tfExpression));
    @Nonnull
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(AnyMatcher.any(middleQun));
    @Nonnull
    private static final RangeValue EXPECTED = (RangeValue)new RangeValue.RangeFn().encapsulate(List.of(LiteralValue.ofScalar(1L)));

    public RemoveRangeOneRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ExplorationCascadesRuleCall call) {
        SelectExpression select = call.get(root);
        if (select.getQuantifiers().size() == 1) {
            return;
        }
        TableFunctionExpression tf = call.get(tfExpression);
        StreamingValue value = tf.getValue();
        if (!(value instanceof RangeValue)) {
            return;
        }
        RangeValue rangeValue = (RangeValue)value;
        if (!EXPECTED.equals(rangeValue)) {
            return;
        }
        Quantifier.ForEach qun = call.get(middleQun);
        CorrelationIdentifier id = qun.getAlias();
        if (select.getResultValue().isCorrelatedTo(id) || select.getPredicates().stream().anyMatch(predicate -> predicate.isCorrelatedTo(id)) || select.getQuantifiers().stream().anyMatch(childQun -> childQun != qun && childQun.isCorrelatedTo(id))) {
            return;
        }
        call.yieldExploratoryExpression(new SelectExpression(select.getResultValue(), select.getQuantifiers().stream().filter(otherQun -> otherQun != qun).collect(ImmutableList.toImmutableList()), select.getPredicates()));
    }
}

