/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlanPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.properties.DistinctRecordsProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.OrderingProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.PrimaryKeyProperty;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RemoveSortRule
extends ImplementationCascadesRule<LogicalSortExpression> {
    @Nonnull
    private static final BindingMatcher<PlanPartition> innerPlanPartitionMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Reference> innerReferenceMatcher = PlanPartitionMatchers.planPartitions(PlanPartitionMatchers.rollUpPartitionsTo(AnyMatcher.any(innerPlanPartitionMatcher), ImmutableSet.of(OrderingProperty.ordering(), DistinctRecordsProperty.distinctRecords(), PrimaryKeyProperty.primaryKey())));
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifierOverRef(innerReferenceMatcher);
    @Nonnull
    private static final BindingMatcher<LogicalSortExpression> root = RelationalExpressionMatchers.logicalSortExpression(ListMatcher.exactly(innerQuantifierMatcher));

    public RemoveSortRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        LogicalSortExpression sortExpression = call.get(root);
        PlanPartition innerPlanPartition = call.get(innerPlanPartitionMatcher);
        RequestedOrdering requestedOrdering = sortExpression.getOrdering();
        if (requestedOrdering.isPreserve()) {
            call.yieldPlans(innerPlanPartition.getPlans());
            return;
        }
        List<OrderingPart.RequestedOrderingPart> requestedOrderingParts = requestedOrdering.getOrderingParts();
        Set sortValuesSet = requestedOrderingParts.stream().map(OrderingPart::getValue).collect(Collectors.toSet());
        Ordering ordering = innerPlanPartition.getPartitionPropertyValue(OrderingProperty.ordering());
        Set<Value> equalityBoundKeys = ordering.getEqualityBoundValues();
        int equalityBoundUnsorted = equalityBoundKeys.size();
        for (OrderingPart.RequestedOrderingPart requestedPart : requestedOrderingParts) {
            if (!equalityBoundKeys.contains(requestedPart.getValue())) continue;
            --equalityBoundUnsorted;
        }
        boolean isSatisfyingOrdering = ordering.satisfies(requestedOrdering.withDistinctness(RequestedOrdering.Distinctness.PRESERVE_DISTINCTNESS));
        if (!isSatisfyingOrdering) {
            return;
        }
        boolean isDistinct = innerPlanPartition.getPartitionPropertyValue(DistinctRecordsProperty.distinctRecords());
        if (isDistinct && ordering.getOrderingSet().getSet().stream().allMatch(value -> sortValuesSet.contains(value) || equalityBoundKeys.contains(value))) {
            Set strictlySortedInnerPlans = innerPlanPartition.getPlans().stream().map(plan -> plan.strictlySorted(call)).collect(LinkedIdentitySet.toLinkedIdentitySet());
            call.yieldPlans(strictlySortedInnerPlans);
        }
        LinkedIdentitySet<RecordQueryPlan> resultExpressions = new LinkedIdentitySet<RecordQueryPlan>();
        for (RecordQueryPlan innerPlan : innerPlanPartition.getPlans()) {
            boolean strictOrdered = RemoveSortRule.strictlyOrderedIfUnique(innerPlan, requestedOrderingParts.size() + equalityBoundUnsorted);
            if (strictOrdered) {
                resultExpressions.add(innerPlan.strictlySorted(call));
                continue;
            }
            resultExpressions.add(innerPlan);
        }
        call.yieldPlans(resultExpressions);
    }

    private static boolean strictlyOrderedIfUnique(@Nonnull RecordQueryPlan orderedPlan, int numKeys) {
        RecordQueryIndexPlan indexPlan;
        Optional<? extends MatchCandidate> matchCandidateOptional;
        if (orderedPlan instanceof RecordQueryCoveringIndexPlan) {
            orderedPlan = ((RecordQueryCoveringIndexPlan)orderedPlan).getIndexPlan();
        }
        if (orderedPlan instanceof RecordQueryIndexPlan && (matchCandidateOptional = (indexPlan = (RecordQueryIndexPlan)orderedPlan).getMatchCandidateMaybe()).isPresent()) {
            MatchCandidate matchCandidate = matchCandidateOptional.get();
            return matchCandidate.isUnique() && numKeys >= matchCandidate.getColumnSize();
        }
        return false;
    }
}

