/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionPartition;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithPredicates;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ExpressionsPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.properties.ExpressionCountProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.PredicateComplexityProperty;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SelectMergeRule
extends ImplementationCascadesRule<SelectExpression> {
    @Nonnull
    private static final BindingMatcher<RelationalExpressionWithPredicates> childExpressionMatcher = RelationalExpressionMatchers.withPredicatesExpression();
    @Nonnull
    private static final BindingMatcher<ExpressionPartition<RelationalExpression>> childPartitionsMatcher = ExpressionsPartitionMatchers.argmin(ExpressionsPartitionMatchers.comparisonByPropertyList(ExpressionCountProperty.selectCount(), ExpressionCountProperty.tableFunctionCount(), PredicateComplexityProperty.predicateComplexity()), childExpressionMatcher);
    @Nonnull
    private static final BindingMatcher<Reference> childReferenceMatcher = ExpressionsPartitionMatchers.expressionPartitions(ExpressionsPartitionMatchers.rollUpPartitions(AnyMatcher.any(ExpressionsPartitionMatchers.filterExpressions(e -> e instanceof RelationalExpressionWithPredicates, childPartitionsMatcher))));
    @Nonnull
    private static final CollectionMatcher<Quantifier.ForEach> quantifiersMatcher = MultiMatcher.some(QuantifierMatchers.forEachQuantifierWithoutDefaultOnEmptyOverRef(childReferenceMatcher));
    @Nonnull
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(quantifiersMatcher).where(RelationalExpressionMatchers.isExploratoryExpression());

    public SelectMergeRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        Collection quantifiers = (Collection)((Object)bindings.get(quantifiersMatcher));
        List<RelationalExpressionWithPredicates> childSelectExpressions = bindings.getAll(childExpressionMatcher);
        SelectExpression selectExpression = bindings.get(root);
        PartiallyOrderedSet<CorrelationIdentifier> correlationOrder = selectExpression.getCorrelationOrder().dualOrder();
        ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> dependencyMap = correlationOrder.getDependencyMap();
        ImmutableMap<CorrelationIdentifier, RelationalExpressionWithPredicates> mergeableChildren = Streams.zip(quantifiers.stream(), childSelectExpressions.stream(), (left, right) -> NonnullPair.of(left.getAlias(), right)).filter(pair -> dependencyMap.get((Object)((CorrelationIdentifier)pair.getLeft())).isEmpty()).collect(ImmutableMap.toImmutableMap(NonnullPair::getLeft, NonnullPair::getRight));
        if (mergeableChildren.isEmpty()) {
            return;
        }
        boolean atLeastOneQuantifierIsMergeable = selectExpression.getQuantifiers().stream().map(Quantifier::getAlias).map(mergeableChildren::get).anyMatch(Objects::nonNull);
        if (!atLeastOneQuantifierIsMergeable) {
            return;
        }
        HashSet<CorrelationIdentifier> newQunAliases = new HashSet<CorrelationIdentifier>();
        ImmutableList.Builder newQuantifiers = ImmutableList.builder();
        ImmutableList.Builder newPredicates = ImmutableList.builder();
        RegularTranslationMap.Builder translationBuilder = TranslationMap.regularBuilder();
        for (Quantifier quantifier : selectExpression.getQuantifiers()) {
            CorrelationIdentifier alias = quantifier.getAlias();
            RelationalExpressionWithPredicates childSelectExpression = mergeableChildren.get(alias);
            if (childSelectExpression != null) {
                AliasMap.Builder childAliasMapBuilder = AliasMap.builder();
                for (Quantifier quantifier2 : childSelectExpression.getQuantifiers()) {
                    if (newQunAliases.add(quantifier2.getAlias())) continue;
                    CorrelationIdentifier newAlias = Quantifier.uniqueId();
                    childAliasMapBuilder.put(quantifier2.getAlias(), newAlias);
                    newQunAliases.add(newAlias);
                }
                RegularTranslationMap childAliasMap = TranslationMap.rebaseWithAliasMap(childAliasMapBuilder.build());
                if (childAliasMap.definesOnlyIdentities()) {
                    newQuantifiers.addAll(childSelectExpression.getQuantifiers());
                    newPredicates.addAll(childSelectExpression.getPredicates());
                } else {
                    newQuantifiers.addAll(Quantifiers.rebaseGraphs(childSelectExpression.getQuantifiers(), (Memoizer)((Object)call), childAliasMap, false));
                    childSelectExpression.getPredicates().stream().map(predicate -> predicate.translateCorrelations(childAliasMap, false)).forEach(newPredicates::add);
                }
                translationBuilder.when(alias).then((ignored1, ignored2) -> childSelectExpression.getResultValue().translateCorrelations(childAliasMap));
                continue;
            }
            Verify.verify(newQunAliases.add(quantifier.getAlias()), "alias %s duplicated in pulled up children", (Object)quantifier.getAlias());
            Reference childReference = quantifier.getRangesOver();
            Reference newChildReference = call.memoizeFinalExpressionsFromOther(childReference, childReference.getFinalExpressions());
            newQuantifiers.add(quantifier.overNewReference(newChildReference));
        }
        RegularTranslationMap translationMap = translationBuilder.build();
        selectExpression.getPredicates().forEach(predicate -> newPredicates.add(predicate.translateCorrelations(translationMap, true)));
        SelectExpression selectExpression2 = new SelectExpression(selectExpression.getResultValue().translateCorrelations(translationMap, true), (List<? extends Quantifier>)((Object)newQuantifiers.build()), (List<? extends QueryPredicate>)((Object)newPredicates.build()));
        call.yieldFinalExpression(selectExpression2);
    }
}

