/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class SplitSelectExtractIndependentQuantifiersRule
extends ExplorationCascadesRule<SelectExpression> {
    private static final BindingMatcher<ExplodeExpression> explodeExpressionMatcher = RelationalExpressionMatchers.explodeExpression();
    private static final CollectionMatcher<Quantifier.ForEach> explodeQuantifiersMatcher = MultiMatcher.some(QuantifierMatchers.forEachQuantifier(explodeExpressionMatcher));
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(explodeQuantifiersMatcher);

    public SplitSelectExtractIndependentQuantifiersRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ExplorationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        Collection explodeQuantifiers = (Collection)((Object)bindings.get(explodeQuantifiersMatcher));
        if (explodeQuantifiers.isEmpty()) {
            return;
        }
        ImmutableSet<CorrelationIdentifier> explodeAliases = explodeQuantifiers.stream().map(Quantifier::getAlias).collect(ImmutableSet.toImmutableSet());
        if (this.isSimpleSelect(selectExpression, explodeAliases)) {
            return;
        }
        ImmutableSet allAliasesInExpression = selectExpression.getQuantifiers().stream().map(Quantifier::getAlias).collect(ImmutableSet.toImmutableSet());
        PartiallyOrderedSet.Builder<CorrelationIdentifier> aliasesPartialOrderBuilder = PartiallyOrderedSet.builder();
        for (Quantifier quantifier2 : selectExpression.getQuantifiers()) {
            CorrelationIdentifier alias = quantifier2.getAlias();
            Set<CorrelationIdentifier> correlatedTo = quantifier2.getCorrelatedTo();
            Sets.SetView localCorrelatedTo = Sets.intersection(allAliasesInExpression, correlatedTo);
            aliasesPartialOrderBuilder.add(alias);
            localCorrelatedTo.forEach(dependentAlias -> aliasesPartialOrderBuilder.addDependency(alias, (CorrelationIdentifier)dependentAlias));
        }
        PartiallyOrderedSet aliasesPartialOrder = aliasesPartialOrderBuilder.build();
        Set set = aliasesPartialOrder.eligibleSet().eligibleElements();
        Map partitionedQuantifiers = selectExpression.getQuantifiers().stream().collect(Collectors.partitioningBy(quantifier -> explodeAliases.contains(quantifier.getAlias()) && eligibleAliases.contains(quantifier.getAlias()), ImmutableList.toImmutableList()));
        ImmutableList lowerQuantifiers = partitionedQuantifiers.get(false);
        ImmutableList upperQuantifiers = partitionedQuantifiers.get(true);
        if (lowerQuantifiers.isEmpty() || upperQuantifiers.isEmpty()) {
            return;
        }
        if (lowerQuantifiers.stream().noneMatch(quantifier -> quantifier instanceof Quantifier.ForEach)) {
            return;
        }
        SelectExpression lowerSelectExpression = new SelectExpression(selectExpression.getResultValue(), lowerQuantifiers, selectExpression.getPredicates());
        Quantifier.ForEach lowerQuantifier = Quantifier.forEach(call.memoizeExploratoryExpression(lowerSelectExpression));
        SelectExpression upperSelectExpression = new SelectExpression(lowerQuantifier.getFlowedObjectValue(), (List<? extends Quantifier>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)upperQuantifiers)).add(lowerQuantifier)).build()), ImmutableList.of());
        call.yieldExploratoryExpression(upperSelectExpression);
    }

    private boolean isSimpleSelect(@Nonnull SelectExpression selectExpression, @Nonnull Set<CorrelationIdentifier> explodeAliases) {
        if (!selectExpression.getPredicates().isEmpty()) {
            return false;
        }
        return selectExpression.getResultValues().stream().flatMap(resultValue -> resultValue.getCorrelatedTo().stream()).noneMatch(explodeAliases::contains);
    }
}

