/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchPartition;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.WithPrimaryKeyMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MatchPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PartialMatchMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.rules.AbstractDataAccessRule;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class WithPrimaryKeyDataAccessRule
extends AbstractDataAccessRule {
    private static final BindingMatcher<PartialMatch> completeMatchMatcher = PartialMatchMatchers.completeMatch().and(PartialMatchMatchers.matchingWithPrimaryKeyMatchCandidate());
    private static final BindingMatcher<RelationalExpression> expressionMatcher = RelationalExpressionMatchers.anyExpression();
    private static final BindingMatcher<MatchPartition> rootMatcher = MatchPartitionMatchers.ofExpressionAndMatches(expressionMatcher, MultiMatcher.some(completeMatchMatcher));

    public WithPrimaryKeyDataAccessRule() {
        super(rootMatcher, completeMatchMatcher, expressionMatcher);
    }

    @Override
    @Nonnull
    protected AbstractDataAccessRule.IntersectionResult createIntersectionAndCompensation(@Nonnull Memoizer memoizer, @Nonnull Map<BitSet, AbstractDataAccessRule.IntersectionInfo> intersectionInfoMap, @Nonnull Map<PartialMatch, RecordQueryPlan> matchToPlanMap, @Nonnull List<AbstractDataAccessRule.Vectored<AbstractDataAccessRule.SingleMatchedAccess>> partition, @Nonnull Set<RequestedOrdering> requestedOrderings) {
        Verify.verify(partition.size() > 1);
        ImmutableList partitionAccesses = partition.stream().map(AbstractDataAccessRule.Vectored::getElement).collect(ImmutableList.toImmutableList());
        Optional<List<Value>> commonPrimaryKeyValuesOptional = WithPrimaryKeyDataAccessRule.commonPrimaryKeyValuesMaybe(partitionAccesses.stream().map(AbstractDataAccessRule.SingleMatchedAccess::getPartialMatch).collect(ImmutableList.toImmutableList()));
        if (commonPrimaryKeyValuesOptional.isEmpty()) {
            return AbstractDataAccessRule.IntersectionResult.noViableIntersection();
        }
        List<Value> commonPrimaryKeyValues = commonPrimaryKeyValuesOptional.get();
        ImmutableList<NonnullPair<List<OrderingPart.MatchedOrderingPart>, Boolean>> partitionOrderings = partitionAccesses.stream().map(AbstractDataAccessRule::adjustMatchedOrderingParts).collect(ImmutableList.toImmutableList());
        Ordering.Intersection intersectionOrdering = WithPrimaryKeyDataAccessRule.intersectOrderings(partitionOrderings);
        ImmutableSet<Value> equalityBoundKeyValues = partitionOrderings.stream().flatMap(orderingPartsPair -> ((List)orderingPartsPair.getKey()).stream().filter(boundOrderingKey -> boundOrderingKey.getComparisonRangeType() == ComparisonRange.Type.EQUALITY).map(OrderingPart::getValue)).collect(ImmutableSet.toImmutableSet());
        boolean isPartitionRedundant = WithPrimaryKeyDataAccessRule.isPartitionRedundant(intersectionInfoMap, partition, equalityBoundKeyValues);
        if (isPartitionRedundant) {
            return AbstractDataAccessRule.IntersectionResult.noViableIntersection();
        }
        Compensation compensation = partitionAccesses.stream().map(AbstractDataAccessRule.SingleMatchedAccess::getCompensation).reduce(Compensation.impossibleCompensation(), Compensation::intersect);
        Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction = realizedAlias -> WithPrimaryKeyDataAccessRule.matchedToRealizedTranslationMap(partition, realizedAlias);
        AbstractDataAccessRule.SingleMatchedAccess firstMatchedAccess = partition.get(0).getElement();
        TranslationMap topToTopTranslationMap = firstMatchedAccess.getTopToTopTranslationMap();
        boolean hasCommonOrdering = false;
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        HashSet<List<OrderingPart.ProvidedOrderingPart>> seenComparisonOrderingParts = new HashSet<List<OrderingPart.ProvidedOrderingPart>>();
        for (RequestedOrdering requestedOrdering : requestedOrderings) {
            RequestedOrdering translatedRequestedOrdering = requestedOrdering.translateCorrelations(topToTopTranslationMap, true);
            Iterable<List<Value>> comparisonKeyValuesIterable = intersectionOrdering.enumerateSatisfyingComparisonKeyValues(translatedRequestedOrdering);
            for (List<Value> comparisonKeyValues : comparisonKeyValuesIterable) {
                if (!WithPrimaryKeyDataAccessRule.isCompatibleComparisonKey(comparisonKeyValues, commonPrimaryKeyValues, equalityBoundKeyValues)) continue;
                hasCommonOrdering = true;
                if (compensation.isImpossible()) continue;
                List<OrderingPart.ProvidedOrderingPart> comparisonOrderingParts = intersectionOrdering.directionalOrderingParts(comparisonKeyValues, translatedRequestedOrdering, OrderingPart.ProvidedSortOrder.FIXED);
                boolean comparisonIsReverse = RecordQuerySetPlan.resolveComparisonDirection(comparisonOrderingParts);
                if (seenComparisonOrderingParts.contains(comparisonOrderingParts = RecordQuerySetPlan.adjustFixedBindings(comparisonOrderingParts, comparisonIsReverse))) continue;
                seenComparisonOrderingParts.add(comparisonOrderingParts);
                ImmutableList<Quantifier.Physical> newQuantifiers = partition.stream().map(pair -> Objects.requireNonNull((RecordQueryPlan)matchToPlanMap.get(((AbstractDataAccessRule.SingleMatchedAccess)pair.getElement()).getPartialMatch()))).map(memoizer::memoizePlan).map(Quantifier::physical).collect(ImmutableList.toImmutableList());
                RecordQueryIntersectionOnValuesPlan intersectionPlan = RecordQueryIntersectionPlan.fromQuantifiers(newQuantifiers, comparisonOrderingParts, comparisonIsReverse);
                RelationalExpression compensatedIntersection = compensation.applyAllNeededCompensations(memoizer, intersectionPlan, matchedToRealizedTranslationMapFunction);
                expressionsBuilder.add(compensatedIntersection);
            }
        }
        return AbstractDataAccessRule.IntersectionResult.of(hasCommonOrdering ? intersectionOrdering : null, compensation, (List<RelationalExpression>)((Object)expressionsBuilder.build()));
    }

    @Nonnull
    protected static Optional<List<Value>> commonPrimaryKeyValuesMaybe(@Nonnull Iterable<? extends PartialMatch> partialMatches) {
        Verify.verify(!Iterables.isEmpty(partialMatches));
        List<Value> common = null;
        boolean first = true;
        for (PartialMatch partialMatch : partialMatches) {
            Optional<List<Value>> keyMaybe;
            MatchCandidate matchCandidate = partialMatch.getMatchCandidate();
            if (matchCandidate instanceof WithPrimaryKeyMatchCandidate) {
                WithPrimaryKeyMatchCandidate withPrimaryKeyMatchCandidate = (WithPrimaryKeyMatchCandidate)matchCandidate;
                keyMaybe = withPrimaryKeyMatchCandidate.getPrimaryKeyValuesMaybe();
                if (keyMaybe.isEmpty()) {
                    return Optional.empty();
                }
            } else {
                return Optional.empty();
            }
            List<Value> key = keyMaybe.get();
            if (first) {
                common = key;
                first = false;
                continue;
            }
            if (common.equals(key)) continue;
            return Optional.empty();
        }
        return Optional.of(Objects.requireNonNull(common));
    }

    @Nonnull
    private static TranslationMap matchedToRealizedTranslationMap(@Nonnull List<AbstractDataAccessRule.Vectored<AbstractDataAccessRule.SingleMatchedAccess>> partition, @Nonnull CorrelationIdentifier realizedAlias) {
        RegularTranslationMap.Builder translationMapBuilder = RegularTranslationMap.builder();
        for (AbstractDataAccessRule.Vectored<AbstractDataAccessRule.SingleMatchedAccess> singleMatchedAccessWithIndex : partition) {
            translationMapBuilder.when(singleMatchedAccessWithIndex.getElement().getCandidateTopAlias()).then((sourceAlias, leafValue) -> leafValue.rebaseLeaf(realizedAlias));
        }
        return translationMapBuilder.build();
    }
}

