/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.typing;

import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.TupleFieldsProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.planprotos.PType;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.query.plan.cascades.Narrowable;
import com.apple.foundationdb.record.query.plan.cascades.NullableArrayTypeUtils;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.util.ProtoUtils;
import com.apple.foundationdb.util.StringUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Type
extends Narrowable<Type>,
PlanSerializable {
    @Nonnull
    public static final Null NULL = new Null();
    @Nonnull
    public static final None NONE = new None();
    @Nonnull
    public static final Uuid UUID_NULL_INSTANCE = new Uuid(true);
    @Nonnull
    public static final Uuid UUID_NON_NULL_INSTANCE = new Uuid(false);
    @Nonnull
    public static final Supplier<BiMap<Class<?>, TypeCode>> CLASS_TO_TYPE_CODE_SUPPLIER = Suppliers.memoize(() -> TypeCode.computeClassToTypeCodeMap());

    public TypeCode getTypeCode();

    default public Class<?> getJavaClass() {
        return this.getTypeCode().getJavaClass();
    }

    default public boolean isPrimitive() {
        return this.getTypeCode().isPrimitive();
    }

    default public boolean isAny() {
        return this.getTypeCode().equals((Object)TypeCode.ANY);
    }

    default public boolean isArray() {
        return this.getTypeCode().equals((Object)TypeCode.ARRAY);
    }

    default public boolean isRecord() {
        return this.getTypeCode().equals((Object)TypeCode.RECORD);
    }

    default public boolean isRelation() {
        return this.getTypeCode().equals((Object)TypeCode.RELATION);
    }

    default public boolean isEnum() {
        return this.getTypeCode().equals((Object)TypeCode.ENUM);
    }

    default public boolean isUuid() {
        return false;
    }

    public boolean isNullable();

    default public boolean isNotNullable() {
        return !this.isNullable();
    }

    default public Type nullable() {
        return this.withNullability(true);
    }

    default public Type notNullable() {
        return this.withNullability(false);
    }

    @Nonnull
    public Type withNullability(boolean var1);

    @Nonnull
    default public Type overrideIfNullable(boolean shouldBeNullable) {
        if (shouldBeNullable && !this.isNullable()) {
            return this.withNullability(true);
        }
        return this;
    }

    @Nonnull
    default public Optional<Array> narrowArrayMaybe() {
        if (this.isArray()) {
            return Optional.of((Array)this);
        }
        return Optional.empty();
    }

    @Nonnull
    default public Optional<Record> narrowRecordMaybe() {
        if (this.isRecord()) {
            return Optional.of((Record)this);
        }
        return Optional.empty();
    }

    @Nonnull
    default public Optional<Enum> narrowEnumMaybe() {
        if (this.isEnum()) {
            return Optional.of((Enum)this);
        }
        return Optional.empty();
    }

    default public boolean isNumeric() {
        return this.getTypeCode().isNumeric();
    }

    default public boolean isUnresolved() {
        TypeCode typeCode = this.getTypeCode();
        return typeCode == TypeCode.UNKNOWN;
    }

    @Nonnull
    public ExplainTokens describe();

    default public void defineProtoType(TypeRepository.Builder typeRepositoryBuilder) {
    }

    public void addProtoField(@Nonnull TypeRepository.Builder var1, @Nonnull DescriptorProtos.DescriptorProto.Builder var2, int var3, @Nonnull String var4, @Nonnull Optional<String> var5, @Nonnull DescriptorProtos.FieldDescriptorProto.Label var6);

    @Nullable
    default public <T> T validateObject(@Nullable T object) {
        if (object == null) {
            Verify.verify(this.isNullable());
        } else {
            Verify.verify(this.nullable().equals(Type.fromObject(object).nullable()));
        }
        return object;
    }

    @Nonnull
    public static Map<Class<?>, TypeCode> getClassToTypeCodeMap() {
        return CLASS_TO_TYPE_CODE_SUPPLIER.get();
    }

    public static String fieldName(Object fieldSuffix) {
        return "_" + String.valueOf(fieldSuffix);
    }

    @Nonnull
    public static Null nullType() {
        return NULL;
    }

    @Nonnull
    public static None noneType() {
        return NONE;
    }

    @Nonnull
    public static Uuid uuidType(boolean withNullability) {
        if (withNullability) {
            return UUID_NULL_INSTANCE;
        }
        return UUID_NON_NULL_INSTANCE;
    }

    @Nonnull
    public static Type primitiveType(@Nonnull TypeCode typeCode) {
        return Type.primitiveType(typeCode, true);
    }

    @Nonnull
    @VisibleForTesting
    public static Type primitiveType(@Nonnull TypeCode typeCode, boolean isNullable) {
        Verify.verify(typeCode.isPrimitive());
        return new Primitive(isNullable, typeCode);
    }

    @Nonnull
    public static List<Type> fromTyped(@Nonnull List<? extends Typed> typedList) {
        return typedList.stream().map(Typed::getResultType).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private static Type fromProtoType(@Nullable Descriptors.GenericDescriptor descriptor, @Nonnull Descriptors.FieldDescriptor.Type protoType, @Nonnull DescriptorProtos.FieldDescriptorProto.Label protoLabel, boolean isNullable) {
        TypeCode typeCode = TypeCode.fromProtobufType(protoType);
        if (protoLabel == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED) {
            return Type.fromProtoTypeToArray(descriptor, protoType, typeCode, false);
        }
        if (typeCode.isPrimitive()) {
            return Type.primitiveType(typeCode, isNullable);
        }
        if (typeCode == TypeCode.ENUM) {
            Descriptors.EnumDescriptor enumDescriptor = (Descriptors.EnumDescriptor)Objects.requireNonNull(descriptor);
            return Enum.fromProtoValues(isNullable, enumDescriptor.getValues());
        }
        if (typeCode == TypeCode.RECORD) {
            Objects.requireNonNull(descriptor);
            Descriptors.Descriptor messageDescriptor = (Descriptors.Descriptor)descriptor;
            if (NullableArrayTypeUtils.describesWrappedArray(messageDescriptor)) {
                Descriptors.FieldDescriptor elementField = messageDescriptor.findFieldByName(NullableArrayTypeUtils.getRepeatedFieldName());
                TypeCode elementTypeCode = TypeCode.fromProtobufType(elementField.getType());
                return Type.fromProtoTypeToArray(descriptor, protoType, elementTypeCode, true);
            }
            if (TupleFieldsProto.UUID.getDescriptor().equals(messageDescriptor)) {
                return Type.uuidType(isNullable);
            }
            return Record.fromFieldDescriptorsMap(isNullable, Record.toFieldDescriptorMap(messageDescriptor.getFields()));
        }
        throw new IllegalStateException("unable to translate protobuf descriptor to type");
    }

    @Nonnull
    private static Array fromProtoTypeToArray(@Nullable Descriptors.GenericDescriptor descriptor, @Nonnull Descriptors.FieldDescriptor.Type protoType, @Nonnull TypeCode typeCode, boolean isNullable) {
        if (typeCode.isPrimitive()) {
            Type primitiveType = Type.primitiveType(typeCode, false);
            return new Array(isNullable, primitiveType);
        }
        if (typeCode == TypeCode.ENUM) {
            Descriptors.EnumDescriptor enumDescriptor = (Descriptors.EnumDescriptor)Objects.requireNonNull(descriptor);
            Enum enumType = Enum.fromProtoValues(false, enumDescriptor.getValues());
            return new Array(isNullable, enumType);
        }
        if (isNullable) {
            Descriptors.Descriptor wrappedDescriptor = ((Descriptors.Descriptor)Objects.requireNonNull(descriptor)).findFieldByName(NullableArrayTypeUtils.getRepeatedFieldName()).getMessageType();
            Objects.requireNonNull(wrappedDescriptor);
            return new Array(true, Type.fromProtoType(wrappedDescriptor, Descriptors.FieldDescriptor.Type.MESSAGE, DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL, false));
        }
        return new Array(false, Type.fromProtoType(descriptor, protoType, DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL, false));
    }

    @Nullable
    private static Descriptors.GenericDescriptor getTypeSpecificDescriptor(@Nonnull Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getType()) {
            case MESSAGE: {
                return fieldDescriptor.getMessageType();
            }
            case ENUM: {
                return fieldDescriptor.getEnumType();
            }
        }
        return null;
    }

    @Nullable
    public static Type maximumType(@Nonnull Type t1, @Nonnull Type t2) {
        boolean isResultNullable;
        if (t1.getTypeCode() == TypeCode.NULL && t2.getTypeCode() == TypeCode.NULL) {
            return Type.nullType();
        }
        if (t1.getTypeCode() == TypeCode.NULL && PromoteValue.isPromotable(t1, t2)) {
            return t2.withNullability(true);
        }
        if (t2.getTypeCode() == TypeCode.NULL && PromoteValue.isPromotable(t2, t1)) {
            return t1.withNullability(true);
        }
        Verify.verify(!t1.isUnresolved());
        Verify.verify(!t2.isUnresolved());
        boolean bl = isResultNullable = t1.isNullable() || t2.isNullable();
        if (t1.isEnum() && t2.isEnum()) {
            Enum t1Enum = (Enum)t1;
            Enum t2Enum = (Enum)t2;
            List<Enum.EnumValue> t1EnumValues = t1Enum.enumValues;
            List<Enum.EnumValue> t2EnumValues = t2Enum.enumValues;
            if (t1EnumValues == null) {
                return t2EnumValues == null ? t1Enum.withNullability(isResultNullable) : null;
            }
            return t1EnumValues.equals(t2EnumValues) ? t1Enum.withNullability(isResultNullable) : null;
        }
        if (t1.isPrimitive() || t1.isEnum() || t1.isUuid() && (t2.isPrimitive() || t2.isEnum() || t2.isUuid())) {
            if (t1.getTypeCode() == t2.getTypeCode()) {
                return t1.withNullability(isResultNullable);
            }
            if (PromoteValue.isPromotable(t1, t2)) {
                return t2.withNullability(isResultNullable);
            }
            if (PromoteValue.isPromotable(t2, t1)) {
                return t1.withNullability(isResultNullable);
            }
            return null;
        }
        if (t1.getTypeCode() != t2.getTypeCode()) {
            return null;
        }
        switch (t1.getTypeCode()) {
            case RECORD: {
                List<Record.Field> t1Fields = ((Record)t1).getFields();
                List<Record.Field> t2Fields = ((Record)t2).getFields();
                if (t1Fields.size() != t2Fields.size()) {
                    return null;
                }
                ImmutableList.Builder resultFieldsBuilder = ImmutableList.builder();
                for (int i = 0; i < t1Fields.size(); ++i) {
                    Record.Field t1Field = t1Fields.get(i);
                    Record.Field t2Field = t2Fields.get(i);
                    Type resultFieldType = Type.maximumType(t1Field.getFieldType(), t2Field.getFieldType());
                    if (resultFieldType == null) {
                        return null;
                    }
                    Optional<Object> resultFieldNameOptional = Optional.empty();
                    if (t1Field.getFieldNameOptional().isEmpty()) {
                        resultFieldNameOptional = t2Field.getFieldNameOptional();
                    } else if (t2Field.getFieldNameOptional().isEmpty() || t1Field.getFieldNameOptional().equals(t2Field.getFieldNameOptional())) {
                        resultFieldNameOptional = t1Field.getFieldNameOptional();
                    }
                    resultFieldsBuilder.add(Record.Field.of(resultFieldType, resultFieldNameOptional));
                }
                return Record.fromFields(isResultNullable, (List<Record.Field>)((Object)resultFieldsBuilder.build()));
            }
            case ARRAY: {
                Type t1ElementType = Verify.verifyNotNull(((Array)t1).getElementType());
                Type t2ElementType = Verify.verifyNotNull(((Array)t2).getElementType());
                Type resultElementType = Type.maximumType(t1ElementType, t2ElementType);
                if (resultElementType == null) {
                    return null;
                }
                return new Array(isResultNullable, resultElementType);
            }
        }
        throw new RecordCoreException("do not know how to handle type code", new Object[0]);
    }

    @Nonnull
    public static TypeCode typeCodeFromPrimitive(@Nullable Object o) {
        if (o instanceof ByteString || o instanceof byte[]) {
            return TypeCode.BYTES;
        }
        return Type.getClassToTypeCodeMap().getOrDefault(o == null ? null : o.getClass(), TypeCode.UNKNOWN);
    }

    @Nonnull
    public static Type fromObject(@Nullable Object object) {
        if (object instanceof Typed) {
            return ((Typed)object).getResultType();
        }
        if (object == null) {
            return Type.nullType();
        }
        if (object instanceof List) {
            if (((List)object).isEmpty()) {
                return Type.noneType();
            }
            return new Array(Type.fromListObject((List)object));
        }
        if (object instanceof DynamicMessage) {
            return Record.fromDescriptor(((DynamicMessage)object).getDescriptorForType());
        }
        TypeCode typeCode = Type.typeCodeFromPrimitive(object);
        if (typeCode == TypeCode.NULL) {
            return Type.nullType();
        }
        if (typeCode == TypeCode.UNKNOWN) {
            return Type.any();
        }
        if (typeCode.isPrimitive()) {
            return Type.primitiveType(typeCode, false);
        }
        if (typeCode == TypeCode.UUID) {
            return Type.uuidType(false);
        }
        throw new RecordCoreException("Unable to convert value to Type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, object});
    }

    @Nonnull
    private static Type fromListObject(@Nullable List<?> list) {
        if (list == null) {
            return Type.nullType();
        }
        if (list.isEmpty()) {
            return Type.any();
        }
        List elementsTypes = list.stream().map(Type::fromObject).collect(Collectors.toList());
        List nonNullElementType = elementsTypes.stream().distinct().filter(type -> type != Type.nullType()).collect(Collectors.toList());
        if (nonNullElementType.size() != 1) {
            return Type.any();
        }
        if (elementsTypes.stream().anyMatch(type -> type == Type.nullType())) {
            return ((Type)nonNullElementType.get(0)).withNullability(true);
        }
        return (Type)nonNullElementType.get(0);
    }

    @Nonnull
    public PType toTypeProto(@Nonnull PlanSerializationContext var1);

    @Nonnull
    public static Type fromTypeProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType typeProto) {
        return (Type)PlanSerialization.dispatchFromProtoContainer(serializationContext, typeProto);
    }

    @Nonnull
    public static Any any() {
        return Any.INSTANCE;
    }

    public static enum TypeCode {
        UNKNOWN(null, null, true, false),
        ANY(Object.class, null, false, false),
        NULL(Void.class, null, true, false),
        BOOLEAN(Boolean.class, DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL, true, false),
        BYTES(ByteString.class, DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES, true, false),
        DOUBLE(Double.class, DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE, true, true),
        FLOAT(Float.class, DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT, true, true),
        INT(Integer.class, DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32, true, true),
        LONG(Long.class, DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64, true, true),
        STRING(String.class, DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING, true, false),
        VERSION(FDBRecordVersion.class, DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES, true, false),
        ENUM(Enum.class, DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM, false, false),
        RECORD(Message.class, null, false, false),
        UUID(UUID.class, null, false, false),
        ARRAY(List.class, null, false, false),
        RELATION(null, null, false, false),
        NONE(null, null, false, false);

        @Nullable
        private final Class<?> javaClass;
        @Nullable
        private final DescriptorProtos.FieldDescriptorProto.Type protoType;
        private final boolean isPrimitive;
        private final boolean isNumeric;

        private TypeCode(Class<?> javaClass, DescriptorProtos.FieldDescriptorProto.Type protoType, boolean isPrimitive, boolean isNumeric) {
            this.javaClass = javaClass;
            this.protoType = protoType;
            this.isPrimitive = isPrimitive;
            this.isNumeric = isNumeric;
        }

        @Nullable
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Nullable
        public DescriptorProtos.FieldDescriptorProto.Type getProtoType() {
            return this.protoType;
        }

        public boolean isPrimitive() {
            return this.isPrimitive;
        }

        public boolean isNumeric() {
            return this.isNumeric;
        }

        @Nonnull
        private static BiMap<Class<?>, TypeCode> computeClassToTypeCodeMap() {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (TypeCode typeCode : TypeCode.values()) {
                if (typeCode.getJavaClass() == null) continue;
                builder.put(typeCode.getJavaClass(), (Object)typeCode);
            }
            return builder.build();
        }

        @Nonnull
        public static TypeCode fromProtobufType(@Nonnull Descriptors.FieldDescriptor.Type protobufType) {
            switch (protobufType) {
                case DOUBLE: {
                    return DOUBLE;
                }
                case FLOAT: {
                    return FLOAT;
                }
                case INT64: 
                case UINT64: 
                case FIXED64: 
                case SFIXED64: 
                case SINT64: {
                    return LONG;
                }
                case INT32: 
                case FIXED32: 
                case UINT32: 
                case SFIXED32: 
                case SINT32: {
                    return INT;
                }
                case BOOL: {
                    return BOOLEAN;
                }
                case STRING: {
                    return STRING;
                }
                case ENUM: 
                case GROUP: {
                    return ENUM;
                }
                case MESSAGE: {
                    return RECORD;
                }
                case BYTES: {
                    return BYTES;
                }
            }
            throw new IllegalArgumentException("unknown protobuf type " + String.valueOf((Object)protobufType));
        }

        @Nonnull
        public PType.PTypeCode toProto(@Nonnull PlanSerializationContext serializationContext) {
            switch (this) {
                case UNKNOWN: {
                    return PType.PTypeCode.UNKNOWN;
                }
                case ANY: {
                    return PType.PTypeCode.ANY;
                }
                case NULL: {
                    return PType.PTypeCode.NULL;
                }
                case BOOLEAN: {
                    return PType.PTypeCode.BOOLEAN;
                }
                case BYTES: {
                    return PType.PTypeCode.BYTES;
                }
                case DOUBLE: {
                    return PType.PTypeCode.DOUBLE;
                }
                case FLOAT: {
                    return PType.PTypeCode.FLOAT;
                }
                case INT: {
                    return PType.PTypeCode.INT;
                }
                case LONG: {
                    return PType.PTypeCode.LONG;
                }
                case STRING: {
                    return PType.PTypeCode.STRING;
                }
                case VERSION: {
                    return PType.PTypeCode.VERSION;
                }
                case ENUM: {
                    return PType.PTypeCode.ENUM;
                }
                case RECORD: {
                    return PType.PTypeCode.RECORD;
                }
                case ARRAY: {
                    return PType.PTypeCode.ARRAY;
                }
                case RELATION: {
                    return PType.PTypeCode.RELATION;
                }
                case NONE: {
                    return PType.PTypeCode.NONE;
                }
                case UUID: {
                    return PType.PTypeCode.UUID;
                }
            }
            throw new RecordCoreException("unable to find type code mapping. did you forgot to add it here?", new Object[0]);
        }

        @Nonnull
        public static TypeCode fromProto(@Nonnull PlanSerializationContext serializationContext, PType.PTypeCode typeCodeProto) {
            switch (typeCodeProto) {
                case UNKNOWN: {
                    return UNKNOWN;
                }
                case ANY: {
                    return ANY;
                }
                case NULL: {
                    return NULL;
                }
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case BYTES: {
                    return BYTES;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case FLOAT: {
                    return FLOAT;
                }
                case INT: {
                    return INT;
                }
                case LONG: {
                    return LONG;
                }
                case STRING: {
                    return STRING;
                }
                case VERSION: {
                    return VERSION;
                }
                case ENUM: {
                    return ENUM;
                }
                case RECORD: {
                    return RECORD;
                }
                case ARRAY: {
                    return ARRAY;
                }
                case UUID: {
                    return UUID;
                }
                case RELATION: {
                    return RELATION;
                }
                case NONE: {
                    return NONE;
                }
            }
            throw new RecordCoreException("unable to find type code proto mapping", new Object[0]);
        }
    }

    public static class Array
    implements Type,
    Erasable {
        private final boolean isNullable;
        @Nullable
        private final Type elementType;
        @Nonnull
        private final Supplier<Integer> hashFunctionSupplier = Suppliers.memoize(this::computeHashFunction);

        private int computeHashFunction() {
            return Objects.hash(this.getTypeCode().name().hashCode(), this.isNullable(), this.elementType);
        }

        public Array() {
            this(null);
        }

        public Array(@Nullable Type elementType) {
            this(false, elementType);
        }

        public Array(boolean isNullable, @Nullable Type elementType) {
            this.isNullable = isNullable;
            this.elementType = elementType;
        }

        @Override
        public TypeCode getTypeCode() {
            return TypeCode.ARRAY;
        }

        @Override
        public Class<?> getJavaClass() {
            return Collection.class;
        }

        @Override
        public boolean isNullable() {
            return this.isNullable;
        }

        @Override
        @Nonnull
        public Array withNullability(boolean newIsNullable) {
            if (newIsNullable == this.isNullable) {
                return this;
            }
            return new Array(newIsNullable, this.elementType);
        }

        @Nullable
        public Type getElementType() {
            return this.elementType;
        }

        @Nonnull
        public Array withElementType(@Nullable Type elementType) {
            if (elementType == null && this.elementType == null) {
                return this;
            }
            if (elementType != null && elementType.equals(this.elementType)) {
                return this;
            }
            return new Array(this.isNullable(), elementType);
        }

        @Override
        public boolean isErased() {
            return this.getElementType() == null;
        }

        @Override
        public void defineProtoType(TypeRepository.Builder typeRepositoryBuilder) {
            Objects.requireNonNull(this.elementType);
            String typeName = ProtoUtils.uniqueTypeName();
            typeRepositoryBuilder.registerTypeToTypeNameMapping(this, typeName);
            if (this.isNullable && this.elementType.getTypeCode() != TypeCode.UNKNOWN) {
                Record wrapperType = Record.fromFields(List.of(Record.Field.of(new Array(this.elementType), Optional.of(NullableArrayTypeUtils.getRepeatedFieldName()))));
                typeRepositoryBuilder.defineAndResolveType(wrapperType);
            } else {
                typeRepositoryBuilder.defineAndResolveType(this.elementType);
            }
        }

        @Override
        public void addProtoField(@Nonnull TypeRepository.Builder typeRepositoryBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder descriptorBuilder, int fieldNumber, @Nonnull String fieldName, @Nonnull Optional<String> typeNameOptional, @Nonnull DescriptorProtos.FieldDescriptorProto.Label label) {
            Objects.requireNonNull(this.elementType);
            if (this.isNullable && this.elementType.getTypeCode() != TypeCode.UNKNOWN) {
                Record wrapperType = Record.fromFields(List.of(Record.Field.of(new Array(this.elementType), Optional.of(NullableArrayTypeUtils.getRepeatedFieldName()))));
                wrapperType.addProtoField(typeRepositoryBuilder, descriptorBuilder, fieldNumber, fieldName, typeRepositoryBuilder.defineAndResolveType(wrapperType), DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
            } else {
                this.elementType.addProtoField(typeRepositoryBuilder, descriptorBuilder, fieldNumber, fieldName, typeRepositoryBuilder.defineAndResolveType(this.elementType), DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
            }
        }

        public int hashCode() {
            return this.hashFunctionSupplier.get();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Array otherType = (Array)obj;
            return this.getTypeCode() == otherType.getTypeCode() && this.isNullable() == otherType.isNullable() && (this.isErased() && otherType.isErased() || Objects.requireNonNull(this.elementType).equals(otherType.elementType));
        }

        @Nonnull
        public String toString() {
            return this.describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokens describe() {
            ExplainTokens resultExplainTokens = new ExplainTokens();
            resultExplainTokens.addKeyword(this.getTypeCode().toString());
            if (this.isErased()) {
                return resultExplainTokens;
            }
            return resultExplainTokens.addOptionalWhitespace().addOpeningParen().addOptionalWhitespace().addNested(Objects.requireNonNull(this.getElementType()).describe()).addOptionalWhitespace().addClosingParen();
        }

        @Override
        @Nonnull
        public PType.PArrayType toProto(@Nonnull PlanSerializationContext serializationContext) {
            PType.PArrayType.Builder arrayTypeProtoBuilder = PType.PArrayType.newBuilder();
            arrayTypeProtoBuilder.setIsNullable(this.isNullable);
            arrayTypeProtoBuilder.setElementType(Objects.requireNonNull(this.elementType).toTypeProto(serializationContext));
            return arrayTypeProtoBuilder.build();
        }

        @Override
        @Nonnull
        public PType toTypeProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.newBuilder().setArrayType(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Array fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PArrayType arrayTypeProto) {
            Verify.verify(arrayTypeProto.hasIsNullable());
            return new Array(arrayTypeProto.getIsNullable(), Type.fromTypeProto(serializationContext, arrayTypeProto.getElementType()));
        }

        public static class Deserializer
        implements PlanDeserializer<PType.PArrayType, Array> {
            @Override
            @Nonnull
            public Class<PType.PArrayType> getProtoMessageClass() {
                return PType.PArrayType.class;
            }

            @Override
            @Nonnull
            public Array fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PArrayType arrayTypeProto) {
                return Array.fromProto(serializationContext, arrayTypeProto);
            }
        }
    }

    public static class Record
    implements Type,
    Erasable {
        @Nullable
        private final String name;
        private final boolean isNullable;
        @Nullable
        private final List<Field> fields;
        @Nonnull
        private final Supplier<Map<String, Field>> fieldNameFieldMapSupplier;
        @Nonnull
        private final Supplier<Map<String, Integer>> fieldNameToOrdinalSupplier;
        @Nonnull
        private final Supplier<Map<Integer, Integer>> fieldIndexToOrdinalSupplier;
        @Nonnull
        private final Supplier<List<Type>> elementTypesSupplier;
        @Nonnull
        private final Supplier<Integer> hashFunctionSupplier = Suppliers.memoize(this::computeHashCode);

        private int computeHashCode() {
            return Objects.hash(this.getTypeCode().name().hashCode(), this.isNullable(), this.fields);
        }

        protected Record(boolean isNullable, @Nullable List<Field> normalizedFields) {
            this(null, isNullable, normalizedFields);
        }

        protected Record(@Nullable String name, boolean isNullable, @Nullable List<Field> normalizedFields) {
            this.name = name;
            this.isNullable = isNullable;
            this.fields = normalizedFields;
            this.fieldNameFieldMapSupplier = Suppliers.memoize(this::computeFieldNameFieldMap);
            this.fieldNameToOrdinalSupplier = Suppliers.memoize(this::computeFieldNameToOrdinal);
            this.fieldIndexToOrdinalSupplier = Suppliers.memoize(this::computeFieldIndexToOrdinal);
            this.elementTypesSupplier = Suppliers.memoize(this::computeElementTypes);
        }

        @Override
        public TypeCode getTypeCode() {
            return TypeCode.RECORD;
        }

        @Override
        public boolean isNullable() {
            return this.isNullable;
        }

        @Override
        @Nonnull
        public Record withNullability(boolean newIsNullable) {
            if (this.isNullable == newIsNullable) {
                return this;
            }
            return new Record(this.name, newIsNullable, this.fields);
        }

        @Nonnull
        public Record withName(@Nonnull String name) {
            return new Record(name, this.isNullable, this.fields);
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nonnull
        public List<Field> getFields() {
            return Objects.requireNonNull(this.fields);
        }

        @Nonnull
        public Field getField(int index) {
            return Objects.requireNonNull(this.getFields().get(index));
        }

        @Nonnull
        public Map<String, Integer> getFieldNameToOrdinalMap() {
            return this.fieldNameToOrdinalSupplier.get();
        }

        @Nonnull
        public Map<Integer, Integer> getFieldIndexToOrdinalMap() {
            return this.fieldIndexToOrdinalSupplier.get();
        }

        @Nullable
        public List<Type> getElementTypes() {
            return this.elementTypesSupplier.get();
        }

        private List<Type> computeElementTypes() {
            return Objects.requireNonNull(this.fields).stream().map(Field::getFieldType).collect(ImmutableList.toImmutableList());
        }

        @Nonnull
        public Map<String, Field> getFieldNameFieldMap() {
            return this.fieldNameFieldMapSupplier.get();
        }

        private Map<String, Field> computeFieldNameFieldMap() {
            return Objects.requireNonNull(this.fields).stream().collect(ImmutableMap.toImmutableMap(field -> field.getFieldNameOptional().get(), Function.identity()));
        }

        @Nonnull
        private Map<String, Integer> computeFieldNameToOrdinal() {
            return IntStream.range(0, Objects.requireNonNull(this.fields).size()).boxed().collect(ImmutableMap.toImmutableMap(id -> this.fields.get((int)id).getFieldNameOptional().get(), Function.identity()));
        }

        @Nonnull
        private Map<Integer, Integer> computeFieldIndexToOrdinal() {
            return IntStream.range(0, Objects.requireNonNull(this.fields).size()).boxed().collect(ImmutableMap.toImmutableMap(id -> this.fields.get((int)id).getFieldIndexOptional().get(), Function.identity()));
        }

        @Override
        public boolean isErased() {
            return this.fields == null;
        }

        @Override
        public void defineProtoType(TypeRepository.Builder typeRepositoryBuilder) {
            Objects.requireNonNull(this.fields);
            String typeName = this.name == null ? ProtoUtils.uniqueTypeName() : this.name;
            DescriptorProtos.DescriptorProto.Builder recordMsgBuilder = DescriptorProtos.DescriptorProto.newBuilder();
            recordMsgBuilder.setName(typeName);
            for (Field field : this.fields) {
                Type fieldType = field.getFieldType();
                String fieldName = field.getFieldName();
                fieldType.addProtoField(typeRepositoryBuilder, recordMsgBuilder, field.getFieldIndex(), fieldName, typeRepositoryBuilder.defineAndResolveType(fieldType), DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
            }
            typeRepositoryBuilder.addMessageType(recordMsgBuilder.build());
            typeRepositoryBuilder.registerTypeToTypeNameMapping(this, typeName);
        }

        @Override
        public void addProtoField(@Nonnull TypeRepository.Builder typeRepositoryBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder descriptorBuilder, int fieldNumber, @Nonnull String fieldName, @Nonnull Optional<String> typeNameOptional, @Nonnull DescriptorProtos.FieldDescriptorProto.Label label) {
            DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorProto = DescriptorProtos.FieldDescriptorProto.newBuilder();
            fieldDescriptorProto.setName(fieldName).setNumber(fieldNumber).setLabel(label);
            typeNameOptional.ifPresent(fieldDescriptorProto::setTypeName);
            descriptorBuilder.addField(fieldDescriptorProto.build());
        }

        public int hashCode() {
            return this.hashFunctionSupplier.get();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Record otherType = (Record)obj;
            return this.getTypeCode() == otherType.getTypeCode() && this.isNullable() == otherType.isNullable() && (this.isErased() && otherType.isErased() || Objects.requireNonNull(this.fields).equals(otherType.fields));
        }

        @Nonnull
        public String toString() {
            return this.describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokens describe() {
            ExplainTokens resultExplainTokens = new ExplainTokens();
            if (this.isErased()) {
                return resultExplainTokens.addKeyword(this.getTypeCode().toString());
            }
            int i = 0;
            for (Field field : this.getFields()) {
                Optional<String> fieldNameOptional = field.getFieldNameOptional();
                if (fieldNameOptional.isPresent()) {
                    resultExplainTokens.addNested(field.getFieldType().describe()).addWhitespace().addKeyword("AS").addWhitespace().addIdentifier(fieldNameOptional.get());
                } else {
                    resultExplainTokens.addNested(field.getFieldType().describe());
                }
                if (i + 1 < this.getFields().size()) {
                    resultExplainTokens.addCommaAndWhiteSpace();
                }
                ++i;
            }
            return resultExplainTokens;
        }

        @Override
        @Nonnull
        public PType.PRecordType toProto(@Nonnull PlanSerializationContext serializationContext) {
            Integer referenceId = serializationContext.lookupReferenceIdForRecordType(this);
            if (referenceId == null) {
                PType.PRecordType.Builder recordTypeProtoBuilder = PType.PRecordType.newBuilder().setReferenceId(serializationContext.registerReferenceIdForRecordType(this));
                if (this.name != null) {
                    recordTypeProtoBuilder.setName(this.name);
                }
                recordTypeProtoBuilder.setIsNullable(this.isNullable);
                for (Field field : Objects.requireNonNull(this.fields)) {
                    recordTypeProtoBuilder.addFields(field.toProto(serializationContext));
                }
                return recordTypeProtoBuilder.build();
            }
            return PType.PRecordType.newBuilder().setReferenceId(referenceId).build();
        }

        @Override
        @Nonnull
        public PType toTypeProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.newBuilder().setRecordType(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Record fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PRecordType recordTypeProto) {
            Verify.verify(recordTypeProto.hasReferenceId());
            int referenceId = recordTypeProto.getReferenceId();
            Record type = serializationContext.lookupRecordTypeForReferenceId(referenceId);
            if (type != null) {
                return type;
            }
            Verify.verify(recordTypeProto.hasIsNullable());
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            for (int i = 0; i < recordTypeProto.getFieldsCount(); ++i) {
                fieldsBuilder.add(Field.fromProto(serializationContext, recordTypeProto.getFields(i)));
            }
            ImmutableCollection fields = fieldsBuilder.build();
            type = new Record(recordTypeProto.hasName() ? recordTypeProto.getName() : null, recordTypeProto.getIsNullable(), (List<Field>)((Object)fields));
            serializationContext.registerReferenceIdForRecordType(type, referenceId);
            return type;
        }

        @Nonnull
        public static Record erased() {
            return new Record(true, null);
        }

        @Nonnull
        public static Record fromFields(@Nonnull List<Field> fields) {
            return Record.fromFields(true, fields);
        }

        @Nonnull
        public static Record fromFields(boolean isNullable, @Nonnull List<Field> fields) {
            return new Record(isNullable, Record.normalizeFields(fields));
        }

        @Nonnull
        public static Record fromFieldsWithName(@Nonnull String name, boolean isNullable, @Nonnull List<Field> fields) {
            return new Record(name, isNullable, Record.normalizeFields(fields));
        }

        @Nonnull
        public static Record fromFieldDescriptorsMap(@Nonnull Map<String, Descriptors.FieldDescriptor> fieldDescriptorMap) {
            return Record.fromFieldDescriptorsMap(false, fieldDescriptorMap);
        }

        @Nonnull
        public static Record fromFieldDescriptorsMap(boolean isNullable, @Nonnull Map<String, Descriptors.FieldDescriptor> fieldDescriptorMap) {
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            for (Map.Entry<String, Descriptors.FieldDescriptor> entry : Objects.requireNonNull(fieldDescriptorMap).entrySet()) {
                Descriptors.FieldDescriptor fieldDescriptor = entry.getValue();
                fieldsBuilder.add(new Field(Type.fromProtoType(Type.getTypeSpecificDescriptor(fieldDescriptor), fieldDescriptor.getType(), fieldDescriptor.toProto().getLabel(), !fieldDescriptor.isRequired()), Optional.of(entry.getKey()), Optional.of(fieldDescriptor.getNumber())));
            }
            return Record.fromFields(isNullable, (List<Field>)((Object)fieldsBuilder.build()));
        }

        @Nonnull
        public static Record fromDescriptor(Descriptors.Descriptor descriptor) {
            return Record.fromFieldDescriptorsMap(Record.toFieldDescriptorMap(descriptor.getFields()));
        }

        @Nonnull
        public static Map<String, Descriptors.FieldDescriptor> toFieldDescriptorMap(@Nonnull List<Descriptors.FieldDescriptor> fieldDescriptors) {
            return fieldDescriptors.stream().collect(ImmutableMap.toImmutableMap(Descriptors.FieldDescriptor::getName, fieldDescriptor -> fieldDescriptor));
        }

        @Nullable
        private static List<Field> normalizeFields(@Nullable List<Field> fields) {
            if (fields == null) {
                return null;
            }
            HashSet<Integer> fieldIndexesSeen = Sets.newHashSet();
            boolean override = false;
            for (Field field : fields) {
                if (field.getFieldNameOptional().isEmpty() || field.getFieldIndexOptional().isEmpty()) {
                    override = true;
                    break;
                }
                if (!field.fieldIndexOptional.isPresent() || fieldIndexesSeen.add(field.getFieldIndex())) continue;
                override = true;
                break;
            }
            HashSet<String> fieldNamesSeen = Sets.newHashSet();
            ImmutableList.Builder resultFieldsBuilder = ImmutableList.builder();
            for (int i = 0; i < fields.size(); ++i) {
                Field fieldToBeAdded;
                Field field = fields.get(i);
                if (!override) {
                    fieldToBeAdded = field;
                } else {
                    String explicitFieldName = (String)((Object)field.getFieldNameOptional().flatMap(fieldName -> Field.isAutoGenerated(fieldName) ? Optional.empty() : Optional.of(fieldName)).orElse("_" + i));
                    fieldToBeAdded = new Field(field.getFieldType(), Optional.of(explicitFieldName), Optional.of(i + 1));
                }
                if (!fieldNamesSeen.add(fieldToBeAdded.getFieldName())) {
                    throw new RecordCoreException("fields contain duplicate field names", new Object[0]);
                }
                resultFieldsBuilder.add(fieldToBeAdded);
            }
            return resultFieldsBuilder.build();
        }

        public static class Field
        implements Comparable<Field>,
        PlanSerializable {
            @Nonnull
            private final Type fieldType;
            @Nonnull
            private final Optional<String> fieldNameOptional;
            @Nonnull
            private final Optional<Integer> fieldIndexOptional;
            @Nonnull
            private final Supplier<Integer> hashFunctionSupplier = Suppliers.memoize(this::computeHashFunction);

            private int computeHashFunction() {
                return Objects.hash(this.getFieldType(), this.getFieldNameOptional(), this.getFieldIndexOptional());
            }

            protected Field(@Nonnull Type fieldType, @Nonnull Optional<String> fieldNameOptional, @Nonnull Optional<Integer> fieldIndexOptional) {
                this.fieldType = fieldType;
                this.fieldNameOptional = fieldNameOptional;
                this.fieldIndexOptional = fieldIndexOptional;
            }

            @Nonnull
            public Type getFieldType() {
                return this.fieldType;
            }

            @Nonnull
            public Optional<String> getFieldNameOptional() {
                return this.fieldNameOptional;
            }

            @Nonnull
            public String getFieldName() {
                return this.getFieldNameOptional().orElseThrow(() -> new RecordCoreException("field name should have been set", new Object[0]));
            }

            @Nonnull
            public Optional<Integer> getFieldIndexOptional() {
                return this.fieldIndexOptional;
            }

            public int getFieldIndex() {
                return this.getFieldIndexOptional().orElseThrow(() -> new RecordCoreException("field index should have been set", new Object[0]));
            }

            @Nonnull
            public Field withName(@Nonnull String newName) {
                if (this.fieldNameOptional.map(fieldName -> fieldName.equals(newName)).orElse(false).booleanValue()) {
                    return this;
                }
                return Field.of(this.getFieldType(), Optional.of(newName), this.getFieldIndexOptional());
            }

            @Nonnull
            public Field withNullability(boolean newNullability) {
                if (this.getFieldType().isNullable() == newNullability) {
                    return this;
                }
                Type newFieldType = this.getFieldType().withNullability(newNullability);
                return new Field(newFieldType, this.fieldNameOptional, this.fieldIndexOptional);
            }

            @Nonnull
            public Field withOverriddenTypeIfNullable(boolean shouldBeNullable) {
                return shouldBeNullable ? this.withNullability(true) : this;
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Field)) {
                    return false;
                }
                Field field = (Field)o;
                return this.getFieldType().equals(field.getFieldType()) && this.getFieldNameOptional().equals(field.getFieldNameOptional()) && this.getFieldIndexOptional().equals(field.getFieldIndexOptional());
            }

            public int hashCode() {
                return this.hashFunctionSupplier.get();
            }

            @Override
            public int compareTo(Field o) {
                Verify.verifyNotNull(o);
                return Integer.compare(this.getFieldIndex(), o.getFieldIndex());
            }

            @Override
            @Nonnull
            public PType.PRecordType.PField toProto(@Nonnull PlanSerializationContext serializationContext) {
                PType.PRecordType.PField.Builder fieldProtoBuilder = PType.PRecordType.PField.newBuilder();
                fieldProtoBuilder.setFieldType(this.fieldType.toTypeProto(serializationContext));
                this.fieldNameOptional.ifPresent(fieldProtoBuilder::setFieldName);
                this.fieldIndexOptional.ifPresent(fieldProtoBuilder::setFieldIndex);
                return fieldProtoBuilder.build();
            }

            @Nonnull
            public static Field fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PRecordType.PField fieldProto) {
                return new Field(Type.fromTypeProto(serializationContext, Objects.requireNonNull(fieldProto.getFieldType())), fieldProto.hasFieldName() ? Optional.of(fieldProto.getFieldName()) : Optional.empty(), fieldProto.hasFieldIndex() ? Optional.of(fieldProto.getFieldIndex()) : Optional.empty());
            }

            public static Field of(@Nonnull Type fieldType, @Nonnull Optional<String> fieldNameOptional, @Nonnull Optional<Integer> fieldIndexOptional) {
                return new Field(fieldType, fieldNameOptional, fieldIndexOptional);
            }

            public static Field of(@Nonnull Type fieldType, @Nonnull Optional<String> fieldNameOptional) {
                return new Field(fieldType, fieldNameOptional, Optional.empty());
            }

            public static Field unnamedOf(@Nonnull Type fieldType) {
                return new Field(fieldType, Optional.empty(), Optional.empty());
            }

            public static boolean isAutoGenerated(@Nonnull String fieldName) {
                return fieldName.startsWith("_") && StringUtils.isNumeric(fieldName, 1);
            }
        }

        public static class Deserializer
        implements PlanDeserializer<PType.PRecordType, Record> {
            @Override
            @Nonnull
            public Class<PType.PRecordType> getProtoMessageClass() {
                return PType.PRecordType.class;
            }

            @Override
            @Nonnull
            public Record fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PRecordType recordTypeProto) {
                return Record.fromProto(serializationContext, recordTypeProto);
            }
        }
    }

    public static class Enum
    implements Type {
        final boolean isNullable;
        @Nullable
        final List<EnumValue> enumValues;
        @Nullable
        final String name;
        @Nonnull
        private final Supplier<Integer> hashFunctionSupplier = Suppliers.memoize(this::computeHashCode);

        public Enum(boolean isNullable, @Nullable List<EnumValue> enumValues) {
            this(isNullable, enumValues, null);
        }

        public Enum(boolean isNullable, @Nullable List<EnumValue> enumValues, @Nullable String name) {
            this.isNullable = isNullable;
            this.enumValues = enumValues;
            this.name = name;
        }

        @Override
        public TypeCode getTypeCode() {
            return TypeCode.ENUM;
        }

        boolean isErased() {
            return this.enumValues == null;
        }

        @Nonnull
        public List<EnumValue> getEnumValues() {
            return Objects.requireNonNull(this.enumValues);
        }

        @Override
        public boolean isNullable() {
            return this.isNullable;
        }

        @Override
        @Nonnull
        public Enum withNullability(boolean newIsNullable) {
            return new Enum(newIsNullable, this.enumValues, this.name);
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public void defineProtoType(@Nonnull TypeRepository.Builder typeRepositoryBuilder) {
            Verify.verify(!this.isErased());
            String typeName = this.name == null ? ProtoUtils.uniqueTypeName() : this.name;
            DescriptorProtos.EnumDescriptorProto.Builder enumDescriptorProtoBuilder = DescriptorProtos.EnumDescriptorProto.newBuilder();
            enumDescriptorProtoBuilder.setName(typeName);
            for (EnumValue enumValue : Objects.requireNonNull(this.enumValues)) {
                enumDescriptorProtoBuilder.addValue(DescriptorProtos.EnumValueDescriptorProto.newBuilder().setName(enumValue.getName()).setNumber(enumValue.getNumber()));
            }
            typeRepositoryBuilder.addEnumType(enumDescriptorProtoBuilder.build());
            typeRepositoryBuilder.registerTypeToTypeNameMapping(this, typeName);
        }

        @Override
        public void addProtoField(@Nonnull TypeRepository.Builder typeRepositoryBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder descriptorBuilder, int fieldNumber, @Nonnull String fieldName, @Nonnull Optional<String> typeNameOptional, @Nonnull DescriptorProtos.FieldDescriptorProto.Label label) {
            DescriptorProtos.FieldDescriptorProto.Type protoType = Objects.requireNonNull(this.getTypeCode().getProtoType());
            DescriptorProtos.FieldDescriptorProto.Builder builder = DescriptorProtos.FieldDescriptorProto.newBuilder().setNumber(fieldNumber).setName(fieldName).setType(protoType).setLabel(label);
            typeNameOptional.ifPresent(builder::setTypeName);
            descriptorBuilder.addField(builder);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Enum otherType = (Enum)obj;
            return this.getTypeCode() == otherType.getTypeCode() && this.isNullable() == otherType.isNullable() && Objects.equals(this.enumValues, otherType.enumValues);
        }

        private int computeHashCode() {
            return Objects.hash(this.isNullable, this.enumValues);
        }

        public int hashCode() {
            return this.hashFunctionSupplier.get();
        }

        @Nonnull
        public String toString() {
            return this.describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokens describe() {
            ExplainTokens resultExplainTokens = new ExplainTokens();
            resultExplainTokens.addKeyword(this.getTypeCode().toString());
            if (this.isErased()) {
                return resultExplainTokens;
            }
            return resultExplainTokens.addOpeningAngledBracket().addToStrings((Iterable)Objects.requireNonNull(this.enumValues)).addClosingAngledBracket();
        }

        @Nonnull
        public static <T extends java.lang.Enum<T>> Enum forJavaEnum(@Nonnull Class<T> enumClass) {
            ImmutableList.Builder enumValuesBuilder = ImmutableList.builder();
            java.lang.Enum[] enumConstants = (java.lang.Enum[])enumClass.getEnumConstants();
            for (int i = 0; i < enumConstants.length; ++i) {
                java.lang.Enum enumConstant = enumConstants[i];
                enumValuesBuilder.add(new EnumValue(enumConstant.name(), i));
            }
            return new Enum(false, (List<EnumValue>)((Object)enumValuesBuilder.build()), null);
        }

        private static Enum fromProtoValues(boolean isNullable, @Nonnull List<Descriptors.EnumValueDescriptor> values) {
            return new Enum(isNullable, Enum.enumValuesFromProto(values), null);
        }

        public static List<EnumValue> enumValuesFromProto(@Nonnull List<Descriptors.EnumValueDescriptor> enumValueDescriptors) {
            return enumValueDescriptors.stream().map(enumValueDescriptor -> new EnumValue(enumValueDescriptor.getName(), enumValueDescriptor.getNumber())).collect(ImmutableList.toImmutableList());
        }

        @Override
        @Nonnull
        public PType.PEnumType toProto(@Nonnull PlanSerializationContext serializationContext) {
            PType.PEnumType.Builder enumTypeProtoBuilder = PType.PEnumType.newBuilder();
            enumTypeProtoBuilder.setIsNullable(this.isNullable);
            for (EnumValue enumValue : Objects.requireNonNull(this.enumValues)) {
                enumTypeProtoBuilder.addEnumValues(enumValue.toProto(serializationContext));
            }
            if (this.name != null) {
                enumTypeProtoBuilder.setName(this.name);
            }
            return enumTypeProtoBuilder.build();
        }

        @Override
        @Nonnull
        public PType toTypeProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.newBuilder().setEnumType(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Enum fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PEnumType enumTypeProto) {
            Verify.verify(enumTypeProto.hasIsNullable());
            ImmutableList.Builder enumValuesBuilder = ImmutableList.builder();
            for (int i = 0; i < enumTypeProto.getEnumValuesCount(); ++i) {
                enumValuesBuilder.add(EnumValue.fromProto(serializationContext, enumTypeProto.getEnumValues(i)));
            }
            ImmutableCollection enumValues = enumValuesBuilder.build();
            Verify.verify(!enumValues.isEmpty());
            return new Enum(enumTypeProto.getIsNullable(), (List<EnumValue>)((Object)enumValues), PlanSerialization.getFieldOrNull(enumTypeProto, PType.PEnumType::hasName, PType.PEnumType::getName));
        }

        public static class EnumValue
        implements PlanSerializable {
            @Nonnull
            final String name;
            final int number;

            public EnumValue(@Nonnull String name, int number) {
                this.name = name;
                this.number = number;
            }

            @Nonnull
            public String getName() {
                return this.name;
            }

            public int getNumber() {
                return this.number;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                EnumValue enumValue = (EnumValue)o;
                return this.number == enumValue.number && this.name.equals(enumValue.name);
            }

            public int hashCode() {
                return Objects.hash(this.name, this.number);
            }

            @Nonnull
            public String toString() {
                return this.name + "(" + this.number + ")";
            }

            @Override
            @Nonnull
            public PType.PEnumType.PEnumValue toProto(@Nonnull PlanSerializationContext serializationContext) {
                return PType.PEnumType.PEnumValue.newBuilder().setName(this.name).setNumber(this.number).build();
            }

            @Nonnull
            public static EnumValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PEnumType.PEnumValue enumValueProto) {
                return new EnumValue(enumValueProto.getName(), enumValueProto.getNumber());
            }
        }

        public static class Deserializer
        implements PlanDeserializer<PType.PEnumType, Enum> {
            @Override
            @Nonnull
            public Class<PType.PEnumType> getProtoMessageClass() {
                return PType.PEnumType.class;
            }

            @Override
            @Nonnull
            public Enum fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PEnumType enumTypeProto) {
                return Enum.fromProto(serializationContext, enumTypeProto);
            }
        }
    }

    public static class Null
    implements Type {
        @Override
        public TypeCode getTypeCode() {
            return TypeCode.NULL;
        }

        @Override
        public boolean isNullable() {
            return true;
        }

        @Override
        @Nonnull
        public Type withNullability(boolean newIsNullable) {
            Verify.verify(newIsNullable);
            return this;
        }

        @Override
        public boolean isUnresolved() {
            return true;
        }

        @Override
        public void addProtoField(@Nonnull TypeRepository.Builder typeRepositoryBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder descriptorBuilder, int fieldNumber, @Nonnull String fieldName, @Nonnull Optional<String> typeNameOptional, @Nonnull DescriptorProtos.FieldDescriptorProto.Label label) {
            throw new RecordCoreException("should not be called", new Object[0]);
        }

        @Nonnull
        public String toString() {
            return this.describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokens describe() {
            return new ExplainTokens().addKeyword("NULL");
        }

        @Override
        @Nonnull
        public PType.PNullType toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.PNullType.newBuilder().build();
        }

        @Override
        @Nonnull
        public PType toTypeProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.newBuilder().setNullType(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Null fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PNullType nullTypeProto) {
            return NULL;
        }

        public int hashCode() {
            return this.getTypeCode().name().hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof Null;
        }

        public static class Deserializer
        implements PlanDeserializer<PType.PNullType, Null> {
            @Override
            @Nonnull
            public Class<PType.PNullType> getProtoMessageClass() {
                return PType.PNullType.class;
            }

            @Override
            @Nonnull
            public Null fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PNullType nullTypeProto) {
                return Null.fromProto(serializationContext, nullTypeProto);
            }
        }
    }

    public static class None
    implements Type {
        @Override
        public TypeCode getTypeCode() {
            return TypeCode.NONE;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        @Nonnull
        public Type withNullability(boolean newIsNullable) {
            Verify.verify(!newIsNullable);
            return this;
        }

        @Override
        public boolean isUnresolved() {
            return true;
        }

        @Override
        public void addProtoField(@Nonnull TypeRepository.Builder typeRepositoryBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder descriptorBuilder, int fieldNumber, @Nonnull String fieldName, @Nonnull Optional<String> typeNameOptional, @Nonnull DescriptorProtos.FieldDescriptorProto.Label label) {
            throw new RecordCoreException("should not be called", new Object[0]);
        }

        @Nonnull
        public String toString() {
            return this.describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokens describe() {
            return new ExplainTokens().addKeyword("NONE");
        }

        @Override
        @Nonnull
        public PType.PNoneType toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.PNoneType.newBuilder().build();
        }

        @Override
        @Nonnull
        public PType toTypeProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.newBuilder().setNoneType(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static None fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PNoneType noneTypeProto) {
            return NONE;
        }

        public int hashCode() {
            return this.getTypeCode().name().hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof None;
        }

        public static class Deserializer
        implements PlanDeserializer<PType.PNoneType, None> {
            @Override
            @Nonnull
            public Class<PType.PNoneType> getProtoMessageClass() {
                return PType.PNoneType.class;
            }

            @Override
            @Nonnull
            public None fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PNoneType noneTypeProto) {
                return None.fromProto(serializationContext, noneTypeProto);
            }
        }
    }

    public static class Uuid
    implements Type {
        public static final String MESSAGE_NAME = TupleFieldsProto.UUID.getDescriptor().getName();
        private final boolean isNullable;

        private Uuid(boolean isNullable) {
            this.isNullable = isNullable;
        }

        @Override
        public TypeCode getTypeCode() {
            return TypeCode.UUID;
        }

        @Override
        public boolean isNullable() {
            return this.isNullable;
        }

        @Override
        @Nonnull
        public Type withNullability(boolean newIsNullable) {
            if (newIsNullable) {
                return UUID_NULL_INSTANCE;
            }
            return UUID_NON_NULL_INSTANCE;
        }

        @Override
        @Nonnull
        public ExplainTokens describe() {
            return new ExplainTokens().addKeyword(this.getTypeCode().toString());
        }

        @Override
        public void addProtoField(@Nonnull TypeRepository.Builder typeRepositoryBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder descriptorBuilder, int fieldNumber, @Nonnull String fieldName, @Nonnull Optional<String> typeNameOptional, @Nonnull DescriptorProtos.FieldDescriptorProto.Label label) {
            DescriptorProtos.FieldDescriptorProto.Builder builder = DescriptorProtos.FieldDescriptorProto.newBuilder().setNumber(fieldNumber).setName(fieldName).setLabel(label).setTypeName(TupleFieldsProto.UUID.getDescriptor().getFullName());
            typeNameOptional.ifPresent(builder::setTypeName);
            descriptorBuilder.addField(builder);
        }

        @Override
        @Nonnull
        public PType toTypeProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.newBuilder().setUuidType(this.toProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PType.PUuidType toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.PUuidType.newBuilder().setIsNullable(this.isNullable).build();
        }

        @Override
        public boolean isUuid() {
            return true;
        }

        @Nonnull
        public static Uuid fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PUuidType uuidTypeProto) {
            Verify.verify(uuidTypeProto.hasIsNullable());
            return Type.uuidType(uuidTypeProto.getIsNullable());
        }

        public static class Deserializer
        implements PlanDeserializer<PType.PUuidType, Uuid> {
            @Override
            @Nonnull
            public Class<PType.PUuidType> getProtoMessageClass() {
                return PType.PUuidType.class;
            }

            @Override
            @Nonnull
            public Uuid fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PUuidType uuidTypeProto) {
                return Uuid.fromProto(serializationContext, uuidTypeProto);
            }
        }
    }

    public static class Primitive
    implements Type {
        private final boolean isNullable;
        @Nonnull
        private final TypeCode typeCode;
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private Primitive(boolean isNullable, @Nonnull TypeCode typeCode) {
            this.isNullable = isNullable;
            this.typeCode = typeCode;
        }

        @Override
        @Nonnull
        public TypeCode getTypeCode() {
            return this.typeCode;
        }

        @Override
        public boolean isNullable() {
            return this.isNullable;
        }

        @Override
        @Nonnull
        public Type withNullability(boolean newIsNullable) {
            return newIsNullable == this.isNullable ? this : Type.primitiveType(this.typeCode, newIsNullable);
        }

        @Override
        public void addProtoField(@Nonnull TypeRepository.Builder typeRepositoryBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder descriptorBuilder, int fieldNumber, @Nonnull String fieldName, @Nonnull Optional<String> ignored, @Nonnull DescriptorProtos.FieldDescriptorProto.Label label) {
            DescriptorProtos.FieldDescriptorProto.Type protoType = Objects.requireNonNull(this.getTypeCode().getProtoType());
            descriptorBuilder.addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setNumber(fieldNumber).setName(fieldName).setType(protoType).setLabel(label).build());
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        private int computeHashCode() {
            return Objects.hash(this.typeCode.name().hashCode(), this.isNullable);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Type otherType = (Type)obj;
            return this.getTypeCode() == otherType.getTypeCode() && this.isNullable() == otherType.isNullable();
        }

        @Nonnull
        public String toString() {
            return this.describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokens describe() {
            return new ExplainTokens().addKeyword(this.getTypeCode().toString());
        }

        @Override
        @Nonnull
        public PType.PPrimitiveType toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.PPrimitiveType.newBuilder().setIsNullable(this.isNullable).setTypeCode(this.typeCode.toProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PType toTypeProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.newBuilder().setPrimitiveType(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Primitive fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PPrimitiveType primitiveTypeProto) {
            Verify.verify(primitiveTypeProto.hasIsNullable());
            return new Primitive(primitiveTypeProto.getIsNullable(), TypeCode.fromProto(serializationContext, Objects.requireNonNull(primitiveTypeProto.getTypeCode())));
        }

        public static class Deserializer
        implements PlanDeserializer<PType.PPrimitiveType, Primitive> {
            @Override
            @Nonnull
            public Class<PType.PPrimitiveType> getProtoMessageClass() {
                return PType.PPrimitiveType.class;
            }

            @Override
            @Nonnull
            public Primitive fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PPrimitiveType primitiveTypeProto) {
                return Primitive.fromProto(serializationContext, primitiveTypeProto);
            }
        }
    }

    public static class Any
    implements Type {
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
        @Nonnull
        private static final Any INSTANCE = new Any();

        private int computeHashCode() {
            return Objects.hash(this.getTypeCode().name().hashCode(), this.isNullable());
        }

        @Override
        public TypeCode getTypeCode() {
            return TypeCode.ANY;
        }

        @Override
        public boolean isNullable() {
            return true;
        }

        @Override
        @Nonnull
        public Any withNullability(boolean newIsNullable) {
            Verify.verify(newIsNullable);
            return this;
        }

        @Override
        public void addProtoField(@Nonnull TypeRepository.Builder typeRepositoryBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder descriptorBuilder, int fieldNumber, @Nonnull String fieldName, @Nonnull Optional<String> typeNameOptional, @Nonnull DescriptorProtos.FieldDescriptorProto.Label label) {
            throw new UnsupportedOperationException("type any cannot be represented in protobuf");
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Type otherType = (Type)obj;
            return this.getTypeCode() == otherType.getTypeCode() && this.isNullable() == otherType.isNullable();
        }

        @Nonnull
        public String toString() {
            return this.describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokens describe() {
            return new ExplainTokens().addKeyword(this.getTypeCode().toString());
        }

        @Override
        @Nonnull
        public PType.PAnyType toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.PAnyType.newBuilder().build();
        }

        @Override
        @Nonnull
        public PType toTypeProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.newBuilder().setAnyType(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Any fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PAnyType anyTypeProto) {
            return Type.any();
        }

        public static class Deserializer
        implements PlanDeserializer<PType.PAnyType, Any> {
            @Override
            @Nonnull
            public Class<PType.PAnyType> getProtoMessageClass() {
                return PType.PAnyType.class;
            }

            @Override
            @Nonnull
            public Any fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PAnyType anyTypeProto) {
                return Any.fromProto(serializationContext, anyTypeProto);
            }
        }
    }

    public static class Relation
    implements Type,
    Erasable {
        @Nullable
        private final Type innerType;
        @Nonnull
        private final Supplier<Integer> hashFunctionSupplier = Suppliers.memoize(this::computeHashFunction);

        private int computeHashFunction() {
            return Objects.hash(this.getTypeCode().name().hashCode(), this.isNullable(), this.innerType);
        }

        public Relation() {
            this(null);
        }

        public Relation(@Nullable Type innerType) {
            this.innerType = innerType;
        }

        @Override
        public TypeCode getTypeCode() {
            return TypeCode.RELATION;
        }

        @Override
        public Class<?> getJavaClass() {
            throw new UnsupportedOperationException("should not have been asked");
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        @Nonnull
        public Relation withNullability(boolean newIsNullable) {
            Verify.verify(!newIsNullable);
            return this;
        }

        @Nullable
        public Type getInnerType() {
            return this.innerType;
        }

        @Override
        public boolean isErased() {
            return this.getInnerType() == null;
        }

        @Override
        public void addProtoField(@Nonnull TypeRepository.Builder typeRepositoryBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder descriptorBuilder, int fieldNumber, @Nonnull String fieldName, @Nonnull Optional<String> typeNameOptional, @Nonnull DescriptorProtos.FieldDescriptorProto.Label label) {
            throw new IllegalStateException("this should not have been called");
        }

        public int hashCode() {
            return this.hashFunctionSupplier.get();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Relation otherType = (Relation)obj;
            return this.getTypeCode() == otherType.getTypeCode() && this.isNullable() == otherType.isNullable() && (this.isErased() && otherType.isErased() || Objects.requireNonNull(this.innerType).equals(otherType.innerType));
        }

        @Nonnull
        public String toString() {
            return this.describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokens describe() {
            ExplainTokens resultExplainTokens = new ExplainTokens();
            resultExplainTokens.addKeyword(this.getTypeCode().toString());
            if (this.isErased()) {
                return resultExplainTokens;
            }
            return resultExplainTokens.addOptionalWhitespace().addOpeningParen().addOptionalWhitespace().addNested(Objects.requireNonNull(this.getInnerType()).describe()).addOptionalWhitespace().addClosingParen();
        }

        @Override
        @Nonnull
        public PType.PRelationType toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.PRelationType.newBuilder().setInnerType(Objects.requireNonNull(this.innerType).toTypeProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PType toTypeProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.newBuilder().setRelationType(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Relation fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PRelationType relationTypeProto) {
            return new Relation(Objects.requireNonNull(Type.fromTypeProto(serializationContext, relationTypeProto.getInnerType())));
        }

        public static Type scalarOf(@Nonnull Type relationType) {
            Verify.verify(relationType.getTypeCode() == TypeCode.RELATION && relationType instanceof Relation);
            return ((Relation)relationType).getInnerType();
        }

        public static class Deserializer
        implements PlanDeserializer<PType.PRelationType, Relation> {
            @Override
            @Nonnull
            public Class<PType.PRelationType> getProtoMessageClass() {
                return PType.PRelationType.class;
            }

            @Override
            @Nonnull
            public Relation fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PRelationType relationTypeProto) {
                return Relation.fromProto(serializationContext, relationTypeProto);
            }
        }
    }

    public static class AnyRecord
    implements Type,
    Erasable {
        private final boolean isNullable;
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        public AnyRecord(boolean isNullable) {
            this.isNullable = isNullable;
        }

        private int computeHashCode() {
            return Objects.hash(this.getTypeCode().name().hashCode(), this.isNullable());
        }

        @Override
        public TypeCode getTypeCode() {
            return TypeCode.RECORD;
        }

        @Override
        public boolean isNullable() {
            return this.isNullable;
        }

        @Override
        @Nonnull
        public AnyRecord withNullability(boolean newIsNullable) {
            if (newIsNullable == this.isNullable) {
                return this;
            }
            return new AnyRecord(newIsNullable);
        }

        @Override
        public boolean isErased() {
            return true;
        }

        @Override
        public void addProtoField(@Nonnull TypeRepository.Builder typeRepositoryBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder descriptorBuilder, int fieldNumber, @Nonnull String fieldName, @Nonnull Optional<String> typeNameOptional, @Nonnull DescriptorProtos.FieldDescriptorProto.Label label) {
            throw new UnsupportedOperationException("type any cannot be represented in protobuf");
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Type otherType = (Type)obj;
            return this.getTypeCode() == otherType.getTypeCode() && this.isNullable() == otherType.isNullable();
        }

        @Nonnull
        public String toString() {
            return this.describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokens describe() {
            return new ExplainTokens().addKeyword(this.getTypeCode().toString());
        }

        @Override
        @Nonnull
        public PType.PAnyRecordType toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.PAnyRecordType.newBuilder().setIsNullable(this.isNullable).build();
        }

        @Override
        @Nonnull
        public PType toTypeProto(@Nonnull PlanSerializationContext serializationContext) {
            return PType.newBuilder().setAnyRecordType(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static AnyRecord fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PAnyRecordType anyTypeProto) {
            Verify.verify(anyTypeProto.hasIsNullable());
            return new AnyRecord(anyTypeProto.getIsNullable());
        }

        public static class Deserializer
        implements PlanDeserializer<PType.PAnyRecordType, AnyRecord> {
            @Override
            @Nonnull
            public Class<PType.PAnyRecordType> getProtoMessageClass() {
                return PType.PAnyRecordType.class;
            }

            @Override
            @Nonnull
            public AnyRecord fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PType.PAnyRecordType anyTypeProto) {
                return AnyRecord.fromProto(serializationContext, anyTypeProto);
            }
        }
    }

    public static interface Erasable
    extends Type {
        public boolean isErased();
    }
}

