/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.typing;

import com.apple.foundationdb.record.TupleFieldsProto;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ProtocolStringList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TypeRepository {
    @Nonnull
    public static final TypeRepository EMPTY_SCHEMA = TypeRepository.empty();
    @Nonnull
    public static final List<Descriptors.FileDescriptor> DEPENDENCIES = List.of(TupleFieldsProto.getDescriptor());
    @Nonnull
    private final DescriptorProtos.FileDescriptorSet fileDescSet;
    @Nonnull
    private final Map<String, Descriptors.Descriptor> msgDescriptorMapFull = new LinkedHashMap<String, Descriptors.Descriptor>();
    @Nonnull
    private final Map<String, Descriptors.Descriptor> msgDescriptorMapShort = new LinkedHashMap<String, Descriptors.Descriptor>();
    @Nonnull
    private final Map<String, Descriptors.EnumDescriptor> enumDescriptorMapFull = new LinkedHashMap<String, Descriptors.EnumDescriptor>();
    @Nonnull
    private final Map<String, Descriptors.EnumDescriptor> enumDescriptorMapShort = new LinkedHashMap<String, Descriptors.EnumDescriptor>();
    @Nonnull
    private final Map<Type, String> typeToNameMap;

    @Nonnull
    public static TypeRepository empty() {
        DescriptorProtos.FileDescriptorSet.Builder resultBuilder = DescriptorProtos.FileDescriptorSet.newBuilder();
        try {
            return new TypeRepository(resultBuilder.build(), Maps.newHashMap());
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public static TypeRepository parseFrom(@Nonnull InputStream schemaDescIn) throws Descriptors.DescriptorValidationException, IOException {
        try (InputStream inputStream = schemaDescIn;){
            int len;
            byte[] buf = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((len = schemaDescIn.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            TypeRepository typeRepository = TypeRepository.parseFrom(baos.toByteArray());
            return typeRepository;
        }
    }

    @Nonnull
    public static TypeRepository parseFrom(@Nonnull byte[] schemaDescBuf) throws Descriptors.DescriptorValidationException, IOException {
        return new TypeRepository(DescriptorProtos.FileDescriptorSet.parseFrom(schemaDescBuf), Maps.newHashMap());
    }

    @Nullable
    public DynamicMessage.Builder newMessageBuilder(@Nonnull String msgTypeName) {
        Descriptors.Descriptor msgType = this.getMessageDescriptor(msgTypeName);
        if (msgType == null) {
            return null;
        }
        return DynamicMessage.newBuilder(msgType);
    }

    @Nullable
    public DynamicMessage.Builder newMessageBuilder(@Nonnull Type type) {
        String msgTypeName = Preconditions.checkNotNull(this.typeToNameMap.get(type));
        Objects.requireNonNull(msgTypeName);
        return this.newMessageBuilder(msgTypeName);
    }

    @Nonnull
    public String getProtoTypeName(@Nonnull Type type) {
        String typeName = Preconditions.checkNotNull(this.typeToNameMap.get(type));
        return Objects.requireNonNull(typeName);
    }

    @Nullable
    public Descriptors.Descriptor getMessageDescriptor(@Nonnull String msgTypeName) {
        Descriptors.Descriptor msgType = this.msgDescriptorMapShort.get(msgTypeName);
        if (msgType == null) {
            msgType = this.msgDescriptorMapFull.get(msgTypeName);
        }
        return msgType;
    }

    @Nullable
    public Descriptors.Descriptor getMessageDescriptor(@Nonnull Type type) {
        String msgTypeName = this.getProtoTypeName(type);
        return this.getMessageDescriptor(msgTypeName);
    }

    @Nullable
    public Descriptors.EnumValueDescriptor getEnumValue(@Nonnull String enumTypeName, String enumName) {
        Descriptors.EnumDescriptor enumType = this.getEnumDescriptor(enumTypeName);
        if (enumType == null) {
            return null;
        }
        return enumType.findValueByName(enumName);
    }

    @Nullable
    public Descriptors.EnumValueDescriptor getEnumValue(@Nonnull String enumTypeName, int enumNumber) {
        Descriptors.EnumDescriptor enumType = this.getEnumDescriptor(enumTypeName);
        if (enumType == null) {
            return null;
        }
        return enumType.findValueByNumber(enumNumber);
    }

    @Nullable
    public Descriptors.EnumDescriptor getEnumDescriptor(@Nonnull String enumTypeName) {
        Descriptors.EnumDescriptor enumType = this.enumDescriptorMapShort.get(enumTypeName);
        if (enumType == null) {
            enumType = this.enumDescriptorMapFull.get(enumTypeName);
        }
        return enumType;
    }

    @Nullable
    public Descriptors.EnumDescriptor getEnumDescriptor(@Nonnull Type type) {
        String msgTypeName = this.getProtoTypeName(type);
        return this.getEnumDescriptor(msgTypeName);
    }

    @Nonnull
    public Set<String> getMessageTypes() {
        return new TreeSet<String>(this.msgDescriptorMapFull.keySet());
    }

    @Nonnull
    public Set<String> getEnumTypes() {
        return new TreeSet<String>(this.enumDescriptorMapFull.keySet());
    }

    @Nonnull
    public DescriptorProtos.FileDescriptorSet getFileDescriptorSet() {
        return this.fileDescSet;
    }

    @Nonnull
    public byte[] toByteArray() {
        return this.fileDescSet.toByteArray();
    }

    public String toString() {
        Set<String> msgTypes = this.getMessageTypes();
        Set<String> enumTypes = this.getEnumTypes();
        return "types: " + String.valueOf(msgTypes) + "\nenums: " + String.valueOf(enumTypes) + "\n" + String.valueOf(this.fileDescSet);
    }

    private TypeRepository(@Nonnull DescriptorProtos.FileDescriptorSet fileDescSet, @Nonnull Map<Type, String> typeToNameMap) throws Descriptors.DescriptorValidationException {
        this.fileDescSet = fileDescSet;
        Map<String, Descriptors.FileDescriptor> fileDescMap = TypeRepository.init(fileDescSet);
        HashSet<String> msgDupes = new HashSet<String>();
        HashSet<String> enumDupes = new HashSet<String>();
        for (Descriptors.FileDescriptor fileDesc : fileDescMap.values()) {
            for (Descriptors.Descriptor msgType : fileDesc.getMessageTypes()) {
                this.addMessageType(msgType, null, msgDupes, enumDupes);
            }
            for (Descriptors.EnumDescriptor enumType : fileDesc.getEnumTypes()) {
                this.addEnumType(enumType, null, enumDupes);
            }
        }
        for (String msgName : msgDupes) {
            this.msgDescriptorMapShort.remove(msgName);
        }
        for (String enumName : enumDupes) {
            this.enumDescriptorMapShort.remove(enumName);
        }
        this.typeToNameMap = ImmutableMap.copyOf(typeToNameMap);
    }

    @Nonnull
    private static Map<String, Descriptors.FileDescriptor> init(@Nonnull DescriptorProtos.FileDescriptorSet fileDescSet) throws Descriptors.DescriptorValidationException {
        Set<String> allFdProtoNames = TypeRepository.collectFileDescriptorNamesAndCheckForDupes(fileDescSet);
        HashMap<String, Descriptors.FileDescriptor> resolvedFileDescMap = new HashMap<String, Descriptors.FileDescriptor>();
        while (resolvedFileDescMap.size() < fileDescSet.getFileCount()) {
            for (DescriptorProtos.FileDescriptorProto fdProto : fileDescSet.getFileList()) {
                if (resolvedFileDescMap.containsKey(fdProto.getName())) continue;
                ProtocolStringList dependencyList = fdProto.getDependencyList();
                ArrayList<Descriptors.FileDescriptor> resolvedFdList = new ArrayList<Descriptors.FileDescriptor>();
                for (String depName : dependencyList) {
                    Optional<Descriptors.FileDescriptor> dependencyMaybe = DEPENDENCIES.stream().filter(d -> d.getFullName().equals(depName)).findAny();
                    if (dependencyMaybe.isPresent()) {
                        resolvedFdList.add(dependencyMaybe.get());
                        continue;
                    }
                    if (allFdProtoNames.contains(depName)) {
                        Descriptors.FileDescriptor fd = (Descriptors.FileDescriptor)resolvedFileDescMap.get(depName);
                        if (fd == null) continue;
                        resolvedFdList.add(fd);
                        continue;
                    }
                    throw new IllegalArgumentException("cannot resolve import " + depName + " in " + fdProto.getName());
                }
                if (resolvedFdList.size() != dependencyList.size()) continue;
                Descriptors.FileDescriptor[] fds = new Descriptors.FileDescriptor[resolvedFdList.size()];
                Descriptors.FileDescriptor fd = Descriptors.FileDescriptor.buildFrom(fdProto, resolvedFdList.toArray(fds));
                resolvedFileDescMap.put(fdProto.getName(), fd);
            }
        }
        return resolvedFileDescMap;
    }

    @Nonnull
    private static String duplicateNameErrorMessage(@Nonnull String name) {
        return "duplicate name: " + name;
    }

    @Nonnull
    private static Set<String> collectFileDescriptorNamesAndCheckForDupes(@Nonnull DescriptorProtos.FileDescriptorSet fileDescSet) {
        HashSet<String> result = new HashSet<String>();
        for (DescriptorProtos.FileDescriptorProto fdProto : fileDescSet.getFileList()) {
            if (result.contains(fdProto.getName())) {
                throw new IllegalArgumentException(TypeRepository.duplicateNameErrorMessage(fdProto.getName()));
            }
            result.add(fdProto.getName());
        }
        return result;
    }

    private void addMessageType(@Nonnull Descriptors.Descriptor msgType, @Nullable String scope, @Nonnull Set<String> msgDupes, @Nonnull Set<String> enumDupes) {
        String msgTypeNameShort;
        String msgTypeNameFull = msgType.getFullName();
        String string = msgTypeNameShort = scope == null ? msgType.getName() : scope + "." + msgType.getName();
        if (this.msgDescriptorMapFull.containsKey(msgTypeNameFull)) {
            throw new IllegalArgumentException(TypeRepository.duplicateNameErrorMessage(msgTypeNameFull));
        }
        if (this.msgDescriptorMapShort.containsKey(msgTypeNameShort)) {
            msgDupes.add(msgTypeNameShort);
        }
        this.msgDescriptorMapFull.put(msgTypeNameFull, msgType);
        this.msgDescriptorMapShort.put(msgTypeNameShort, msgType);
        for (Descriptors.Descriptor nestedType : msgType.getNestedTypes()) {
            this.addMessageType(nestedType, msgTypeNameShort, msgDupes, enumDupes);
        }
        for (Descriptors.EnumDescriptor enumType : msgType.getEnumTypes()) {
            this.addEnumType(enumType, msgTypeNameShort, enumDupes);
        }
    }

    private void addEnumType(@Nonnull Descriptors.EnumDescriptor enumType, @Nullable String scope, @Nonnull Set<String> enumDupes) {
        String enumTypeNameShort;
        String enumTypeNameFull = enumType.getFullName();
        String string = enumTypeNameShort = scope == null ? enumType.getName() : scope + "." + enumType.getName();
        if (this.enumDescriptorMapFull.containsKey(enumTypeNameFull)) {
            throw new IllegalArgumentException(TypeRepository.duplicateNameErrorMessage(enumTypeNameFull));
        }
        if (this.enumDescriptorMapShort.containsKey(enumTypeNameShort)) {
            enumDupes.add(enumTypeNameShort);
        }
        this.enumDescriptorMapFull.put(enumTypeNameFull, enumType);
        this.enumDescriptorMapShort.put(enumTypeNameShort, enumType);
    }

    public static class Builder {
        @Nonnull
        private final DescriptorProtos.FileDescriptorProto.Builder fileDescProtoBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
        @Nonnull
        private final DescriptorProtos.FileDescriptorSet.Builder fileDescSetBuilder;
        @Nonnull
        private final BiMap<Type, String> typeToNameMap;

        private Builder() {
            this.fileDescProtoBuilder.addAllDependency(DEPENDENCIES.stream().map(Descriptors.FileDescriptor::getFullName).collect(Collectors.toList()));
            this.fileDescSetBuilder = DescriptorProtos.FileDescriptorSet.newBuilder();
            this.typeToNameMap = HashBiMap.create();
        }

        @Nonnull
        public TypeRepository build() {
            DescriptorProtos.FileDescriptorSet.Builder resultBuilder = DescriptorProtos.FileDescriptorSet.newBuilder();
            resultBuilder.addFile(this.fileDescProtoBuilder.build());
            resultBuilder.mergeFrom(this.fileDescSetBuilder.build());
            try {
                return new TypeRepository(resultBuilder.build(), this.typeToNameMap);
            }
            catch (Descriptors.DescriptorValidationException dve) {
                throw new IllegalStateException("validation should not fail", dve);
            }
        }

        @Nonnull
        public Builder setName(@Nonnull String name) {
            this.fileDescProtoBuilder.setName(name);
            return this;
        }

        @Nonnull
        public Builder setPackage(@Nonnull String name) {
            this.fileDescProtoBuilder.setPackage(name);
            return this;
        }

        @Nonnull
        public Builder addTypeIfNeeded(@Nonnull Type type) {
            if (!this.typeToNameMap.containsKey(type)) {
                type.defineProtoType(this);
            }
            return this;
        }

        @Nonnull
        public Optional<String> getTypeName(@Nonnull Type type) {
            return Optional.ofNullable((String)this.typeToNameMap.get(type));
        }

        @Nonnull
        public Optional<Type> getTypeByName(@Nonnull String name) {
            return Optional.ofNullable((Type)this.typeToNameMap.inverse().get(name));
        }

        @Nonnull
        public Builder addMessageType(@Nonnull DescriptorProtos.DescriptorProto descriptorProto) {
            this.fileDescProtoBuilder.addMessageType(descriptorProto);
            return this;
        }

        @Nonnull
        public Builder addEnumType(@Nonnull DescriptorProtos.EnumDescriptorProto enumDescriptorProto) {
            this.fileDescProtoBuilder.addEnumType(enumDescriptorProto);
            return this;
        }

        @Nonnull
        public Builder registerTypeToTypeNameMapping(@Nonnull Type type, @Nonnull String protoTypeName) {
            Verify.verify(!this.typeToNameMap.containsKey(type));
            this.typeToNameMap.put(type, protoTypeName);
            return this;
        }

        @Nonnull
        public Builder addAllTypes(@Nonnull Collection<Type> types) {
            types.forEach(this::addTypeIfNeeded);
            return this;
        }

        @Nonnull
        public Optional<String> defineAndResolveType(@Nonnull Type type) {
            this.addTypeIfNeeded(type);
            return Optional.ofNullable((String)this.typeToNameMap.get(type));
        }

        @Nonnull
        public Builder addDependency(@Nonnull String dependency) {
            this.fileDescProtoBuilder.addDependency(dependency);
            return this;
        }

        @Nonnull
        public Builder addPublicDependency(@Nonnull String dependency) {
            for (int i = 0; i < this.fileDescProtoBuilder.getDependencyCount(); ++i) {
                if (!this.fileDescProtoBuilder.getDependency(i).equals(dependency)) continue;
                this.fileDescProtoBuilder.addPublicDependency(i);
                return this;
            }
            this.fileDescProtoBuilder.addDependency(dependency);
            this.fileDescProtoBuilder.addPublicDependency(this.fileDescProtoBuilder.getDependencyCount() - 1);
            return this;
        }

        @Nonnull
        public Builder addSchema(@Nonnull TypeRepository schema) {
            this.fileDescSetBuilder.mergeFrom(schema.fileDescSet);
            return this;
        }
    }
}

