/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PAbstractArrayConstructorValue;
import com.apple.foundationdb.record.planprotos.PLightArrayConstructorValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.CreatesDynamicTypesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class AbstractArrayConstructorValue
extends AbstractValue
implements CreatesDynamicTypesValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Array-Constructor-Value");
    @Nonnull
    private final List<? extends Value> children;
    @Nonnull
    private final Type elementType;

    protected AbstractArrayConstructorValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PAbstractArrayConstructorValue abstractArrayConstructorValueProto) {
        this(abstractArrayConstructorValueProto.getChildrenList().stream().map(valueProto -> Value.fromValueProto(serializationContext, valueProto)).collect(ImmutableList.toImmutableList()), Type.fromTypeProto(serializationContext, Objects.requireNonNull(abstractArrayConstructorValueProto.getElementType())));
    }

    protected AbstractArrayConstructorValue(@Nonnull List<? extends Value> children, @Nonnull Type elementType) {
        this.elementType = elementType;
        this.children = ImmutableList.copyOf(children);
    }

    @Nonnull
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return new Type.Array(this.elementType);
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return this.children;
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("array", new ExplainTokens().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), () -> Streams.stream(explainSuppliers).map(explainFunction -> ((ExplainTokensWithPrecedence)explainFunction.get()).getExplainTokens()).iterator())));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.children);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Nonnull
    PAbstractArrayConstructorValue toAbstractArrayConstructorProto(@Nonnull PlanSerializationContext serializationContext) {
        PAbstractArrayConstructorValue.Builder builder = PAbstractArrayConstructorValue.newBuilder();
        for (Value value : this.children) {
            builder.addChildren(value.toValueProto(serializationContext));
        }
        builder.setElementType(this.elementType.toTypeProto(serializationContext));
        return builder.build();
    }

    @Nonnull
    private static Value encapsulateInternal(@Nonnull List<? extends Typed> typedArgs) {
        ImmutableList arguments = typedArgs.stream().map(typedArg -> {
            Verify.verify(typedArg.getResultType().getTypeCode() != Type.TypeCode.RELATION && typedArg instanceof Value);
            return (Value)typedArg;
        }).collect(ImmutableList.toImmutableList());
        Type elementType = !typedArgs.isEmpty() ? AbstractArrayConstructorValue.resolveElementType(arguments) : Type.nullType();
        return new LightArrayConstructorValue(AbstractArrayConstructorValue.injectPromotions(arguments, elementType), elementType);
    }

    @Nonnull
    private static Type resolveElementType(@Nonnull Iterable<? extends Typed> argumentTypeds) {
        Type resolvedType = StreamSupport.stream(argumentTypeds.spliterator(), false).map(Typed::getResultType).reduce(null, (l, r) -> {
            if (l == null) {
                return r;
            }
            Verify.verifyNotNull(r);
            return Type.maximumType(l, r);
        });
        SemanticException.check(resolvedType != null, SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
        return resolvedType;
    }

    @Nonnull
    private static List<? extends Value> injectPromotions(@Nonnull Iterable<? extends Value> children, @Nonnull Type elementType) {
        return Streams.stream(children).map(child -> child.getResultType().nullable().equals(elementType.nullable()) ? child : PromoteValue.inject(child, elementType)).collect(ImmutableList.toImmutableList());
    }

    public static class LightArrayConstructorValue
    extends AbstractArrayConstructorValue {
        private LightArrayConstructorValue(@Nonnull List<? extends Value> children) {
            this(children, AbstractArrayConstructorValue.resolveElementType(children));
        }

        private LightArrayConstructorValue(@Nonnull Type elementType) {
            this(ImmutableList.of(), elementType);
        }

        private LightArrayConstructorValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLightArrayConstructorValue lightArrayConstructorValueProto) {
            super(serializationContext, Objects.requireNonNull(lightArrayConstructorValueProto.getSuper()));
        }

        private LightArrayConstructorValue(@Nonnull List<? extends Value> children, @Nonnull Type elementType) {
            super(children, elementType);
        }

        @Override
        @Nullable
        public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
            return Streams.stream(this.getChildren()).map(child -> child.eval(store, context)).collect(ImmutableList.toImmutableList());
        }

        @Override
        @Nonnull
        public LightArrayConstructorValue withChildren(Iterable<? extends Value> newChildren) {
            if (Iterables.isEmpty(newChildren)) {
                return this;
            }
            Verify.verify(AbstractArrayConstructorValue.resolveElementType(newChildren).equals(this.getElementType()));
            List<? extends Value> newChildrenPromoted = AbstractArrayConstructorValue.injectPromotions(newChildren, this.getElementType());
            if (LightArrayConstructorValue.elementsArePairwiseReferenceEqual(newChildrenPromoted, this.getChildren())) {
                return this;
            }
            return new LightArrayConstructorValue(newChildrenPromoted, this.getElementType());
        }

        @Override
        public boolean canResultInType(@Nonnull Type type) {
            if (!Iterables.isEmpty(this.getChildren())) {
                return false;
            }
            return type.isUnresolved();
        }

        @Override
        @Nonnull
        public Value with(@Nonnull Type type) {
            Verify.verify(Iterables.isEmpty(this.getChildren()));
            return LightArrayConstructorValue.emptyArray(type);
        }

        @Override
        @Nonnull
        public PLightArrayConstructorValue toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PLightArrayConstructorValue.newBuilder().setSuper(this.toAbstractArrayConstructorProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValue.newBuilder().setLightArrayConstructorValue(this.toProto(serializationContext)).build();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean elementsArePairwiseReferenceEqual(@Nonnull Iterable<? extends Value> first, @Nonnull Iterable<? extends Value> second) {
            if (Iterables.size(first) != Iterables.size(second)) return false;
            if (!Streams.zip(Streams.stream(first), Streams.stream(second), (firstItem, secondItem) -> firstItem == secondItem).allMatch(Boolean.TRUE::equals)) return false;
            return true;
        }

        @Nonnull
        public static LightArrayConstructorValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLightArrayConstructorValue lightArrayConstructorValueProto) {
            return new LightArrayConstructorValue(serializationContext, lightArrayConstructorValueProto);
        }

        @Nonnull
        public static LightArrayConstructorValue of(@Nonnull Value value1, Value ... valuesN) {
            ImmutableCollection children = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(value1)).add(valuesN)).build();
            return LightArrayConstructorValue.of((List<? extends Value>)((Object)children));
        }

        @Nonnull
        public static LightArrayConstructorValue of(@Nonnull List<? extends Value> children) {
            Verify.verify(!children.isEmpty());
            return new LightArrayConstructorValue(children);
        }

        @Nonnull
        public static LightArrayConstructorValue emptyArray(@Nonnull Type elementType) {
            return new LightArrayConstructorValue(elementType);
        }

        public static class Deserializer
        implements PlanDeserializer<PLightArrayConstructorValue, LightArrayConstructorValue> {
            @Override
            @Nonnull
            public Class<PLightArrayConstructorValue> getProtoMessageClass() {
                return PLightArrayConstructorValue.class;
            }

            @Override
            @Nonnull
            public LightArrayConstructorValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLightArrayConstructorValue lightArrayConstructorValueProto) {
                return LightArrayConstructorValue.fromProto(serializationContext, lightArrayConstructorValueProto);
            }
        }
    }

    public static class ArrayFn
    extends BuiltInFunction<Value> {
        public ArrayFn() {
            super("array", ImmutableList.of(), new Type.Any(), (BuiltInFunction<T> builtInFunction, List<Typed> typedArgs) -> AbstractArrayConstructorValue.encapsulateInternal(typedArgs));
        }
    }
}

