/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class AbstractValue
implements Value {
    @Nonnull
    private final Supplier<Set<CorrelationIdentifier>> correlatedToSupplier = Suppliers.memoize(this::computeCorrelatedTo);
    @Nonnull
    private final Supplier<Integer> semanticHashCodeSupplier = Suppliers.memoize(this::computeSemanticHashCode);
    @Nonnull
    private final Supplier<Integer> heightSupplier = Suppliers.memoize(() -> Value.super.height());
    @Nonnull
    private final Supplier<Iterable<? extends Value>> childrenSupplier = Suppliers.memoize(this::computeChildren);

    protected AbstractValue() {
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        return this.correlatedToSupplier.get();
    }

    @Nonnull
    private Set<CorrelationIdentifier> computeCorrelatedTo() {
        return this.fold(Value::getCorrelatedToWithoutChildren, (correlatedToWithoutChildren, childrenCorrelatedTo) -> {
            ImmutableSet.Builder correlatedToBuilder = ImmutableSet.builder();
            correlatedToBuilder.addAll((Iterable)correlatedToWithoutChildren);
            childrenCorrelatedTo.forEach(correlatedToBuilder::addAll);
            return correlatedToBuilder.build();
        });
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    public int semanticHashCode() {
        return this.semanticHashCodeSupplier.get();
    }

    private int computeSemanticHashCode() {
        return this.fold(Value::hashCodeWithoutChildren, (hashCodeWithoutChildren, childrenHashCodes) -> Objects.hash(childrenHashCodes, hashCodeWithoutChildren));
    }

    @Override
    public int height() {
        return this.heightSupplier.get();
    }

    @Override
    @Nonnull
    public Iterable<? extends Value> getChildren() {
        return this.childrenSupplier.get();
    }

    @Nonnull
    protected abstract Iterable<? extends Value> computeChildren();

    public String toString() {
        return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
    }
}

