/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PAndOrValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.BooleanValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class AndOrValue
extends AbstractValue
implements BooleanValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("And-Or-Value");
    @Nonnull
    private final String functionName;
    @Nonnull
    private final Value leftChild;
    @Nonnull
    private final Value rightChild;
    @Nonnull
    private final Operator operator;

    private AndOrValue(@Nonnull String functionName, @Nonnull Value leftChild, @Nonnull Value rightChild, @Nonnull Operator operator) {
        this.functionName = functionName;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.operator = operator;
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokensWithPrecedence left = Iterables.get(explainSuppliers, 0).get();
        ExplainTokensWithPrecedence right = Iterables.get(explainSuppliers, 1).get();
        ExplainTokensWithPrecedence.Precedence precedence = this.operator.getPrecedence();
        return ExplainTokensWithPrecedence.of(precedence, precedence.parenthesizeChild(left).addWhitespace().addKeyword(this.operator.getInfixRepresentation()).addWhitespace().addNested(precedence.parenthesizeChild(right)));
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.leftChild, this.rightChild);
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH, this.functionName);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.functionName, this.leftChild, this.rightChild);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object leftResult = this.leftChild.eval(store, context);
        if (this.operator == Operator.AND && Boolean.FALSE.equals(leftResult)) {
            return false;
        }
        if (this.operator == Operator.OR && Boolean.TRUE.equals(leftResult)) {
            return true;
        }
        Object rightResult = this.rightChild.eval(store, context);
        if (this.operator == Operator.AND && Boolean.FALSE.equals(rightResult)) {
            return false;
        }
        if (this.operator == Operator.OR && Boolean.TRUE.equals(rightResult)) {
            return true;
        }
        if (leftResult == null || rightResult == null) {
            return null;
        }
        if (this.operator == Operator.OR) {
            return (Boolean)rightResult != false || (Boolean)leftResult != false;
        }
        return (Boolean)rightResult != false && (Boolean)leftResult != false;
    }

    @Override
    public Optional<QueryPredicate> toQueryPredicate(@Nullable TypeRepository typeRepository, @Nonnull Set<CorrelationIdentifier> localAliases) {
        Verify.verify(this.leftChild instanceof BooleanValue);
        Verify.verify(this.rightChild instanceof BooleanValue);
        Optional<QueryPredicate> leftPredicateOptional = ((BooleanValue)this.leftChild).toQueryPredicate(typeRepository, localAliases);
        if (leftPredicateOptional.isPresent()) {
            QueryPredicate leftPredicate = leftPredicateOptional.get();
            if (this.operator == Operator.AND && leftPredicate.equals(ConstantPredicate.FALSE)) {
                return leftPredicateOptional;
            }
            if (this.operator == Operator.OR && leftPredicate.equals(ConstantPredicate.TRUE)) {
                return leftPredicateOptional;
            }
            Optional<QueryPredicate> rightPredicateOptional = ((BooleanValue)this.rightChild).toQueryPredicate(typeRepository, localAliases);
            if (rightPredicateOptional.isPresent()) {
                QueryPredicate rightPredicate = rightPredicateOptional.get();
                if (this.operator == Operator.AND && rightPredicate.equals(ConstantPredicate.FALSE)) {
                    return rightPredicateOptional;
                }
                if (this.operator == Operator.OR && rightPredicate.equals(ConstantPredicate.TRUE)) {
                    return rightPredicateOptional;
                }
                if (leftPredicate.equals(ConstantPredicate.NULL) || rightPredicate.equals(ConstantPredicate.NULL)) {
                    return Optional.of(ConstantPredicate.NULL);
                }
                if (leftPredicate instanceof ConstantPredicate && rightPredicate instanceof ConstantPredicate) {
                    if (this.operator == Operator.AND) {
                        return Optional.of(leftPredicate.isTautology() && rightPredicate.isTautology() ? ConstantPredicate.TRUE : ConstantPredicate.FALSE);
                    }
                    return Optional.of(leftPredicate.isTautology() || rightPredicate.isTautology() ? ConstantPredicate.TRUE : ConstantPredicate.FALSE);
                }
                if (this.operator == Operator.AND) {
                    return Optional.of(AndPredicate.and(leftPredicate, rightPredicate, new QueryPredicate[0]));
                }
                return Optional.of(OrPredicate.or(leftPredicate, rightPredicate, new QueryPredicate[0]));
            }
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public AndOrValue withChildren(Iterable<? extends Value> newChildren) {
        Verify.verify(Iterables.size(newChildren) == 2);
        return new AndOrValue(this.functionName, Iterables.get(newChildren, 0), Iterables.get(newChildren, 1), this.operator);
    }

    @Override
    @Nonnull
    public PAndOrValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PAndOrValue.newBuilder().setFunctionName(this.functionName).setLeftChild(this.leftChild.toValueProto(serializationContext)).setRightChild(this.rightChild.toValueProto(serializationContext)).setOperator(this.operator.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setAndOrValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static AndOrValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PAndOrValue andOrValueProto) {
        return new AndOrValue(Objects.requireNonNull(andOrValueProto.getFunctionName()), Value.fromValueProto(serializationContext, Objects.requireNonNull(andOrValueProto.getLeftChild())), Value.fromValueProto(serializationContext, Objects.requireNonNull(andOrValueProto.getRightChild())), Operator.fromProto(serializationContext, Objects.requireNonNull(andOrValueProto.getOperator())));
    }

    private static enum Operator {
        AND("AND", ExplainTokensWithPrecedence.Precedence.AND),
        OR("OR", ExplainTokensWithPrecedence.Precedence.OR);

        @Nonnull
        private final String infixRepresentation;
        @Nonnull
        private final ExplainTokensWithPrecedence.Precedence precedence;

        private Operator(String infixRepresentation, ExplainTokensWithPrecedence.Precedence precedence) {
            this.infixRepresentation = infixRepresentation;
            this.precedence = precedence;
        }

        @Nonnull
        private String getInfixRepresentation() {
            return this.infixRepresentation;
        }

        @Nonnull
        public ExplainTokensWithPrecedence.Precedence getPrecedence() {
            return this.precedence;
        }

        @Nonnull
        private PAndOrValue.POperator toProto(@Nonnull PlanSerializationContext serializationContext) {
            switch (this) {
                case AND: {
                    return PAndOrValue.POperator.AND;
                }
                case OR: {
                    return PAndOrValue.POperator.OR;
                }
            }
            throw new RecordCoreException("unknown operator mapping", new Object[0]);
        }

        @Nonnull
        private static Operator fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PAndOrValue.POperator operatorProto) {
            switch (operatorProto) {
                case AND: {
                    return AND;
                }
                case OR: {
                    return OR;
                }
            }
            throw new RecordCoreException("unknown operator mapping", new Object[0]);
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PAndOrValue, AndOrValue> {
        @Override
        @Nonnull
        public Class<PAndOrValue> getProtoMessageClass() {
            return PAndOrValue.class;
        }

        @Override
        @Nonnull
        public AndOrValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PAndOrValue andOrValueProto) {
            return AndOrValue.fromProto(serializationContext, andOrValueProto);
        }
    }

    public static class OrFn
    extends BuiltInFunction<Value> {
        public OrFn() {
            super("or", ImmutableList.of(Type.primitiveType(Type.TypeCode.BOOLEAN), Type.primitiveType(Type.TypeCode.BOOLEAN)), OrFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            Verify.verify(Iterables.size(arguments) == 2);
            return new AndOrValue(builtInFunction.getFunctionName(), (Value)arguments.get(0), (Value)arguments.get(1), Operator.OR);
        }
    }

    public static class AndFn
    extends BuiltInFunction<Value> {
        public AndFn() {
            super("and", List.of(Type.primitiveType(Type.TypeCode.BOOLEAN), Type.primitiveType(Type.TypeCode.BOOLEAN)), AndFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            Verify.verify(Iterables.size(arguments) == 2);
            return new AndOrValue(builtInFunction.getFunctionName(), (Value)arguments.get(0), (Value)arguments.get(1), Operator.AND);
        }
    }
}

