/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PArithmeticValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Enums;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ArithmeticValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Arithmetic-Value");
    @Nonnull
    private final PhysicalOperator operator;
    @Nonnull
    private final Value leftChild;
    @Nonnull
    private final Value rightChild;
    @Nonnull
    private static final Supplier<Map<BinaryOperatorSignature, PhysicalOperator>> operatorMapSupplier = Suppliers.memoize(ArithmeticValue::computeOperatorMap);

    public ArithmeticValue(@Nonnull PhysicalOperator operator, @Nonnull Value leftChild, @Nonnull Value rightChild) {
        this.operator = operator;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
    }

    @Nonnull
    public LogicalOperator getLogicalOperator() {
        return this.operator.getLogicalOperator();
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return this.operator.eval(this.leftChild.eval(store, context), this.rightChild.eval(store, context));
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSupplier) {
        ExplainTokensWithPrecedence left = Iterables.get(explainSupplier, 0).get();
        ExplainTokensWithPrecedence right = Iterables.get(explainSupplier, 1).get();
        LogicalOperator logicalOperator = this.getLogicalOperator();
        ExplainTokensWithPrecedence.Precedence precedence = logicalOperator.getPrecedence();
        return ExplainTokensWithPrecedence.of(precedence, precedence.parenthesizeChild(left).addWhitespace().addToString(logicalOperator.getInfixNotation()).addWhitespace().addNested(precedence.parenthesizeChild(right)));
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.primitiveType(this.operator.getResultTypeCode());
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.leftChild, this.rightChild);
    }

    @Override
    @Nonnull
    public ArithmeticValue withChildren(Iterable<? extends Value> newChildren) {
        Verify.verify(Iterables.size(newChildren) == 2);
        return new ArithmeticValue(this.operator, Iterables.get(newChildren, 0), Iterables.get(newChildren, 1));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, new Object[]{BASE_HASH, this.operator});
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.operator, this.leftChild, this.rightChild});
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> {
            ArithmeticValue otherArithmetic = (ArithmeticValue)other;
            return this.operator.equals((Object)otherArithmetic.operator);
        });
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PArithmeticValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PArithmeticValue.newBuilder().setOperator(this.operator.toProto(serializationContext)).setLeftChild(this.leftChild.toValueProto(serializationContext)).setRightChild(this.rightChild.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setArithmeticValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ArithmeticValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PArithmeticValue arithmeticValueProto) {
        return new ArithmeticValue(PhysicalOperator.fromProto(serializationContext, Objects.requireNonNull(arithmeticValueProto.getOperator())), Value.fromValueProto(serializationContext, Objects.requireNonNull(arithmeticValueProto.getLeftChild())), Value.fromValueProto(serializationContext, Objects.requireNonNull(arithmeticValueProto.getRightChild())));
    }

    @Nonnull
    private static Map<BinaryOperatorSignature, PhysicalOperator> getOperatorMap() {
        return operatorMapSupplier.get();
    }

    @Nonnull
    private static Value encapsulateInternal(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
        return ArithmeticValue.encapsulate(builtInFunction.getFunctionName(), arguments);
    }

    @Nonnull
    private static Value encapsulate(@Nonnull String functionName, @Nonnull List<? extends Typed> arguments) {
        Verify.verify(arguments.size() == 2);
        Typed arg0 = arguments.get(0);
        Type type0 = arg0.getResultType();
        SemanticException.check(type0.isPrimitive(), SemanticException.ErrorCode.ARGUMENT_TO_ARITHMETIC_OPERATOR_IS_OF_COMPLEX_TYPE);
        Typed arg1 = arguments.get(1);
        Type type1 = arg1.getResultType();
        SemanticException.check(type1.isPrimitive(), SemanticException.ErrorCode.ARGUMENT_TO_ARITHMETIC_OPERATOR_IS_OF_COMPLEX_TYPE);
        Optional<LogicalOperator> logicalOperatorOptional = Enums.getIfPresent(LogicalOperator.class, functionName.toUpperCase(Locale.ROOT)).toJavaUtil();
        Verify.verify(logicalOperatorOptional.isPresent());
        LogicalOperator logicalOperator = logicalOperatorOptional.get();
        PhysicalOperator physicalOperator = ArithmeticValue.getOperatorMap().get(new BinaryOperatorSignature(logicalOperator, type0.getTypeCode(), type1.getTypeCode()));
        Verify.verifyNotNull(physicalOperator, "unable to encapsulate arithmetic operation due to type mismatch(es)", new Object[0]);
        return new ArithmeticValue(physicalOperator, (Value)arg0, (Value)arg1);
    }

    private static Map<BinaryOperatorSignature, PhysicalOperator> computeOperatorMap() {
        ImmutableMap.Builder<BinaryOperatorSignature, PhysicalOperator> mapBuilder = ImmutableMap.builder();
        for (PhysicalOperator operator : PhysicalOperator.values()) {
            mapBuilder.put(new BinaryOperatorSignature(operator.getLogicalOperator(), operator.getLeftArgType(), operator.getRightArgType()), operator);
        }
        return mapBuilder.build();
    }

    @VisibleForTesting
    public static enum PhysicalOperator {
        ADD_II(LogicalOperator.ADD, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> Math.addExact((Integer)l, (Integer)r)),
        ADD_IL(LogicalOperator.ADD, Type.TypeCode.INT, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> Math.addExact((long)((Integer)l).intValue(), (Long)r)),
        ADD_IF(LogicalOperator.ADD, Type.TypeCode.INT, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf((float)((Integer)l).intValue() + ((Float)r).floatValue())),
        ADD_ID(LogicalOperator.ADD, Type.TypeCode.INT, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() + (Double)r),
        ADD_IS(LogicalOperator.ADD, Type.TypeCode.INT, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> (Integer)l + (String)r),
        ADD_LI(LogicalOperator.ADD, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> Math.addExact((Long)l, (long)((Integer)r).intValue())),
        ADD_LL(LogicalOperator.ADD, Type.TypeCode.LONG, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> Math.addExact((Long)l, (Long)r)),
        ADD_LF(LogicalOperator.ADD, Type.TypeCode.LONG, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf((float)((Long)l).longValue() + ((Float)r).floatValue())),
        ADD_LD(LogicalOperator.ADD, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() + (Double)r),
        ADD_LS(LogicalOperator.ADD, Type.TypeCode.LONG, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> (Long)l + (String)r),
        ADD_FI(LogicalOperator.ADD, Type.TypeCode.FLOAT, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() + (float)((Integer)r).intValue())),
        ADD_FL(LogicalOperator.ADD, Type.TypeCode.FLOAT, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() + (float)((Long)r).longValue())),
        ADD_FF(LogicalOperator.ADD, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() + ((Float)r).floatValue())),
        ADD_FD(LogicalOperator.ADD, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() + (Double)r),
        ADD_FS(LogicalOperator.ADD, Type.TypeCode.FLOAT, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> ((Float)l).floatValue() + (String)r),
        ADD_DI(LogicalOperator.ADD, Type.TypeCode.DOUBLE, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (Double)l + (double)((Integer)r).intValue()),
        ADD_DL(LogicalOperator.ADD, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (Double)l + (double)((Long)r).longValue()),
        ADD_DF(LogicalOperator.ADD, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (Double)l + (double)((Float)r).floatValue()),
        ADD_DD(LogicalOperator.ADD, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (Double)l + (Double)r),
        ADD_DS(LogicalOperator.ADD, Type.TypeCode.DOUBLE, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> (Double)l + (String)r),
        ADD_SI(LogicalOperator.ADD, Type.TypeCode.STRING, Type.TypeCode.INT, Type.TypeCode.STRING, (l, r) -> (String)l + (Integer)r),
        ADD_SL(LogicalOperator.ADD, Type.TypeCode.STRING, Type.TypeCode.LONG, Type.TypeCode.STRING, (l, r) -> (String)l + (Long)r),
        ADD_SF(LogicalOperator.ADD, Type.TypeCode.STRING, Type.TypeCode.FLOAT, Type.TypeCode.STRING, (l, r) -> (String)l + ((Float)r).floatValue()),
        ADD_SD(LogicalOperator.ADD, Type.TypeCode.STRING, Type.TypeCode.DOUBLE, Type.TypeCode.STRING, (l, r) -> (String)l + (Double)r),
        ADD_SS(LogicalOperator.ADD, Type.TypeCode.STRING, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> String.valueOf(l) + (String)r),
        SUB_II(LogicalOperator.SUB, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> Math.subtractExact((Integer)l, (Integer)r)),
        SUB_IL(LogicalOperator.SUB, Type.TypeCode.INT, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> Math.subtractExact((long)((Integer)l).intValue(), (Long)r)),
        SUB_IF(LogicalOperator.SUB, Type.TypeCode.INT, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf((float)((Integer)l).intValue() - ((Float)r).floatValue())),
        SUB_ID(LogicalOperator.SUB, Type.TypeCode.INT, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() - (Double)r),
        SUB_LI(LogicalOperator.SUB, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> Math.subtractExact((Long)l, (long)((Integer)r).intValue())),
        SUB_LL(LogicalOperator.SUB, Type.TypeCode.LONG, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> Math.subtractExact((Long)l, (Long)r)),
        SUB_LF(LogicalOperator.SUB, Type.TypeCode.LONG, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf((float)((Long)l).longValue() - ((Float)r).floatValue())),
        SUB_LD(LogicalOperator.SUB, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() - (Double)r),
        SUB_FI(LogicalOperator.SUB, Type.TypeCode.FLOAT, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() - (float)((Integer)r).intValue())),
        SUB_FL(LogicalOperator.SUB, Type.TypeCode.FLOAT, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() - (float)((Long)r).longValue())),
        SUB_FF(LogicalOperator.SUB, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() - ((Float)r).floatValue())),
        SUB_FD(LogicalOperator.SUB, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() - (Double)r),
        SUB_DI(LogicalOperator.SUB, Type.TypeCode.DOUBLE, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (Double)l - (double)((Integer)r).intValue()),
        SUB_DL(LogicalOperator.SUB, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (Double)l - (double)((Long)r).longValue()),
        SUB_DF(LogicalOperator.SUB, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (Double)l - (double)((Float)r).floatValue()),
        SUB_DD(LogicalOperator.SUB, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (Double)l - (Double)r),
        MUL_II(LogicalOperator.MUL, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> Math.multiplyExact((Integer)l, (int)((Integer)r))),
        MUL_IL(LogicalOperator.MUL, Type.TypeCode.INT, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> Math.multiplyExact((long)((Integer)l).intValue(), (Long)r)),
        MUL_IF(LogicalOperator.MUL, Type.TypeCode.INT, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf((float)((Integer)l).intValue() * ((Float)r).floatValue())),
        MUL_ID(LogicalOperator.MUL, Type.TypeCode.INT, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() * (Double)r),
        MUL_LI(LogicalOperator.MUL, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> Math.multiplyExact((long)((Long)l), (long)((Integer)r).intValue())),
        MUL_LL(LogicalOperator.MUL, Type.TypeCode.LONG, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> Math.multiplyExact((long)((Long)l), (Long)r)),
        MUL_LF(LogicalOperator.MUL, Type.TypeCode.LONG, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf((float)((Long)l).longValue() * ((Float)r).floatValue())),
        MUL_LD(LogicalOperator.MUL, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() * (Double)r),
        MUL_FI(LogicalOperator.MUL, Type.TypeCode.FLOAT, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() * (float)((Integer)r).intValue())),
        MUL_FL(LogicalOperator.MUL, Type.TypeCode.FLOAT, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() * (float)((Long)r).longValue())),
        MUL_FF(LogicalOperator.MUL, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() * ((Float)r).floatValue())),
        MUL_FD(LogicalOperator.MUL, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() * (Double)r),
        MUL_DI(LogicalOperator.MUL, Type.TypeCode.DOUBLE, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (Double)l * (double)((Integer)r).intValue()),
        MUL_DL(LogicalOperator.MUL, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (Double)l * (double)((Long)r).longValue()),
        MUL_DF(LogicalOperator.MUL, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (Double)l * (double)((Float)r).floatValue()),
        MUL_DD(LogicalOperator.MUL, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (Double)l * (Double)r),
        DIV_II(LogicalOperator.DIV, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> (Integer)l / (Integer)r),
        DIV_IL(LogicalOperator.DIV, Type.TypeCode.INT, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() / (Long)r),
        DIV_IF(LogicalOperator.DIV, Type.TypeCode.INT, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf((float)((Integer)l).intValue() / ((Float)r).floatValue())),
        DIV_ID(LogicalOperator.DIV, Type.TypeCode.INT, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() / (Double)r),
        DIV_LI(LogicalOperator.DIV, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (Long)l / (long)((Integer)r).intValue()),
        DIV_LL(LogicalOperator.DIV, Type.TypeCode.LONG, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (Long)l / (Long)r),
        DIV_LF(LogicalOperator.DIV, Type.TypeCode.LONG, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf((float)((Long)l).longValue() / ((Float)r).floatValue())),
        DIV_LD(LogicalOperator.DIV, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() / (Double)r),
        DIV_FI(LogicalOperator.DIV, Type.TypeCode.FLOAT, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() / (float)((Integer)r).intValue())),
        DIV_FL(LogicalOperator.DIV, Type.TypeCode.FLOAT, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() / (float)((Long)r).longValue())),
        DIV_FF(LogicalOperator.DIV, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() / ((Float)r).floatValue())),
        DIV_FD(LogicalOperator.DIV, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() / (Double)r),
        DIV_DI(LogicalOperator.DIV, Type.TypeCode.DOUBLE, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (Double)l / (double)((Integer)r).intValue()),
        DIV_DL(LogicalOperator.DIV, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (Double)l / (double)((Long)r).longValue()),
        DIV_DF(LogicalOperator.DIV, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (Double)l / (double)((Float)r).floatValue()),
        DIV_DD(LogicalOperator.DIV, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (Double)l / (Double)r),
        MOD_II(LogicalOperator.MOD, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> (Integer)l % (Integer)r),
        MOD_IL(LogicalOperator.MOD, Type.TypeCode.INT, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() % (Long)r),
        MOD_IF(LogicalOperator.MOD, Type.TypeCode.INT, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf((float)((Integer)l).intValue() % ((Float)r).floatValue())),
        MOD_ID(LogicalOperator.MOD, Type.TypeCode.INT, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() % (Double)r),
        MOD_LI(LogicalOperator.MOD, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (Long)l % (long)((Integer)r).intValue()),
        MOD_LL(LogicalOperator.MOD, Type.TypeCode.LONG, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (Long)l % (Long)r),
        MOD_LF(LogicalOperator.MOD, Type.TypeCode.LONG, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf((float)((Long)l).longValue() % ((Float)r).floatValue())),
        MOD_LD(LogicalOperator.MOD, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() % (Double)r),
        MOD_FI(LogicalOperator.MOD, Type.TypeCode.FLOAT, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() % (float)((Integer)r).intValue())),
        MOD_FL(LogicalOperator.MOD, Type.TypeCode.FLOAT, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() % (float)((Long)r).longValue())),
        MOD_FF(LogicalOperator.MOD, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> Float.valueOf(((Float)l).floatValue() % ((Float)r).floatValue())),
        MOD_FD(LogicalOperator.MOD, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() % (Double)r),
        MOD_DI(LogicalOperator.MOD, Type.TypeCode.DOUBLE, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (Double)l % (double)((Integer)r).intValue()),
        MOD_DL(LogicalOperator.MOD, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (Double)l % (double)((Long)r).longValue()),
        MOD_DF(LogicalOperator.MOD, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (Double)l % (double)((Float)r).floatValue()),
        MOD_DD(LogicalOperator.MOD, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (Double)l % (Double)r),
        BITOR_II(LogicalOperator.BITOR, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> (Integer)l | (Integer)r),
        BITOR_IL(LogicalOperator.BITOR, Type.TypeCode.INT, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() | (Long)r),
        BITOR_LI(LogicalOperator.BITOR, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (Long)l | (long)((Integer)r).intValue()),
        BITOR_LL(LogicalOperator.BITOR, Type.TypeCode.LONG, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (Long)l | (Long)r),
        BITAND_II(LogicalOperator.BITAND, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> (Integer)l & (Integer)r),
        BITAND_IL(LogicalOperator.BITAND, Type.TypeCode.INT, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() & (Long)r),
        BITAND_LI(LogicalOperator.BITAND, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (Long)l & (long)((Integer)r).intValue()),
        BITAND_LL(LogicalOperator.BITAND, Type.TypeCode.LONG, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (Long)l & (Long)r),
        BITXOR_II(LogicalOperator.BITXOR, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> (Integer)l ^ (Integer)r),
        BITXOR_IL(LogicalOperator.BITXOR, Type.TypeCode.INT, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() ^ (Long)r),
        BITXOR_LI(LogicalOperator.BITXOR, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (Long)l ^ (long)((Integer)r).intValue()),
        BITXOR_LL(LogicalOperator.BITXOR, Type.TypeCode.LONG, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (Long)l ^ (Long)r),
        BITMAP_BUCKET_OFFSET_LI(LogicalOperator.BITMAP_BUCKET_OFFSET, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> Math.multiplyExact(Math.floorDiv((long)((Long)l), (int)((Integer)r)), (int)((Integer)r))),
        BITMAP_BUCKET_OFFSET_II(LogicalOperator.BITMAP_BUCKET_OFFSET, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> Math.multiplyExact(Math.floorDiv((Integer)l, (int)((Integer)r)), (int)((Integer)r))),
        BITMAP_BUCKET_NUMBER_LI(LogicalOperator.BITMAP_BUCKET_NUMBER, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> Math.floorDiv((long)((Long)l), (int)((Integer)r))),
        BITMAP_BUCKET_NUMBER_II(LogicalOperator.BITMAP_BUCKET_NUMBER, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> Math.floorDiv((Integer)l, (int)((Integer)r))),
        BITMAP_BIT_POSITION_LI(LogicalOperator.BITMAP_BIT_POSITION, Type.TypeCode.LONG, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> Math.subtractExact((Long)l, Math.multiplyExact(Math.floorDiv((long)((Long)l), (int)((Integer)r)), (int)((Integer)r)))),
        BITMAP_BIT_POSITION_II(LogicalOperator.BITMAP_BIT_POSITION, Type.TypeCode.INT, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> Math.subtractExact((Integer)l, Math.multiplyExact(Math.floorDiv((Integer)l, (int)((Integer)r)), (int)((Integer)r))));

        @Nonnull
        private static final Supplier<BiMap<PhysicalOperator, PArithmeticValue.PPhysicalOperator>> protoEnumBiMapSupplier;
        @Nonnull
        private final LogicalOperator logicalOperator;
        @Nonnull
        private final Type.TypeCode leftArgType;
        @Nonnull
        private final Type.TypeCode rightArgType;
        @Nonnull
        private final Type.TypeCode resultType;
        @Nonnull
        private final BinaryOperator<Object> evaluateFunction;

        private PhysicalOperator(@Nonnull LogicalOperator logicalOperator, @Nonnull Type.TypeCode leftArgType, @Nonnull Type.TypeCode rightArgType, Type.TypeCode resultType, BinaryOperator<Object> evaluateFunction) {
            this.logicalOperator = logicalOperator;
            this.leftArgType = leftArgType;
            this.rightArgType = rightArgType;
            this.resultType = resultType;
            this.evaluateFunction = evaluateFunction;
        }

        @Nonnull
        public LogicalOperator getLogicalOperator() {
            return this.logicalOperator;
        }

        @Nonnull
        public Type.TypeCode getLeftArgType() {
            return this.leftArgType;
        }

        @Nonnull
        public Type.TypeCode getRightArgType() {
            return this.rightArgType;
        }

        @Nonnull
        public Type.TypeCode getResultTypeCode() {
            return this.resultType;
        }

        @Nullable
        public Object eval(@Nullable Object arg1, @Nullable Object arg2) {
            if (arg1 == null || arg2 == null) {
                return null;
            }
            return this.evaluateFunction.apply(arg1, arg2);
        }

        @Nonnull
        public PArithmeticValue.PPhysicalOperator toProto(@Nonnull PlanSerializationContext serializationContext) {
            return Objects.requireNonNull((PArithmeticValue.PPhysicalOperator)PhysicalOperator.getProtoEnumBiMap().get((Object)this));
        }

        @Nonnull
        public static PhysicalOperator fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PArithmeticValue.PPhysicalOperator physicalOperatorProto) {
            return Objects.requireNonNull((PhysicalOperator)((Object)PhysicalOperator.getProtoEnumBiMap().inverse().get(physicalOperatorProto)));
        }

        @Nonnull
        private static BiMap<PhysicalOperator, PArithmeticValue.PPhysicalOperator> getProtoEnumBiMap() {
            return protoEnumBiMapSupplier.get();
        }

        static {
            protoEnumBiMapSupplier = Suppliers.memoize(() -> PlanSerialization.protoEnumBiMap(PhysicalOperator.class, PArithmeticValue.PPhysicalOperator.class));
        }
    }

    public static enum LogicalOperator {
        ADD("+", ExplainTokensWithPrecedence.Precedence.ADDITIVE),
        SUB("-", ExplainTokensWithPrecedence.Precedence.ADDITIVE),
        MUL("*", ExplainTokensWithPrecedence.Precedence.MULTIPLICATIVE),
        DIV("/", ExplainTokensWithPrecedence.Precedence.MULTIPLICATIVE),
        MOD("%", ExplainTokensWithPrecedence.Precedence.MULTIPLICATIVE),
        BITOR("|", ExplainTokensWithPrecedence.Precedence.BITWISE_OR),
        BITAND("&", ExplainTokensWithPrecedence.Precedence.BITWISE_AND),
        BITXOR("^", ExplainTokensWithPrecedence.Precedence.BITWISE_XOR),
        BITMAP_BUCKET_NUMBER("bitmap_bucket_number", ExplainTokensWithPrecedence.Precedence.NEVER_PARENS),
        BITMAP_BUCKET_OFFSET("bitmap_bucket_offset", ExplainTokensWithPrecedence.Precedence.NEVER_PARENS),
        BITMAP_BIT_POSITION("bitmap_bit_position", ExplainTokensWithPrecedence.Precedence.NEVER_PARENS);

        @Nonnull
        private final String infixNotation;
        @Nonnull
        private final ExplainTokensWithPrecedence.Precedence precedence;

        private LogicalOperator(String infixNotation, ExplainTokensWithPrecedence.Precedence precedence) {
            this.infixNotation = infixNotation;
            this.precedence = precedence;
        }

        @Nonnull
        public String getInfixNotation() {
            return this.infixNotation;
        }

        @Nonnull
        public ExplainTokensWithPrecedence.Precedence getPrecedence() {
            return this.precedence;
        }
    }

    static final class BinaryOperatorSignature {
        @Nonnull
        private final LogicalOperator logicalOperator;
        @Nonnull
        private final Type.TypeCode leftType;
        @Nonnull
        private final Type.TypeCode rightType;

        BinaryOperatorSignature(@Nonnull LogicalOperator logicalOperator, @Nonnull Type.TypeCode leftType, @Nonnull Type.TypeCode rightType) {
            this.logicalOperator = logicalOperator;
            this.leftType = leftType;
            this.rightType = rightType;
        }

        @Nonnull
        public LogicalOperator getLogicalOperator() {
            return this.logicalOperator;
        }

        @Nonnull
        public Type.TypeCode getLeftType() {
            return this.leftType;
        }

        @Nonnull
        public Type.TypeCode getRightType() {
            return this.rightType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BinaryOperatorSignature that = (BinaryOperatorSignature)o;
            return this.logicalOperator == that.logicalOperator && this.leftType == that.leftType && this.rightType == that.rightType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.logicalOperator, this.leftType, this.rightType});
        }

        public String toString() {
            return String.valueOf((Object)this.logicalOperator) + "(" + String.valueOf((Object)this.leftType) + ", " + String.valueOf((Object)this.rightType) + ")";
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PArithmeticValue, ArithmeticValue> {
        @Override
        @Nonnull
        public Class<PArithmeticValue> getProtoMessageClass() {
            return PArithmeticValue.class;
        }

        @Override
        @Nonnull
        public ArithmeticValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PArithmeticValue arithmeticValueProto) {
            return ArithmeticValue.fromProto(serializationContext, arithmeticValueProto);
        }
    }

    public static class BitmapBucketOffsetFn
    extends BuiltInFunction<Value> {
        public BitmapBucketOffsetFn() {
            super("bitmap_bucket_offset", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }

    public static class BitXorFn
    extends BuiltInFunction<Value> {
        public BitXorFn() {
            super("bitxor", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }

    public static class BitAndFn
    extends BuiltInFunction<Value> {
        public BitAndFn() {
            super("bitand", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }

    public static class BitOrFn
    extends BuiltInFunction<Value> {
        public BitOrFn() {
            super("bitor", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }

    public static class BitmapBucketNumberFn
    extends BuiltInFunction<Value> {
        public BitmapBucketNumberFn() {
            super("bitmap_bucket_number", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }

    public static class BitmapBitPositionFn
    extends BuiltInFunction<Value> {
        public BitmapBitPositionFn() {
            super("bitmap_bit_position", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }

    public static class ModFn
    extends BuiltInFunction<Value> {
        public ModFn() {
            super("mod", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }

    public static class DivFn
    extends BuiltInFunction<Value> {
        public DivFn() {
            super("div", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }

    public static class MulFn
    extends BuiltInFunction<Value> {
        public MulFn() {
            super("mul", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }

    public static class SubFn
    extends BuiltInFunction<Value> {
        public SubFn() {
            super("sub", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }

    public static class AddFn
    extends BuiltInFunction<Value> {
        public AddFn() {
            super("add", ImmutableList.of(Type.any(), Type.any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> ArithmeticValue.encapsulateInternal(x$0, x$1));
        }
    }
}

