/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PArrayDistinctValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ArrayDistinctValue
extends AbstractValue
implements ValueWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Array-Distinct-Value");
    @Nonnull
    private final Value childValue;
    @Nonnull
    private final Type resultType;

    public ArrayDistinctValue(@Nonnull Value childValue) {
        Type innerResultType = Objects.requireNonNull(childValue.getResultType());
        Verify.verify(innerResultType.isArray());
        this.childValue = childValue;
        this.resultType = innerResultType;
    }

    @Nonnull
    public List<? extends Value> computeChildren() {
        return ImmutableList.of(this.childValue);
    }

    @Override
    @Nonnull
    public Value getChild() {
        return this.childValue;
    }

    @Override
    @Nonnull
    public ValueWithChild withNewChild(@Nonnull Value rebasedChild) {
        if (this.getChild() == rebasedChild) {
            return this;
        }
        return new ArrayDistinctValue(rebasedChild);
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object childResult = this.childValue.eval(store, context);
        if (childResult == null) {
            return null;
        }
        return ((List)childResult).stream().distinct().collect(ImmutableList.toImmutableList());
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.childValue);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("arrayDistinct", Value.explainFunctionArguments(explainSuppliers)));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PArrayDistinctValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PArrayDistinctValue.newBuilder().setChildValue(this.childValue.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setArrayDistinctValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ArrayDistinctValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PArrayDistinctValue arrayDistinctValueProto) {
        return new ArrayDistinctValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(arrayDistinctValueProto.getChildValue())));
    }

    public static class Deserializer
    implements PlanDeserializer<PArrayDistinctValue, ArrayDistinctValue> {
        @Override
        @Nonnull
        public Class<PArrayDistinctValue> getProtoMessageClass() {
            return PArrayDistinctValue.class;
        }

        @Override
        @Nonnull
        public ArrayDistinctValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PArrayDistinctValue arrayDistinctValueProto) {
            return ArrayDistinctValue.fromProto(serializationContext, arrayDistinctValueProto);
        }
    }
}

