/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.util.ServiceLoaderProvider;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltInFunctionCatalog {
    private static final Logger logger = LoggerFactory.getLogger(BuiltInFunctionCatalog.class);
    private static final Supplier<Map<FunctionKey, BuiltInFunction<? extends Typed>>> catalogSupplier = Suppliers.memoize(BuiltInFunctionCatalog::loadFunctions);
    private static final Supplier<Map<Class<BuiltInFunction<? extends Typed>>, BuiltInFunction<? extends Typed>>> functionsByClassSupplier = Suppliers.memoize(BuiltInFunctionCatalog::computeFunctionsByClass);

    private BuiltInFunctionCatalog() {
    }

    private static Map<FunctionKey, BuiltInFunction<? extends Typed>> getFunctionCatalog() {
        return catalogSupplier.get();
    }

    private static Map<FunctionKey, BuiltInFunction<? extends Typed>> loadFunctions() {
        ImmutableMap.Builder catalogBuilder = ImmutableMap.builder();
        Iterable<BuiltInFunction> loader = ServiceLoaderProvider.load(BuiltInFunction.class);
        loader.forEach(builtInFunction -> {
            catalogBuilder.put(new FunctionKey(builtInFunction.getFunctionName(), builtInFunction.getParameterTypes().size(), builtInFunction.hasVariadicSuffix()), builtInFunction);
            if (logger.isTraceEnabled()) {
                logger.trace("loaded function " + String.valueOf(builtInFunction));
            }
        });
        return catalogBuilder.build();
    }

    @Nonnull
    public static Optional<BuiltInFunction<? extends Typed>> resolve(@Nonnull String functionName, int numberOfArguments) {
        BuiltInFunction<? extends Typed> builtInFunction = BuiltInFunctionCatalog.getFunctionCatalog().get(new FunctionKey(functionName, numberOfArguments, false));
        if (builtInFunction == null && (builtInFunction = BuiltInFunctionCatalog.getFunctionCatalog().get(new FunctionKey(functionName, numberOfArguments, true))) != null && builtInFunction.getParameterTypes().size() > numberOfArguments) {
            return Optional.empty();
        }
        return Optional.ofNullable(builtInFunction);
    }

    @Nonnull
    private static Map<Class<BuiltInFunction<? extends Typed>>, BuiltInFunction<? extends Typed>> getFunctionsByClass() {
        return functionsByClassSupplier.get();
    }

    @Nonnull
    private static Map<Class<BuiltInFunction<? extends Typed>>, BuiltInFunction<? extends Typed>> computeFunctionsByClass() {
        Map<FunctionKey, BuiltInFunction<? extends Typed>> functionCatalog = BuiltInFunctionCatalog.getFunctionCatalog();
        ImmutableMap.Builder<Class<?>, BuiltInFunction<? extends Typed>> resultBuilder = ImmutableMap.builder();
        for (BuiltInFunction<? extends Typed> singleton : functionCatalog.values()) {
            resultBuilder.put(singleton.getClass(), singleton);
        }
        return resultBuilder.build();
    }

    @Nonnull
    public static Optional<BuiltInFunction<? extends Typed>> getFunctionSingleton(@Nonnull Class<? extends BuiltInFunction<? extends Typed>> clazz) {
        return Optional.ofNullable(BuiltInFunctionCatalog.getFunctionsByClass().get(clazz));
    }

    private static class FunctionKey {
        @Nonnull
        final String functionName;
        final int numParameters;
        final boolean isVariadic;

        public FunctionKey(@Nonnull String functionName, int numParameters, boolean isVariadic) {
            this.functionName = functionName;
            this.numParameters = numParameters;
            this.isVariadic = isVariadic;
        }

        @Nonnull
        public String getFunctionName() {
            return this.functionName;
        }

        public int getNumParameters() {
            return this.numParameters;
        }

        public boolean isVariadic() {
            return this.isVariadic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FunctionKey)) {
                return false;
            }
            FunctionKey that = (FunctionKey)o;
            if (this.isVariadic()) {
                return that.isVariadic() && this.getFunctionName().equals(that.getFunctionName());
            }
            return !that.isVariadic() && this.getNumParameters() == that.getNumParameters() && this.getFunctionName().equals(that.getFunctionName());
        }

        public int hashCode() {
            if (this.isVariadic()) {
                return Objects.hash(this.getFunctionName());
            }
            return Objects.hash(this.getFunctionName(), this.getNumParameters());
        }
    }
}

