/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.CollateFunctionKeyExpression;
import com.apple.foundationdb.record.planprotos.PCollateValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.common.text.TextCollator;
import com.apple.foundationdb.record.provider.common.text.TextCollatorRegistry;
import com.apple.foundationdb.record.provider.common.text.TextCollatorRegistryJRE;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class CollateValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Collate-Value");
    @Nonnull
    private final TextCollatorRegistry collatorRegistry;
    @Nonnull
    private final Value stringChild;
    @Nullable
    private final Value localeChild;
    @Nullable
    private final Value strengthChild;
    @Nullable
    private final TextCollator invariableCollator;

    public CollateValue(@Nonnull TextCollatorRegistry collatorRegistry, @Nonnull Value stringChild, @Nullable Value localeChild, @Nullable Value strengthChild) {
        this.collatorRegistry = collatorRegistry;
        this.stringChild = stringChild;
        this.localeChild = localeChild;
        this.strengthChild = strengthChild;
        this.invariableCollator = CollateValue.getInvariableCollator(collatorRegistry, localeChild, strengthChild);
    }

    @Nonnull
    public TextCollatorRegistry getCollatorRegistry() {
        return this.collatorRegistry;
    }

    @Override
    @Nullable
    public <M extends Message> ByteString eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        String str = (String)this.stringChild.eval(store, context);
        TextCollator collator = this.getTextCollator(store, context);
        return collator.getKey(str);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokens localeExplainTokens;
        ExplainTokens stringExplainTokens = Iterables.get(explainSuppliers, 0).get().getExplainTokens();
        ExplainTokens explainTokens = localeExplainTokens = this.localeChild == null ? new ExplainTokens().addKeyword("DEFAULT") : Iterables.get(explainSuppliers, 1).get().getExplainTokens();
        ExplainTokens strengthExplainTokens = this.strengthChild == null ? new ExplainTokens().addKeyword("DEFAULT") : Iterables.get(explainSuppliers, this.localeChild == null ? 1 : 2).get().getExplainTokens();
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("collate", new ExplainTokens().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), stringExplainTokens, localeExplainTokens, new ExplainTokens().addKeyword("STRENGTH").addWhitespace().addNested(strengthExplainTokens))));
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.primitiveType(Type.TypeCode.BYTES);
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        ImmutableList.Builder list = ImmutableList.builder();
        list.add(this.stringChild);
        if (this.localeChild != null) {
            list.add(this.localeChild);
        }
        if (this.strengthChild != null) {
            list.add(this.strengthChild);
        }
        return list.build();
    }

    @Override
    @Nonnull
    public CollateValue withChildren(Iterable<? extends Value> newChildren) {
        Value strengthChild;
        Value localeChild;
        Iterator<? extends Value> iter = newChildren.iterator();
        Verify.verify(iter.hasNext());
        Value stringChild = iter.next();
        if (iter.hasNext()) {
            localeChild = iter.next();
            strengthChild = iter.hasNext() ? iter.next() : null;
        } else {
            localeChild = null;
            strengthChild = null;
        }
        Verify.verify(!iter.hasNext());
        return new CollateValue(this.collatorRegistry, stringChild, localeChild, strengthChild);
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH, this.collatorRegistry.getName());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.collatorRegistry.getName(), this.stringChild, this.localeChild, this.strengthChild);
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> {
            CollateValue otherCollate = (CollateValue)other;
            return this.collatorRegistry.equals(otherCollate.collatorRegistry);
        });
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PCollateValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PCollateValue.Builder builder = PCollateValue.newBuilder();
        builder.setCollatorRegistry(this.collatorRegistry.getName());
        builder.setStringChild(this.stringChild.toValueProto(serializationContext));
        if (this.localeChild != null) {
            builder.setLocaleChild(this.localeChild.toValueProto(serializationContext));
        }
        if (this.strengthChild != null) {
            builder.setStrengthChild(this.strengthChild.toValueProto(serializationContext));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setCollateValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static CollateValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PCollateValue collateValueProto) {
        TextCollatorRegistry collatorRegistry = CollateValue.getCollatorRegistryFromProto(collateValueProto.getCollatorRegistry());
        Value stringChild = Value.fromValueProto(serializationContext, collateValueProto.getStringChild());
        Value localeChild = collateValueProto.hasLocaleChild() ? Value.fromValueProto(serializationContext, collateValueProto.getLocaleChild()) : null;
        Value strengthChild = collateValueProto.hasStrengthChild() ? Value.fromValueProto(serializationContext, collateValueProto.getStrengthChild()) : null;
        return new CollateValue(collatorRegistry, stringChild, localeChild, strengthChild);
    }

    @Nullable
    protected static TextCollator getInvariableCollator(@Nonnull TextCollatorRegistry collatorRegistry, @Nullable Value localeChild, @Nullable Value strengthChild) {
        if (localeChild == null) {
            if (strengthChild == null) {
                return collatorRegistry.getTextCollator();
            }
            if (strengthChild instanceof LiteralValue) {
                Integer strength = (Integer)((LiteralValue)strengthChild).getLiteralValue();
                return collatorRegistry.getTextCollator(strength == null ? 0 : strength);
            }
        } else if (localeChild instanceof LiteralValue) {
            String locale = (String)((LiteralValue)localeChild).getLiteralValue();
            if (locale == null) {
                if (strengthChild == null) {
                    return collatorRegistry.getTextCollator();
                }
                if (strengthChild instanceof LiteralValue) {
                    Integer strength = (Integer)((LiteralValue)strengthChild).getLiteralValue();
                    return collatorRegistry.getTextCollator(strength == null ? 0 : strength);
                }
            } else {
                if (strengthChild == null) {
                    return collatorRegistry.getTextCollator(locale);
                }
                if (strengthChild instanceof LiteralValue) {
                    Integer strength = (Integer)((LiteralValue)strengthChild).getLiteralValue();
                    return collatorRegistry.getTextCollator(locale, strength == null ? 0 : strength);
                }
            }
        }
        return null;
    }

    @Nonnull
    private <M extends Message> TextCollator getTextCollator(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        if (this.invariableCollator != null) {
            return this.invariableCollator;
        }
        if (this.localeChild != null) {
            String locale = (String)this.localeChild.eval(store, context);
            if (this.strengthChild != null) {
                int strength = (Integer)this.strengthChild.eval(store, context);
                return this.collatorRegistry.getTextCollator(locale, strength);
            }
            return this.collatorRegistry.getTextCollator(locale);
        }
        if (this.strengthChild != null) {
            int strength = (Integer)this.strengthChild.eval(store, context);
            return this.collatorRegistry.getTextCollator(strength);
        }
        return this.collatorRegistry.getTextCollator();
    }

    private static TextCollatorRegistry getCollatorRegistryFromProto(@Nonnull String name) {
        CollateFunctionKeyExpression keyExpression = (CollateFunctionKeyExpression)Key.Expressions.function("collate_" + name, Key.Expressions.concatenateFields("_string", "_locale", "_strength"));
        return keyExpression.getCollatorRegistry();
    }

    @Nonnull
    private static Value encapsulate(@Nonnull TextCollatorRegistry collatorRegistry, @Nonnull List<? extends Typed> arguments) {
        Typed strengthArg;
        Typed localeArg;
        int nargs = arguments.size();
        Verify.verify(nargs >= 1 && nargs <= 3);
        Typed stringArg = arguments.get(0);
        SemanticException.check(stringArg.getResultType().isPrimitive(), SemanticException.ErrorCode.ARGUMENT_TO_COLLATE_IS_OF_COMPLEX_TYPE);
        if (nargs > 1) {
            localeArg = arguments.get(1);
            SemanticException.check(localeArg.getResultType().isPrimitive(), SemanticException.ErrorCode.ARGUMENT_TO_COLLATE_IS_OF_COMPLEX_TYPE);
        } else {
            localeArg = null;
        }
        if (nargs > 2) {
            strengthArg = arguments.get(2);
            SemanticException.check(strengthArg.getResultType().isPrimitive(), SemanticException.ErrorCode.ARGUMENT_TO_COLLATE_IS_OF_COMPLEX_TYPE);
        } else {
            strengthArg = null;
        }
        return new CollateValue(collatorRegistry, (Value)stringArg, (Value)localeArg, (Value)strengthArg);
    }

    public static class CollateValueJRE
    extends CollateFunction {
        public CollateValueJRE() {
            super("collate_jre", TextCollatorRegistryJRE.instance());
        }
    }

    public static class CollateFunction
    extends BuiltInFunction<Value> {
        public CollateFunction(@Nonnull String functionName, @Nonnull TextCollatorRegistry collatorRegistry) {
            super(functionName, ImmutableList.of(Type.primitiveType(Type.TypeCode.STRING)), Type.any(), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> CollateValue.encapsulate(collatorRegistry, arguments));
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PCollateValue, CollateValue> {
        @Override
        @Nonnull
        public Class<PCollateValue> getProtoMessageClass() {
            return PCollateValue.class;
        }

        @Override
        @Nonnull
        public CollateValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PCollateValue collateValueProto) {
            return CollateValue.fromProto(serializationContext, collateValueProto);
        }
    }
}

