/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PConditionSelectorValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConditionSelectorValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Condition-Selector-Value");
    @Nonnull
    private final List<? extends Value> implications;

    public ConditionSelectorValue(@Nonnull Iterable<? extends Value> implications) {
        this.implications = ImmutableList.copyOf(implications);
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return this.implications;
    }

    @Override
    @Nonnull
    public Value withChildren(Iterable<? extends Value> newChildren) {
        return new ConditionSelectorValue(newChildren);
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        return this.implications.stream().allMatch(implication -> implication.isFunctionallyDependentOn(otherValue));
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.primitiveType(Type.TypeCode.INT);
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        for (int i = 0; i < this.implications.size(); ++i) {
            Boolean result = (Boolean)this.implications.get(i).eval(store, context);
            if (!Boolean.TRUE.equals(result)) continue;
            return i;
        }
        return null;
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("ConditionSelector", Value.explainFunctionArguments(explainSuppliers)));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.implications);
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    @Nonnull
    public PConditionSelectorValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PConditionSelectorValue.Builder builder = PConditionSelectorValue.newBuilder();
        for (Value value : this.implications) {
            builder.addImplications(value.toValueProto(serializationContext));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setConditionSelectorValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ConditionSelectorValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConditionSelectorValue conditionSelectorValueProto) {
        ImmutableList.Builder implicationsBuilder = ImmutableList.builder();
        for (int i = 0; i < conditionSelectorValueProto.getImplicationsCount(); ++i) {
            implicationsBuilder.add(Value.fromValueProto(serializationContext, conditionSelectorValueProto.getImplications(i)));
        }
        return new ConditionSelectorValue(implicationsBuilder.build());
    }

    public static class Deserializer
    implements PlanDeserializer<PConditionSelectorValue, ConditionSelectorValue> {
        @Override
        @Nonnull
        public Class<PConditionSelectorValue> getProtoMessageClass() {
            return PConditionSelectorValue.class;
        }

        @Override
        @Nonnull
        public ConditionSelectorValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConditionSelectorValue conditionSelectorValueProto) {
            return ConditionSelectorValue.fromProto(serializationContext, conditionSelectorValueProto);
        }
    }
}

