/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PConstantObjectValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.CreatesDynamicTypesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConstantObjectValue
extends AbstractValue
implements LeafValue,
Value.RangeMatchableValue,
CreatesDynamicTypesValue {
    @Nonnull
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Constant-Object-Value");
    @Nonnull
    private final CorrelationIdentifier alias;
    private final String constantId;
    @Nonnull
    private final Type resultType;

    private ConstantObjectValue(@Nonnull CorrelationIdentifier alias, @Nonnull String constantId, @Nonnull Type resultType) {
        this.alias = alias;
        this.constantId = constantId;
        this.resultType = resultType;
    }

    @Nonnull
    public CorrelationIdentifier getAlias() {
        return this.alias;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return Set.of();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> this.constantId.equals(((ConstantObjectValue)other).constantId));
    }

    @Override
    public boolean canResultInType(@Nonnull Type type) {
        return this.resultType.getTypeCode() == Type.TypeCode.NULL || this.resultType.isNullable() && this.resultType.equals(type.nullable());
    }

    @Override
    @Nonnull
    public Value with(@Nonnull Type type) {
        if (this.getResultType().equals(type)) {
            return this;
        }
        Verify.verify(this.canResultInType(type));
        return ConstantObjectValue.of(this.alias, this.constantId, type);
    }

    @Nonnull
    public String getConstantId() {
        return this.constantId;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object obj = context.dereferenceConstant(this.alias, this.constantId);
        if (obj == null) {
            Verify.verify(this.getResultType().isNullable());
            return null;
        }
        if (this.getResultType().isRelation()) {
            return obj;
        }
        Type objType = Type.fromObject(obj);
        boolean promotionNeeded = PromoteValue.isPromotionNeeded(objType, this.getResultType());
        if (!promotionNeeded) {
            return obj;
        }
        PromoteValue.PhysicalOperator promotionOperator = PromoteValue.resolvePhysicalOperator(objType, this.getResultType());
        SemanticException.check(promotionOperator != null, SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
        return promotionOperator.apply(null, obj);
    }

    @Override
    public int hashCodeWithoutChildren() {
        return this.planHash(PlanHashable.CURRENT_FOR_CONTINUATION);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode) {
            case VC0: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH);
            }
            case VC1: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.constantId);
            }
        }
        throw new RecordCoreException("unsupported plan hash mode", new Object[0]);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addIdentifier("@" + this.constantId));
    }

    @Override
    @Nonnull
    public PConstantObjectValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PConstantObjectValue.newBuilder().setAlias(this.alias.getId()).setConstantId(this.constantId).setResultType(this.resultType.toTypeProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setConstantObjectValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ConstantObjectValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConstantObjectValue constantObjectValueProto) {
        return new ConstantObjectValue(CorrelationIdentifier.of(Objects.requireNonNull(constantObjectValueProto.getAlias())), Objects.requireNonNull(constantObjectValueProto.getConstantId()), Type.fromTypeProto(serializationContext, Objects.requireNonNull(constantObjectValueProto.getResultType())));
    }

    @Nonnull
    public static ConstantObjectValue of(@Nonnull CorrelationIdentifier alias, @Nonnull String constantId, @Nonnull Type resultType) {
        return new ConstantObjectValue(alias, constantId, resultType);
    }

    public static class Deserializer
    implements PlanDeserializer<PConstantObjectValue, ConstantObjectValue> {
        @Override
        @Nonnull
        public Class<PConstantObjectValue> getProtoMessageClass() {
            return PConstantObjectValue.class;
        }

        @Override
        @Nonnull
        public ConstantObjectValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConstantObjectValue constantObjectValueProto) {
            return ConstantObjectValue.fromProto(serializationContext, constantObjectValueProto);
        }
    }
}

