/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PConstantValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ConstantValue
extends AbstractValue
implements LeafValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Constant-Value");
    @Nonnull
    private final Value value;

    public ConstantValue(@Nonnull Value value) {
        this.value = value;
    }

    @Nonnull
    public Value getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.getValue().getResultType();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return this.value.getCorrelatedTo();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return this.value.eval(store, context);
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        return false;
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return LeafValue.super.equalsWithoutChildren(other).filter(ignored -> this.value.equals(((ConstantValue)other).value));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return Objects.hash(this.value);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.value);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("const", Iterables.getOnlyElement(explainSuppliers).get().getExplainTokens()));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PConstantValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PConstantValue.newBuilder().setValue(this.value.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setConstantValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ConstantValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConstantValue constantValueProto) {
        return new ConstantValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(constantValueProto.getValue())));
    }

    public static class Deserializer
    implements PlanDeserializer<PConstantValue, ConstantValue> {
        @Override
        @Nonnull
        public Class<PConstantValue> getProtoMessageClass() {
            return PConstantValue.class;
        }

        @Override
        @Nonnull
        public ConstantValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConstantValue constantValueProto) {
            return ConstantValue.fromProto(serializationContext, constantValueProto);
        }
    }
}

