/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.planprotos.PCountValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Accumulator;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.IndexableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class CountValue
extends AbstractValue
implements AggregateValue,
StreamableAggregateValue,
IndexableAggregateValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Count-Value");
    @Nonnull
    protected final PhysicalOperator operator;
    @Nullable
    private final Value child;
    @Nonnull
    private final String indexTypeName;

    public CountValue(@Nonnull Value child) {
        this(CountValue.isCountStar(child), child);
    }

    public CountValue(boolean isCountStar, @Nonnull Value child) {
        this(isCountStar ? PhysicalOperator.COUNT_STAR : PhysicalOperator.COUNT, child);
    }

    public CountValue(@Nonnull PhysicalOperator operator, @Nullable Value child) {
        this(operator, child, operator == PhysicalOperator.COUNT ? "count_not_null" : "count");
    }

    public CountValue(@Nonnull PhysicalOperator operator, @Nullable Value child, @Nonnull String indexTypeName) {
        this.operator = operator;
        this.child = child;
        this.indexTypeName = indexTypeName;
    }

    private static boolean isCountStar(@Nonnull Typed valueType) {
        return !valueType.getResultType().isPrimitive();
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        throw new IllegalStateException("unable to eval an aggregation function with eval()");
    }

    @Override
    @Nullable
    public <M extends Message> Object evalToPartial(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        if (this.child != null) {
            return this.operator.evalInitialToPartial(this.child.eval(store, context));
        }
        return this.operator.evalInitialToPartial(null);
    }

    @Override
    @Nonnull
    public Accumulator createAccumulatorWithInitialState(@Nonnull TypeRepository typeRepository, @Nullable List<RecordCursorProto.AccumulatorState> initialState) {
        if (initialState == null) {
            return new SumAccumulator(this.operator);
        }
        Verify.verify(initialState.size() == 1);
        return new SumAccumulator(this.operator, initialState.get(0));
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        if (this.operator == PhysicalOperator.COUNT_STAR) {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall(PhysicalOperator.COUNT_STAR.name().toLowerCase(Locale.ROOT), new ExplainTokens().addIdentifier("*")));
        }
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall(this.operator.name().toLowerCase(Locale.ROOT), Iterables.getOnlyElement(explainSuppliers).get().getExplainTokens()));
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.primitiveType(this.operator.getResultTypeCode());
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        if (this.child != null) {
            return ImmutableList.of(this.child);
        }
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public CountValue withChildren(Iterable<? extends Value> newChildren) {
        Verify.verify(Iterables.size(newChildren) == 1);
        return new CountValue(this.operator, Iterables.get(newChildren, 0));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, new Object[]{BASE_HASH, this.operator});
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.operator, this.child});
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public String getIndexTypeName() {
        return this.indexTypeName;
    }

    @Override
    @Nonnull
    public PCountValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PCountValue.Builder builder = PCountValue.newBuilder().setOperator(this.operator.toProto(serializationContext));
        if (this.child != null) {
            builder.setChild(this.child.toValueProto(serializationContext));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setCountValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static CountValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PCountValue countValueProto) {
        Value child = countValueProto.hasChild() ? Value.fromValueProto(serializationContext, countValueProto.getChild()) : null;
        return new CountValue(PhysicalOperator.fromProto(serializationContext, Objects.requireNonNull(countValueProto.getOperator())), child);
    }

    public static enum PhysicalOperator {
        COUNT(Type.TypeCode.LONG, v -> v == null ? 0L : 1L, (s2, v) -> Math.addExact((Long)s2, (Long)v), UnaryOperator.identity()),
        COUNT_STAR(Type.TypeCode.LONG, v -> 1L, (s2, v) -> Math.addExact((Long)s2, (Long)v), UnaryOperator.identity());

        @Nonnull
        private final Type.TypeCode resultType;
        @Nonnull
        private final UnaryOperator<Object> initialToPartialFunction;
        @Nonnull
        private final BinaryOperator<Object> partialToPartialFunction;
        @Nonnull
        private final UnaryOperator<Object> partialToFinalFunction;

        private PhysicalOperator(@Nonnull Type.TypeCode resultType, @Nonnull UnaryOperator<Object> initialToPartialFunction, BinaryOperator<Object> partialToPartialFunction, UnaryOperator<Object> partialToFinalFunction) {
            this.resultType = resultType;
            this.initialToPartialFunction = initialToPartialFunction;
            this.partialToPartialFunction = partialToPartialFunction;
            this.partialToFinalFunction = partialToFinalFunction;
        }

        @Nonnull
        public Type.TypeCode getResultTypeCode() {
            return this.resultType;
        }

        @Nonnull
        public UnaryOperator<Object> getInitialToPartialFunction() {
            return this.initialToPartialFunction;
        }

        @Nonnull
        public BinaryOperator<Object> getPartialToPartialFunction() {
            return this.partialToPartialFunction;
        }

        @Nonnull
        public UnaryOperator<Object> getPartialToFinalFunction() {
            return this.partialToFinalFunction;
        }

        @Nullable
        public Object evalInitialToPartial(@Nullable Object object) {
            return this.initialToPartialFunction.apply(object);
        }

        @Nullable
        public Object evalPartialToPartial(@Nullable Object object1, @Nullable Object object2) {
            return this.partialToPartialFunction.apply(object1 == null ? Long.valueOf(0L) : object1, object2 == null ? Long.valueOf(0L) : object2);
        }

        @Nullable
        public Object evalPartialToFinal(@Nullable Object object) {
            if (object == null) {
                return 0L;
            }
            return this.partialToFinalFunction.apply(object);
        }

        @Nonnull
        public PCountValue.PPhysicalOperator toProto(@Nonnull PlanSerializationContext serializationContext) {
            switch (this) {
                case COUNT: {
                    return PCountValue.PPhysicalOperator.COUNT;
                }
                case COUNT_STAR: {
                    return PCountValue.PPhysicalOperator.COUNT_STAR;
                }
            }
            throw new RecordCoreException("unknown operator mapping. did you forget to add it?", new Object[0]);
        }

        @Nonnull
        public static PhysicalOperator fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PCountValue.PPhysicalOperator physicalOperatorProto) {
            switch (physicalOperatorProto) {
                case COUNT: {
                    return COUNT;
                }
                case COUNT_STAR: {
                    return COUNT_STAR;
                }
            }
            throw new RecordCoreException("unknown operator mapping. did you forget to add it?", new Object[0]);
        }
    }

    public static class SumAccumulator
    implements Accumulator {
        private final PhysicalOperator physicalOperator;
        Object state = null;

        public SumAccumulator(@Nonnull PhysicalOperator physicalOperator) {
            this.physicalOperator = physicalOperator;
        }

        public SumAccumulator(@Nonnull PhysicalOperator physicalOperator, @Nonnull RecordCursorProto.AccumulatorState initialState) {
            this.physicalOperator = physicalOperator;
            Verify.verify(initialState.getStateList().size() == 1);
            Verify.verify(initialState.getState(0).hasInt64State());
            this.state = initialState.getState(0).getInt64State();
        }

        @Override
        public void accumulate(@Nullable Object currentObject) {
            this.state = this.physicalOperator.evalPartialToPartial(this.state, currentObject);
        }

        @Override
        @Nullable
        public Object finish() {
            return this.physicalOperator.evalPartialToFinal(this.state);
        }

        @Override
        @Nonnull
        public List<RecordCursorProto.AccumulatorState> getAccumulatorStates() {
            if (this.state == null) {
                return List.of();
            }
            return List.of(RecordCursorProto.AccumulatorState.newBuilder().addState(RecordCursorProto.OneOfTypedState.newBuilder().setInt64State((Long)this.state)).build());
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PCountValue, CountValue> {
        @Override
        @Nonnull
        public Class<PCountValue> getProtoMessageClass() {
            return PCountValue.class;
        }

        @Override
        @Nonnull
        public CountValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PCountValue countValueProto) {
            return CountValue.fromProto(serializationContext, countValueProto);
        }
    }

    public static class CountFn
    extends BuiltInFunction<AggregateValue> {
        public CountFn() {
            super("COUNT", ImmutableList.of(new Type.Any()), CountFn::encapsulate);
        }

        @Nonnull
        private static AggregateValue encapsulate(@Nonnull BuiltInFunction<AggregateValue> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            Typed arg0 = arguments.get(0);
            return new CountValue((Value)arg0);
        }
    }
}

