/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PDerivedValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class DerivedValue
extends AbstractValue
implements Value.NonEvaluableValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Derived-Value");
    @Nonnull
    private final List<? extends Value> children;
    @Nonnull
    private final Type resultType;

    public DerivedValue(@Nonnull Iterable<? extends Value> values) {
        this(values, Type.primitiveType(Type.TypeCode.UNKNOWN));
    }

    public DerivedValue(@Nonnull Iterable<? extends Value> values, @Nonnull Type resultType) {
        this.children = ImmutableList.copyOf(values);
        this.resultType = resultType;
        Preconditions.checkArgument(!this.children.isEmpty());
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return this.children;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nonnull
    public DerivedValue withChildren(Iterable<? extends Value> newChildren) {
        return new DerivedValue(newChildren);
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.children);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("derived", Value.explainFunctionArguments(explainSuppliers)));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PDerivedValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PDerivedValue.Builder builder = PDerivedValue.newBuilder();
        for (Value value : this.children) {
            builder.addChildren(value.toValueProto(serializationContext));
        }
        builder.setResultType(this.resultType.toTypeProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setDerivedValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static DerivedValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PDerivedValue derivedValueProto) {
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        for (int i = 0; i < derivedValueProto.getChildrenCount(); ++i) {
            childrenBuilder.add(Value.fromValueProto(serializationContext, derivedValueProto.getChildren(i)));
        }
        return new DerivedValue(childrenBuilder.build(), Type.fromTypeProto(serializationContext, Objects.requireNonNull(derivedValueProto.getResultType())));
    }

    public static class Deserializer
    implements PlanDeserializer<PDerivedValue, DerivedValue> {
        @Override
        @Nonnull
        public Class<PDerivedValue> getProtoMessageClass() {
            return PDerivedValue.class;
        }

        @Override
        @Nonnull
        public DerivedValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PDerivedValue derivedValueProto) {
            return DerivedValue.fromProto(serializationContext, derivedValueProto);
        }
    }
}

