/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.planprotos.PEmptyValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class EmptyValue
extends AbstractValue
implements LeafValue {
    private static final EmptyValue EMPTY = new EmptyValue();
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Empty-Value");

    private EmptyValue() {
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return Key.Evaluated.EMPTY;
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        return true;
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSupliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("empty"));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Nonnull
    public static EmptyValue empty() {
        return EMPTY;
    }

    @Override
    @Nonnull
    public PEmptyValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PEmptyValue.newBuilder().build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setEmptyValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static EmptyValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PEmptyValue emptyValueProto) {
        return new EmptyValue();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    public static class Deserializer
    implements PlanDeserializer<PEmptyValue, EmptyValue> {
        @Override
        @Nonnull
        public Class<PEmptyValue> getProtoMessageClass() {
            return PEmptyValue.class;
        }

        @Override
        @Nonnull
        public EmptyValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PEmptyValue emptyValueProto) {
            return EmptyValue.fromProto(serializationContext, emptyValueProto);
        }
    }
}

