/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PEvaluatesToValue;
import com.apple.foundationdb.record.planprotos.PEvaluation;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EvaluatesToValue
extends AbstractValue
implements Value.RangeMatchableValue,
ValueWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Evaluates-To-Value");
    @Nonnull
    private final Value child;
    @Nonnull
    private final Evaluation evaluation;

    private EvaluatesToValue(@Nonnull Value child, @Nonnull Evaluation evaluation) {
        this.child = child;
        this.evaluation = evaluation;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.evaluation, this.child});
    }

    @Override
    @Nonnull
    public Value getChild() {
        return this.child;
    }

    @Nonnull
    public Evaluation getEvaluation() {
        return this.evaluation;
    }

    @Override
    @Nonnull
    public ValueWithChild withNewChild(@Nonnull Value rebasedChild) {
        return EvaluatesToValue.of(rebasedChild, this.evaluation);
    }

    @Override
    @Nullable
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object value = this.child.eval(store, context);
        switch (this.evaluation) {
            case IS_TRUE: {
                return value instanceof Boolean && (Boolean)value != false;
            }
            case IS_FALSE: {
                return value instanceof Boolean && (Boolean)value == false;
            }
            case IS_NULL: {
                return value == null;
            }
            case IS_NOT_NULL: {
                return value != null;
            }
        }
        throw new RecordCoreException("unexpected evaluation " + String.valueOf((Object)this.evaluation), new Object[0]);
    }

    @Override
    @Nullable
    public Boolean evalWithoutStore(@Nonnull EvaluationContext context) {
        return this.eval((FDBRecordStoreBase)null, context);
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> this.evaluation.equals((Object)((EvaluatesToValue)other).getEvaluation()));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, new Object[]{BASE_HASH, this.evaluation});
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokens child = Iterables.getOnlyElement(explainSuppliers).get().getExplainTokens();
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.ALWAYS_PARENS, child.addWhitespace().addIdentifier("EVALUATES").addWhitespace().addKeyword("TO").addWhitespace().addIdentifier(this.evaluation.toString()));
    }

    @Override
    @Nonnull
    public PEvaluatesToValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PEvaluation evaluationProto;
        switch (this.evaluation) {
            case IS_TRUE: {
                evaluationProto = PEvaluation.IS_TRUE;
                break;
            }
            case IS_FALSE: {
                evaluationProto = PEvaluation.IS_FALSE;
                break;
            }
            case IS_NULL: {
                evaluationProto = PEvaluation.IS_NULL;
                break;
            }
            case IS_NOT_NULL: {
                evaluationProto = PEvaluation.IS_NOT_NULL;
                break;
            }
            default: {
                throw new RecordCoreException("unexpected evaluation " + String.valueOf((Object)this.evaluation), new Object[0]);
            }
        }
        return PEvaluatesToValue.newBuilder().setChild(this.child.toValueProto(serializationContext)).setEvaluation(evaluationProto).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setEvaluatesToValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static EvaluatesToValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PEvaluatesToValue ofTypeValueProto) {
        Evaluation evaluation;
        PEvaluation evaluationProto = ofTypeValueProto.getEvaluation();
        switch (evaluationProto) {
            case IS_TRUE: {
                evaluation = Evaluation.IS_TRUE;
                break;
            }
            case IS_FALSE: {
                evaluation = Evaluation.IS_FALSE;
                break;
            }
            case IS_NULL: {
                evaluation = Evaluation.IS_NULL;
                break;
            }
            case IS_NOT_NULL: {
                evaluation = Evaluation.IS_NOT_NULL;
                break;
            }
            default: {
                throw new RecordCoreException("unexpected evaluation " + String.valueOf(evaluationProto), new Object[0]);
            }
        }
        return EvaluatesToValue.of(Value.fromValueProto(serializationContext, Objects.requireNonNull(ofTypeValueProto.getChild())), evaluation);
    }

    @Nonnull
    private static EvaluatesToValue of(@Nonnull Value value, @Nonnull Evaluation evaluation) {
        return new EvaluatesToValue(value, evaluation);
    }

    @Nonnull
    public static EvaluatesToValue isTrue(@Nonnull Value value) {
        return EvaluatesToValue.of(value, Evaluation.IS_TRUE);
    }

    @Nonnull
    public static EvaluatesToValue isFalse(@Nonnull Value value) {
        return EvaluatesToValue.of(value, Evaluation.IS_FALSE);
    }

    @Nonnull
    public static EvaluatesToValue isNull(@Nonnull Value value) {
        return EvaluatesToValue.of(value, Evaluation.IS_NULL);
    }

    @Nonnull
    public static EvaluatesToValue isNotNull(@Nonnull Value value) {
        return EvaluatesToValue.of(value, Evaluation.IS_NOT_NULL);
    }

    @Nonnull
    public static EvaluatesToValue of(@Nonnull ConstantObjectValue constantObjectValue, @Nonnull EvaluationContext evaluationContext) {
        Object plainValue = constantObjectValue.evalWithoutStore(evaluationContext);
        if (plainValue == null) {
            return EvaluatesToValue.isNull(constantObjectValue);
        }
        if (plainValue instanceof Boolean) {
            Boolean booleanPlainValue = (Boolean)plainValue;
            return booleanPlainValue != false ? EvaluatesToValue.isTrue(constantObjectValue) : EvaluatesToValue.isFalse(constantObjectValue);
        }
        return EvaluatesToValue.isNotNull(constantObjectValue);
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.getChild());
    }

    public static enum Evaluation {
        IS_TRUE,
        IS_FALSE,
        IS_NULL,
        IS_NOT_NULL;

    }

    public static class Deserializer
    implements PlanDeserializer<PEvaluatesToValue, EvaluatesToValue> {
        @Override
        @Nonnull
        public Class<PEvaluatesToValue> getProtoMessageClass() {
            return PEvaluatesToValue.class;
        }

        @Override
        @Nonnull
        public EvaluatesToValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PEvaluatesToValue ofTypeValueProto) {
            return EvaluatesToValue.fromProto(serializationContext, ofTypeValueProto);
        }
    }
}

