/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PExistsValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ExistsPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.BooleanValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ExistsValue
extends AbstractValue
implements BooleanValue,
QuantifiedValue,
Value.NonEvaluableValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Exists-Value");
    @Nonnull
    private final CorrelationIdentifier alias;

    public ExistsValue(@Nonnull CorrelationIdentifier alias) {
        this.alias = alias;
    }

    @Override
    @SpotBugsSuppressWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public Optional<QueryPredicate> toQueryPredicate(@Nullable TypeRepository typeRepository, @Nonnull Set<CorrelationIdentifier> localAliases) {
        return Optional.of(new ExistsPredicate(this.alias));
    }

    @Override
    @Nonnull
    public CorrelationIdentifier getAlias() {
        return this.alias;
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.alias);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("exists", new ExplainTokens().addAliasReference(this.getAlias())));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PExistsValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PExistsValue.newBuilder().setAlias(this.alias.getId()).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setExistsValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ExistsValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PExistsValue existsValueProto) {
        if (existsValueProto.hasAlias()) {
            return new ExistsValue(CorrelationIdentifier.of(Objects.requireNonNull(existsValueProto.getAlias())));
        }
        return new ExistsValue(QuantifiedObjectValue.fromProto(serializationContext, Objects.requireNonNull(existsValueProto.getChild())).getAlias());
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    public static class Deserializer
    implements PlanDeserializer<PExistsValue, ExistsValue> {
        @Override
        @Nonnull
        public Class<PExistsValue> getProtoMessageClass() {
            return PExistsValue.class;
        }

        @Override
        @Nonnull
        public ExistsValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PExistsValue existsValueProto) {
            return ExistsValue.fromProto(serializationContext, existsValueProto);
        }
    }

    public static class ExistsFn
    extends BuiltInFunction<Value> {
        public ExistsFn() {
            super("exists", ImmutableList.of(new Type.Relation()), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> ExistsFn.encapsulateInternal(arguments));
        }

        private static Value encapsulateInternal(@Nonnull List<? extends Typed> arguments) {
            Verify.verify(arguments.size() == 1);
            Typed in = arguments.get(0);
            Verify.verify(in instanceof RelationalExpression);
            Quantifier.Existential existsQuantifier = Quantifier.existential(Reference.initialOf((RelationalExpression)in));
            return new ExistsValue(existsQuantifier.getAlias());
        }
    }
}

