/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PFieldPath;
import com.apple.foundationdb.record.planprotos.PFieldValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.NullableArrayTypeUtils;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.MessageHelpers;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.ImmutableIntArray;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class FieldValue
extends AbstractValue
implements ValueWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Field-Value");
    @Nonnull
    private final Value childValue;
    @Nonnull
    private final FieldPath fieldPath;
    @Nonnull
    private final Supplier<List<String>> fieldNamesSupplier;
    @Nonnull
    private final Supplier<Type> resultTypeSupplier;

    private FieldValue(@Nonnull Value childValue, @Nonnull FieldPath fieldPath) {
        this.childValue = childValue;
        this.fieldPath = fieldPath;
        this.fieldNamesSupplier = Suppliers.memoize(() -> fieldPath.getOptionalFieldNames().stream().map(maybe -> (String)maybe.orElseThrow(() -> new RecordCoreException("field name should have been set", new Object[0]))).collect(Collectors.toList()));
        this.resultTypeSupplier = Suppliers.memoize(this::computeResultType);
    }

    @Nonnull
    public FieldPath getFieldPath() {
        return this.fieldPath;
    }

    @Nonnull
    public List<String> getFieldPathNames() {
        return this.fieldNamesSupplier.get();
    }

    @Nonnull
    public List<Type> getFieldPathTypes() {
        return this.fieldPath.getFieldTypes();
    }

    @Nonnull
    public ImmutableIntArray getFieldOrdinals() {
        return this.fieldPath.getFieldOrdinals();
    }

    @Nonnull
    public List<Optional<String>> getFieldPathNamesMaybe() {
        return this.fieldPath.getOptionalFieldNames();
    }

    @Nonnull
    public FieldPath getFieldPrefix() {
        return this.fieldPath.getFieldPrefix();
    }

    @Nonnull
    public Optional<String> getLastFieldName() {
        return this.fieldPath.getLastFieldName();
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultTypeSupplier.get();
    }

    @Nonnull
    private Type computeResultType() {
        Type lastFieldType = this.fieldPath.getLastFieldType();
        boolean anyNullable = this.childValue.getResultType().isNullable() || this.fieldPath.areAnyFieldTypesNullable();
        return lastFieldType.overrideIfNullable(anyNullable);
    }

    @Override
    @Nonnull
    public Value getChild() {
        return this.childValue;
    }

    @Override
    @Nonnull
    public FieldValue withNewChild(@Nonnull Value child) {
        return FieldValue.ofFieldsAndFuseIfPossible(child, this.fieldPath);
    }

    @Override
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object childResult = this.childValue.eval(store, context);
        if (!(childResult instanceof Message)) {
            return null;
        }
        Object fieldValue = MessageHelpers.getFieldValueForFieldOrdinals((Message)childResult, this.fieldPath.getFieldOrdinals());
        return FieldValue.unwrapPrimitive(this.getResultType(), NullableArrayTypeUtils.unwrapIfArray(fieldValue, this.getResultType()));
    }

    @Nullable
    private static Object unwrapPrimitive(@Nonnull Type type, @Nullable Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        if (type instanceof Type.Array) {
            Verify.verify(fieldValue instanceof List);
            List list = (List)fieldValue;
            Type elementType = Objects.requireNonNull(((Type.Array)type).getElementType());
            ArrayList<Object> returnList = new ArrayList<Object>(list.size());
            for (Object elem : list) {
                returnList.add(FieldValue.unwrapPrimitive(elementType, elem));
            }
            return returnList;
        }
        if (type.getTypeCode() == Type.TypeCode.VERSION) {
            return FDBRecordVersion.fromBytes(((ByteString)fieldValue).toByteArray(), false);
        }
        if (type.isUuid()) {
            Verify.verify(fieldValue instanceof UUID);
            return fieldValue;
        }
        return fieldValue;
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return ValueWithChild.super.equalsWithoutChildren(other).filter(ignored -> this.fieldPath.equals(((FieldValue)other).getFieldPath()));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH, this.fieldPath);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.fieldPath);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Supplier<ExplainTokensWithPrecedence> explainSupplier = Iterables.getOnlyElement(explainSuppliers);
        ExplainTokens childExplain = ExplainTokensWithPrecedence.Precedence.DOT.parenthesizeChild(explainSupplier.get(), true);
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.DOT, new ExplainTokens().addNested(childExplain).addToString(this.fieldPath));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PFieldValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PFieldValue.newBuilder().setChildValue(this.childValue.toValueProto(serializationContext)).setFieldPath(this.fieldPath.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setFieldValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static FieldValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PFieldValue fieldValueProto) {
        return new FieldValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(fieldValueProto.getChildValue())), FieldPath.fromProto(serializationContext, Objects.requireNonNull(fieldValueProto.getFieldPath())));
    }

    @Nonnull
    @VisibleForTesting
    public static FieldPath resolveFieldPath(@Nonnull Type inputType, @Nonnull List<Accessor> accessors) {
        ImmutableList.Builder accessorPathBuilder = ImmutableList.builder();
        Type currentType = inputType;
        for (Accessor accessor : accessors) {
            int ordinal;
            Type.Record.Field field;
            String fieldName = accessor.getName();
            SemanticException.check(currentType.isRecord(), SemanticException.ErrorCode.FIELD_ACCESS_INPUT_NON_RECORD_TYPE, "field '" + (String)(fieldName == null ? "#" + accessor.getOrdinal() : fieldName) + "' can only be resolved on records");
            Type.Record recordType = (Type.Record)currentType;
            Map<String, Type.Record.Field> fieldNameFieldMap = Objects.requireNonNull(recordType.getFieldNameFieldMap());
            if (fieldName != null) {
                SemanticException.check(fieldNameFieldMap.containsKey(fieldName), SemanticException.ErrorCode.RECORD_DOES_NOT_CONTAIN_FIELD);
                field = fieldNameFieldMap.get(fieldName);
                Map<String, Integer> fieldOrdinalsMap = Objects.requireNonNull(recordType.getFieldNameToOrdinalMap());
                SemanticException.check(fieldOrdinalsMap.containsKey(fieldName), SemanticException.ErrorCode.RECORD_DOES_NOT_CONTAIN_FIELD);
                ordinal = fieldOrdinalsMap.get(fieldName);
            } else {
                Verify.verify(accessor.getOrdinal() >= 0);
                field = recordType.getFields().get(accessor.getOrdinal());
                ordinal = accessor.getOrdinal();
            }
            currentType = field.getFieldType();
            accessorPathBuilder.add(ResolvedAccessor.of(field.getFieldNameOptional().orElse(null), ordinal, currentType));
        }
        return new FieldPath((List<ResolvedAccessor>)((Object)accessorPathBuilder.build()));
    }

    @Nonnull
    public static FieldValue ofFieldName(@Nonnull Value childValue, @Nonnull String fieldName) {
        FieldPath resolved = FieldValue.resolveFieldPath(childValue.getResultType(), ImmutableList.of(new Accessor(fieldName, -1)));
        return new FieldValue(childValue, resolved);
    }

    @Nonnull
    public static FieldValue ofFieldNameAndFuseIfPossible(@Nonnull Value childValue, @Nonnull String fieldName) {
        FieldPath resolved = FieldValue.resolveFieldPath(childValue.getResultType(), ImmutableList.of(new Accessor(fieldName, -1)));
        return FieldValue.ofFieldsAndFuseIfPossible(childValue, resolved);
    }

    @Nonnull
    public static FieldValue ofFieldNames(@Nonnull Value childValue, @Nonnull List<String> fieldNames) {
        FieldPath resolved = FieldValue.resolveFieldPath(childValue.getResultType(), fieldNames.stream().map(fieldName -> new Accessor((String)fieldName, -1)).collect(ImmutableList.toImmutableList()));
        return new FieldValue(childValue, resolved);
    }

    @Nonnull
    public static FieldValue ofFields(@Nonnull Value childValue, @Nonnull FieldPath fieldPath) {
        return new FieldValue(childValue, fieldPath);
    }

    @Nonnull
    public static FieldValue ofFieldsAndFuseIfPossible(@Nonnull Value childValue, @Nonnull FieldPath fields) {
        if (childValue instanceof FieldValue) {
            FieldValue childFieldValue = (FieldValue)childValue;
            return FieldValue.ofFields(childFieldValue.getChild(), childFieldValue.fieldPath.withSuffix(fields));
        }
        return FieldValue.ofFields(childValue, fields);
    }

    @Nonnull
    public static FieldValue ofOrdinalNumber(@Nonnull Value childValue, int ordinalNumber) {
        FieldPath resolved = FieldValue.resolveFieldPath(childValue.getResultType(), ImmutableList.of(new Accessor(null, ordinalNumber)));
        return new FieldValue(childValue, resolved);
    }

    @Nonnull
    public static FieldValue ofOrdinalNumberAndFuseIfPossible(@Nonnull Value childValue, int ordinalNumber) {
        FieldPath resolved = FieldValue.resolveFieldPath(childValue.getResultType(), ImmutableList.of(new Accessor(null, ordinalNumber)));
        return FieldValue.ofFieldsAndFuseIfPossible(childValue, resolved);
    }

    @Nonnull
    public static Optional<FieldPath> stripFieldPrefixMaybe(@Nonnull FieldPath fieldPath, @Nonnull FieldPath potentialPrefixPath) {
        if (fieldPath.size() < potentialPrefixPath.size()) {
            return Optional.empty();
        }
        ImmutableIntArray fieldPathOrdinals = fieldPath.getFieldOrdinals();
        ImmutableIntArray potentialPrefixFieldOrdinals = potentialPrefixPath.getFieldOrdinals();
        for (int i = 0; i < potentialPrefixPath.size(); ++i) {
            if (fieldPathOrdinals.get(i) == potentialPrefixFieldOrdinals.get(i)) continue;
            return Optional.empty();
        }
        return Optional.of(fieldPath.subList(potentialPrefixPath.size(), fieldPath.size()));
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.getChild());
    }

    public static class FieldPath
    implements PlanSerializable {
        private static final FieldPath EMPTY = new FieldPath(ImmutableList.of());
        private static final Comparator<FieldPath> COMPARATOR = Comparator.comparing(f -> f.getFieldOrdinals().asList(), Comparators.lexicographical(Comparator.naturalOrder()));
        @Nonnull
        private final List<ResolvedAccessor> fieldAccessors;
        @Nonnull
        private final Supplier<List<Optional<String>>> fieldNamesSupplier;
        @Nonnull
        private final Supplier<ImmutableIntArray> fieldOrdinalsSupplier;
        @Nonnull
        private final Supplier<List<Type>> fieldTypesSupplier;

        public FieldPath(@Nonnull List<ResolvedAccessor> fieldAccessors) {
            this.fieldAccessors = ImmutableList.copyOf(fieldAccessors);
            this.fieldNamesSupplier = Suppliers.memoize(() -> FieldPath.computeFieldNames(fieldAccessors));
            this.fieldOrdinalsSupplier = Suppliers.memoize(() -> FieldPath.computeOrdinals(fieldAccessors));
            this.fieldTypesSupplier = Suppliers.memoize(() -> FieldPath.computeFieldTypes(fieldAccessors));
        }

        @Nonnull
        public List<ResolvedAccessor> getFieldAccessors() {
            return this.fieldAccessors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldPath)) {
                return false;
            }
            FieldPath otherFieldPath = (FieldPath)o;
            return this.fieldAccessors.equals(otherFieldPath.fieldAccessors);
        }

        public int hashCode() {
            return Objects.hash(this.fieldAccessors);
        }

        @Nonnull
        public String toString() {
            return this.fieldAccessors.stream().map(fieldAccessor -> fieldAccessor.getName() == null ? "#" + fieldAccessor.getOrdinal() : "." + fieldAccessor.getName()).collect(Collectors.joining());
        }

        @Nonnull
        public List<Optional<String>> getOptionalFieldNames() {
            return this.fieldNamesSupplier.get();
        }

        @Nonnull
        public ImmutableIntArray getFieldOrdinals() {
            return this.fieldOrdinalsSupplier.get();
        }

        @Nonnull
        public List<Type> getFieldTypes() {
            return this.fieldTypesSupplier.get();
        }

        @Nonnull
        public FieldPath getFieldPrefix() {
            Preconditions.checkArgument(!this.isEmpty());
            return this.subList(0, this.size() - 1);
        }

        @Nonnull
        public ResolvedAccessor getLastFieldAccessor() {
            Preconditions.checkArgument(!this.isEmpty());
            return this.getFieldAccessors().get(this.size() - 1);
        }

        @Nonnull
        public Optional<String> getLastFieldName() {
            Preconditions.checkArgument(!this.isEmpty());
            return this.getOptionalFieldNames().get(this.size() - 1);
        }

        public int getLastFieldOrdinal() {
            Preconditions.checkArgument(!this.isEmpty());
            return this.getFieldOrdinals().get(this.size() - 1);
        }

        @Nonnull
        public Type getLastFieldType() {
            Preconditions.checkArgument(!this.isEmpty());
            return this.getFieldTypes().get(this.size() - 1);
        }

        public boolean areAnyFieldTypesNullable() {
            Preconditions.checkArgument(!this.isEmpty());
            return this.getFieldTypes().stream().anyMatch(Type::isNullable);
        }

        public int size() {
            return this.fieldAccessors.size();
        }

        public boolean isEmpty() {
            return this.fieldAccessors.isEmpty();
        }

        @Nonnull
        public FieldPath subList(int fromIndex, int toIndex) {
            return new FieldPath(this.fieldAccessors.subList(fromIndex, toIndex));
        }

        @Nonnull
        public FieldPath subList(int count) {
            Preconditions.checkArgument(count >= 0);
            Preconditions.checkArgument(count <= this.size());
            if (count == 0) {
                return this;
            }
            if (count == this.size()) {
                return FieldPath.empty();
            }
            return this.subList(count, this.size());
        }

        public boolean isPrefixOf(@Nonnull FieldPath otherFieldPath) {
            if (otherFieldPath.size() < this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.fieldAccessors.get(i).equals(otherFieldPath.fieldAccessors.get(i))) continue;
                return false;
            }
            return true;
        }

        @Nonnull
        public FieldPath withSuffix(@Nonnull FieldPath suffix) {
            if (suffix.isEmpty() && this.isEmpty()) {
                return FieldPath.empty();
            }
            if (suffix.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return suffix;
            }
            return new FieldPath((List<ResolvedAccessor>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.fieldAccessors)).addAll(suffix.fieldAccessors)).build()));
        }

        @Nonnull
        public static FieldPath empty() {
            return EMPTY;
        }

        @Nonnull
        private static List<Optional<String>> computeFieldNames(@Nonnull List<ResolvedAccessor> fieldAccessors) {
            return fieldAccessors.stream().map(accessor -> Optional.ofNullable(accessor.getName())).collect(ImmutableList.toImmutableList());
        }

        @Nonnull
        private static ImmutableIntArray computeOrdinals(@Nonnull List<ResolvedAccessor> fieldAccessors) {
            ImmutableIntArray.Builder resultBuilder = ImmutableIntArray.builder();
            fieldAccessors.forEach(accessor -> resultBuilder.add(accessor.getOrdinal()));
            return resultBuilder.build();
        }

        @Nonnull
        private static List<Type> computeFieldTypes(@Nonnull List<ResolvedAccessor> fieldAccessors) {
            return fieldAccessors.stream().map(ResolvedAccessor::getType).collect(ImmutableList.toImmutableList());
        }

        @Nonnull
        public static FieldPath ofSingle(@Nullable String fieldName, @Nonnull Type fieldType, @Nonnull Integer fieldOrdinal) {
            return new FieldPath(ImmutableList.of(ResolvedAccessor.of(fieldName, fieldOrdinal, fieldType)));
        }

        @Nonnull
        public static FieldPath ofSingle(@Nonnull ResolvedAccessor accessor) {
            return new FieldPath(ImmutableList.of(accessor));
        }

        @Nonnull
        public static Comparator<FieldPath> comparator() {
            return COMPARATOR;
        }

        @Override
        @Nonnull
        public PFieldPath toProto(@Nonnull PlanSerializationContext serializationContext) {
            PFieldPath.Builder builder = PFieldPath.newBuilder();
            for (ResolvedAccessor fieldAccessor : this.fieldAccessors) {
                builder.addFieldAccessors(fieldAccessor.toProto(serializationContext));
            }
            return builder.build();
        }

        @Nonnull
        public static FieldPath fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PFieldPath fieldPathProto) {
            ImmutableList.Builder resolvedAccessorsBuilder = ImmutableList.builder();
            for (int i = 0; i < fieldPathProto.getFieldAccessorsCount(); ++i) {
                PFieldPath.PResolvedAccessor resolvedAccessorProto = fieldPathProto.getFieldAccessors(i);
                resolvedAccessorsBuilder.add(ResolvedAccessor.fromProto(serializationContext, resolvedAccessorProto));
            }
            ImmutableCollection resolvedAccessors = resolvedAccessorsBuilder.build();
            Verify.verify(!resolvedAccessors.isEmpty());
            return new FieldPath((List<ResolvedAccessor>)((Object)resolvedAccessors));
        }
    }

    public static class Accessor {
        @Nullable
        final String name;
        final int ordinal;

        public Accessor(@Nullable String name, int ordinal) {
            this.name = name;
            this.ordinal = ordinal;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Accessor)) {
                return false;
            }
            Accessor accessor = (Accessor)o;
            return this.ordinal == accessor.ordinal && Objects.equals(this.name, accessor.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.ordinal);
        }
    }

    public static class ResolvedAccessor
    implements PlanSerializable {
        @Nullable
        final String name;
        final int ordinal;
        @Nullable
        private final Type type;

        protected ResolvedAccessor(@Nullable String name, int ordinal, @Nullable Type type) {
            Preconditions.checkArgument(ordinal >= 0);
            this.name = name;
            this.ordinal = ordinal;
            this.type = type;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        @Nonnull
        public Type getType() {
            return Objects.requireNonNull(this.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResolvedAccessor)) {
                return false;
            }
            ResolvedAccessor that = (ResolvedAccessor)o;
            return this.getOrdinal() == that.getOrdinal();
        }

        public int hashCode() {
            return Objects.hash(this.getOrdinal());
        }

        @Nonnull
        public String toString() {
            return this.name + ";" + this.ordinal + ";" + String.valueOf(this.type);
        }

        @Override
        @Nonnull
        public PFieldPath.PResolvedAccessor toProto(@Nonnull PlanSerializationContext serializationContext) {
            PFieldPath.PResolvedAccessor.Builder builder = PFieldPath.PResolvedAccessor.newBuilder();
            builder.setName(this.name);
            builder.setOrdinal(this.ordinal);
            if (this.type != null) {
                builder.setType(this.type.toTypeProto(serializationContext));
            }
            return builder.build();
        }

        @Nonnull
        public static ResolvedAccessor fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PFieldPath.PResolvedAccessor resolvedAccessorProto) {
            Type type = resolvedAccessorProto.hasType() ? Type.fromTypeProto(serializationContext, resolvedAccessorProto.getType()) : null;
            return new ResolvedAccessor(resolvedAccessorProto.getName(), resolvedAccessorProto.getOrdinal(), type);
        }

        @Nonnull
        public static ResolvedAccessor of(@Nonnull Type.Record.Field field, int ordinal) {
            return ResolvedAccessor.of(field.getFieldNameOptional().orElse(null), ordinal, field.getFieldType());
        }

        @Nonnull
        public static ResolvedAccessor of(@Nullable String fieldName, int ordinalFieldNumber, @Nonnull Type type) {
            return new ResolvedAccessor(fieldName, ordinalFieldNumber, type);
        }

        @Nonnull
        public static ResolvedAccessor of(@Nullable String fieldName, int ordinalFieldNumber) {
            return new ResolvedAccessor(fieldName, ordinalFieldNumber, null);
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PFieldValue, FieldValue> {
        @Override
        @Nonnull
        public Class<PFieldValue> getProtoMessageClass() {
            return PFieldValue.class;
        }

        @Override
        @Nonnull
        public FieldValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PFieldValue fieldValueProto) {
            return FieldValue.fromProto(serializationContext, fieldValueProto);
        }
    }
}

