/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PFirstOrDefaultValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class FirstOrDefaultValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("First-Or-Default-Value");
    @Nonnull
    private final Value childValue;
    @Nonnull
    private final Value onEmptyResultValue;
    @Nonnull
    private final Supplier<List<Value>> childrenSupplier;
    @Nonnull
    private final Type resultType;

    public FirstOrDefaultValue(@Nonnull Value childValue, @Nonnull Value onEmptyResultValue) {
        this.childValue = childValue;
        this.onEmptyResultValue = onEmptyResultValue;
        this.childrenSupplier = () -> ImmutableList.of(childValue, onEmptyResultValue);
        Type childResultType = childValue.getResultType();
        Verify.verify(childResultType.isArray());
        Type elementType = Objects.requireNonNull(((Type.Array)childResultType).getElementType());
        Verify.verify(elementType.equals(onEmptyResultValue.getResultType()));
        this.resultType = Objects.requireNonNull(elementType);
    }

    @Nonnull
    public List<? extends Value> computeChildren() {
        return this.childrenSupplier.get();
    }

    @Override
    @Nonnull
    public Value withChildren(Iterable<? extends Value> newChildren) {
        ImmutableList<? extends Value> newChildrenList = ImmutableList.copyOf(newChildren);
        Verify.verify(newChildrenList.size() == 2);
        return new FirstOrDefaultValue((Value)newChildrenList.get(0), (Value)newChildrenList.get(1));
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Nonnull
    public Value getOnEmptyResultValue() {
        return this.onEmptyResultValue;
    }

    @Override
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object childResult = this.childValue.eval(store, context);
        if (childResult == null) {
            return null;
        }
        List childrenObjects = (List)childResult;
        if (childrenObjects.isEmpty()) {
            return this.onEmptyResultValue.eval(store, context);
        }
        return childrenObjects.get(0);
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.childValue, this.onEmptyResultValue);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("firstOrDefault", Value.explainFunctionArguments(explainSuppliers)));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PFirstOrDefaultValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PFirstOrDefaultValue.newBuilder().setChildValue(this.childValue.toValueProto(serializationContext)).setOnEmptyResultValue(this.onEmptyResultValue.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setFirstOrDefaultValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static FirstOrDefaultValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PFirstOrDefaultValue firstOrDefaultValueProto) {
        return new FirstOrDefaultValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(firstOrDefaultValueProto.getChildValue())), Value.fromValueProto(serializationContext, Objects.requireNonNull(firstOrDefaultValueProto.getOnEmptyResultValue())));
    }

    public static class Deserializer
    implements PlanDeserializer<PFirstOrDefaultValue, FirstOrDefaultValue> {
        @Override
        @Nonnull
        public Class<PFirstOrDefaultValue> getProtoMessageClass() {
            return PFirstOrDefaultValue.class;
        }

        @Override
        @Nonnull
        public FirstOrDefaultValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PFirstOrDefaultValue firstOrDefaultValueProto) {
            return FirstOrDefaultValue.fromProto(serializationContext, firstOrDefaultValueProto);
        }
    }
}

