/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PFromOrderedBytesValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.OrderedBytesHelpers;
import com.apple.foundationdb.record.query.plan.cascades.values.ToOrderedBytesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.tuple.TupleOrdering;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class FromOrderedBytesValue
extends AbstractValue
implements ValueWithChild,
Value.InvertableValue<ToOrderedBytesValue>,
Ordering.OrderPreservingValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("From-Ordered-Bytes-Value");
    @Nonnull
    private final Value child;
    @Nonnull
    private final TupleOrdering.Direction direction;
    @Nonnull
    private final Type resultType;

    public FromOrderedBytesValue(@Nonnull Value child, @Nonnull TupleOrdering.Direction direction, @Nonnull Type resultType) {
        this.child = child;
        this.direction = direction;
        this.resultType = resultType;
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.getChild());
    }

    @Override
    @Nonnull
    public Value getChild() {
        return this.child;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Nonnull
    public TupleOrdering.Direction getDirection() {
        return this.direction;
    }

    @Override
    @Nonnull
    public ValueWithChild withNewChild(@Nonnull Value rebasedChild) {
        return new FromOrderedBytesValue(rebasedChild, this.direction, this.resultType);
    }

    @Override
    public Optional<ToOrderedBytesValue> createInverseValueMaybe(@Nonnull Value newChildValue) {
        return Optional.of(new ToOrderedBytesValue(newChildValue, this.getDirection()));
    }

    @Override
    @Nonnull
    public Ordering.OrderPreservingKind getOrderPreservingKind() {
        switch (this.getDirection()) {
            case ASC_NULLS_FIRST: 
            case ASC_NULLS_LAST: {
                return Ordering.OrderPreservingKind.DIRECT_ORDER_PRESERVING;
            }
            case DESC_NULLS_FIRST: 
            case DESC_NULLS_LAST: {
                return Ordering.OrderPreservingKind.INVERSE_ORDER_PRESERVING;
            }
        }
        throw new RecordCoreException("unexpected enum", new Object[0]);
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        ByteString childResult = (ByteString)Objects.requireNonNull(this.child.eval(store, context));
        Object result = TupleOrdering.unpack(childResult.toByteArray(), this.direction).get(0);
        Debugger.sanityCheck(() -> this.resultType.validateObject(result));
        return result;
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, new Object[]{BASE_HASH, this.direction, this.resultType});
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.child, this.direction});
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("from_ordered_bytes", Value.explainFunctionArguments(explainSuppliers).addCommaAndWhiteSpace().addToString((Object)this.getDirection())));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> this.direction == ((FromOrderedBytesValue)other).getDirection()).filter(ignored -> this.resultType.equals(other.getResultType()));
    }

    @Override
    @Nonnull
    public PFromOrderedBytesValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PFromOrderedBytesValue.newBuilder().setChild(this.child.toValueProto(serializationContext)).setDirection(OrderedBytesHelpers.toDirectionProto(this.direction)).setResultType(this.resultType.toTypeProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setFromOrderedBytesValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static FromOrderedBytesValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PFromOrderedBytesValue fromOrderedBytesValueProto) {
        return new FromOrderedBytesValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(fromOrderedBytesValueProto.getChild())), OrderedBytesHelpers.fromDirectionProto(Objects.requireNonNull(fromOrderedBytesValueProto.getDirection())), Type.fromTypeProto(serializationContext, Objects.requireNonNull(fromOrderedBytesValueProto.getResultType())));
    }

    public static class Deserializer
    implements PlanDeserializer<PFromOrderedBytesValue, FromOrderedBytesValue> {
        @Override
        @Nonnull
        public Class<PFromOrderedBytesValue> getProtoMessageClass() {
            return PFromOrderedBytesValue.class;
        }

        @Override
        @Nonnull
        public FromOrderedBytesValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PFromOrderedBytesValue fromOrderedBytesValueProto) {
            return FromOrderedBytesValue.fromProto(serializationContext, fromOrderedBytesValueProto);
        }
    }

    public static class FromOrderedBytesDescNullsLastFn
    extends BuiltInFunction<Value> {
        public FromOrderedBytesDescNullsLastFn() {
            super("FROM_ORDERED_BYTES_" + String.valueOf((Object)TupleOrdering.Direction.DESC_NULLS_LAST), ImmutableList.of(Type.any()), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> new FromOrderedBytesValue((Value)arguments.get(0), TupleOrdering.Direction.DESC_NULLS_LAST, Type.any()));
        }
    }

    public static class FromOrderedBytesDescNullsFirstFn
    extends BuiltInFunction<Value> {
        public FromOrderedBytesDescNullsFirstFn() {
            super("FROM_ORDERED_BYTES_" + String.valueOf((Object)TupleOrdering.Direction.DESC_NULLS_FIRST), ImmutableList.of(Type.any()), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> new FromOrderedBytesValue((Value)arguments.get(0), TupleOrdering.Direction.DESC_NULLS_FIRST, Type.any()));
        }
    }

    public static class FromOrderedBytesAscNullsLastFn
    extends BuiltInFunction<Value> {
        public FromOrderedBytesAscNullsLastFn() {
            super("FROM_ORDERED_BYTES_" + String.valueOf((Object)TupleOrdering.Direction.ASC_NULLS_LAST), ImmutableList.of(Type.any()), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> new FromOrderedBytesValue((Value)arguments.get(0), TupleOrdering.Direction.ASC_NULLS_LAST, Type.any()));
        }
    }

    public static class FromOrderedBytesAscNullsFirstFn
    extends BuiltInFunction<Value> {
        public FromOrderedBytesAscNullsFirstFn() {
            super("FROM_ORDERED_BYTES_" + String.valueOf((Object)TupleOrdering.Direction.ASC_NULLS_FIRST), ImmutableList.of(Type.primitiveType(Type.TypeCode.BYTES)), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> new FromOrderedBytesValue((Value)arguments.get(0), TupleOrdering.Direction.ASC_NULLS_FIRST, Type.any()));
        }
    }
}

