/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PInOpValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.BooleanValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class InOpValue
extends AbstractValue
implements BooleanValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("In-Op-Value");
    @Nonnull
    private final Value probeValue;
    @Nonnull
    private final Value inArrayValue;

    private InOpValue(@Nonnull Value probeValue, @Nonnull Value inArrayValue) {
        this.probeValue = probeValue;
        this.inArrayValue = inArrayValue;
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.probeValue, this.inArrayValue);
    }

    @Override
    @Nonnull
    public InOpValue withChildren(Iterable<? extends Value> newChildren) {
        Verify.verify(Iterables.size(newChildren) == 2);
        return new InOpValue(Iterables.get(newChildren, 0), Iterables.get(newChildren, 1));
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object probeResult = this.probeValue.eval(store, context);
        Object inArrayResult = this.inArrayValue.eval(store, context);
        Verify.verify(inArrayResult instanceof List);
        if (((List)inArrayResult).stream().anyMatch(object -> Boolean.TRUE.equals(Comparisons.evalComparison(Comparisons.Type.EQUALS, object, probeResult)))) {
            return true;
        }
        if (((List)inArrayResult).stream().anyMatch(Objects::isNull)) {
            return null;
        }
        return false;
    }

    @Override
    public Optional<QueryPredicate> toQueryPredicate(@Nullable TypeRepository typeRepository, @Nonnull Set<CorrelationIdentifier> localAliases) {
        Set<CorrelationIdentifier> leftChildCorrelatedTo = this.probeValue.getCorrelatedTo();
        if (leftChildCorrelatedTo.isEmpty() && typeRepository != null) {
            return this.compileTimeEvalMaybe(typeRepository);
        }
        boolean isLiteralList = this.inArrayValue.getCorrelatedTo().isEmpty();
        SemanticException.check(isLiteralList, SemanticException.ErrorCode.UNSUPPORTED);
        if (typeRepository != null) {
            Object literalValue = Preconditions.checkNotNull(this.inArrayValue.evalWithoutStore(EvaluationContext.forTypeRepository(typeRepository)));
            return Optional.of(new ValuePredicate(this.probeValue, new Comparisons.ListComparison(Comparisons.Type.IN, (List)literalValue)));
        }
        return Optional.of(new ValuePredicate(this.probeValue, new Comparisons.ValueComparison(Comparisons.Type.IN, this.inArrayValue)));
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private Optional<QueryPredicate> compileTimeEvalMaybe(@Nonnull TypeRepository typeRepository) {
        Object constantValue = this.evalWithoutStore(EvaluationContext.forTypeRepository(typeRepository));
        if (constantValue instanceof Boolean) {
            if (((Boolean)constantValue).booleanValue()) {
                return Optional.of(ConstantPredicate.TRUE);
            }
            return Optional.of(ConstantPredicate.FALSE);
        }
        if (constantValue == null) {
            return Optional.of(ConstantPredicate.NULL);
        }
        return Optional.empty();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.probeValue, this.inArrayValue);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokensWithPrecedence probe = Iterables.get(explainSuppliers, 0).get();
        ExplainTokensWithPrecedence inArray = Iterables.get(explainSuppliers, 1).get();
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.BETWEEN, ExplainTokensWithPrecedence.Precedence.BETWEEN.parenthesizeChild(probe, true).addWhitespace().addKeyword("IN").addWhitespace().addNested(ExplainTokensWithPrecedence.Precedence.BETWEEN.parenthesizeChild(inArray, true)));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PInOpValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PInOpValue.newBuilder().setProbeValue(this.probeValue.toValueProto(serializationContext)).setInArrayValue(this.inArrayValue.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setInOpValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static InOpValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInOpValue inOpValueProto) {
        return new InOpValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(inOpValueProto.getProbeValue())), Value.fromValueProto(serializationContext, Objects.requireNonNull(inOpValueProto.getInArrayValue())));
    }

    public static class Deserializer
    implements PlanDeserializer<PInOpValue, InOpValue> {
        @Override
        @Nonnull
        public Class<PInOpValue> getProtoMessageClass() {
            return PInOpValue.class;
        }

        @Override
        @Nonnull
        public InOpValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInOpValue inOpValueProto) {
            return InOpValue.fromProto(serializationContext, inOpValueProto);
        }
    }

    public static class InFn
    extends BuiltInFunction<Value> {
        public InFn() {
            super("in", List.of(new Type.Any(), new Type.Array()), (BuiltInFunction<T> builtInFunc, List<Typed> args) -> InFn.encapsulateInternal(args));
        }

        @Nonnull
        private static Value encapsulateInternal(@Nonnull List<? extends Typed> arguments) {
            Typed arg0 = arguments.get(0);
            Type res0 = arg0.getResultType();
            Typed arg1 = arguments.get(1);
            Type res1 = arg1.getResultType();
            SemanticException.check(res1.isArray(), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
            Type arrayElementType = Objects.requireNonNull(((Type.Array)res1).getElementType());
            if (!arrayElementType.isUnresolved() && res0.getTypeCode() != arrayElementType.getTypeCode()) {
                Type maximumType = Type.maximumType(arg0.getResultType(), arrayElementType);
                SemanticException.check(maximumType != null, SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
                if (!arg0.getResultType().equals(maximumType)) {
                    return new InOpValue(PromoteValue.inject((Value)arg0, maximumType), (Value)arg1);
                }
                return new InOpValue((Value)arg0, PromoteValue.inject((Value)arg1, new Type.Array(maximumType)));
            }
            if (res0.isRecord()) {
                SemanticException.check(arrayElementType.isRecord(), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
                List<Type> probeElementTypes = Objects.requireNonNull(((Type.Record)res0).getElementTypes());
                List<Type> inElementTypes = Objects.requireNonNull(((Type.Record)arrayElementType).getElementTypes());
                for (int i = 0; i < inElementTypes.size(); ++i) {
                    Type probeElementType = probeElementTypes.get(i);
                    Type inElementType = inElementTypes.get(i);
                    SemanticException.check(probeElementType.isPrimitive(), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
                    SemanticException.check(inElementType.isPrimitive(), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
                    SemanticException.check(probeElementType.getTypeCode() == inElementType.getTypeCode(), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
                }
            }
            return new InOpValue((Value)arg0, (Value)arg1);
        }
    }
}

