/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PIndexEntryObjectValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.ImmutableIntArray;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IndexEntryObjectValue
extends AbstractValue
implements LeafValue,
Value.RangeMatchableValue {
    @Nonnull
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Index-Entry-Object-Value");
    @Nonnull
    private final CorrelationIdentifier indexEntryAlias;
    @Nonnull
    private final IndexKeyValueToPartialRecord.TupleSource source;
    @Nonnull
    private final ImmutableIntArray ordinalPath;
    @Nonnull
    private final Type resultType;

    public IndexEntryObjectValue(@Nonnull CorrelationIdentifier alias, @Nonnull IndexKeyValueToPartialRecord.TupleSource source, @Nonnull ImmutableIntArray ordinalPath, @Nonnull Type resultType) {
        Verify.verify(resultType.isPrimitive() || resultType.isEnum() || resultType.isUuid());
        this.indexEntryAlias = alias;
        this.source = source;
        this.ordinalPath = ordinalPath;
        this.resultType = resultType;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return Set.of();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> this.ordinalPath.equals(((IndexEntryObjectValue)other).ordinalPath));
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        IndexEntry indexEntry = Objects.requireNonNull((IndexEntry)context.getBinding(Bindings.Internal.CORRELATION, this.indexEntryAlias));
        Tuple tuple = this.source == IndexKeyValueToPartialRecord.TupleSource.KEY ? indexEntry.getKey() : indexEntry.getValue();
        Object value = IndexKeyValueToPartialRecord.getForOrdinalPath(tuple, this.ordinalPath);
        if (value == null) {
            return null;
        }
        switch (this.resultType.getTypeCode()) {
            case INT: {
                return ((Long)value).intValue();
            }
            case BYTES: {
                return ZeroCopyByteString.wrap((byte[])value);
            }
            case ENUM: {
                return () -> ((Long)value).intValue();
            }
        }
        return value;
    }

    @Override
    public int hashCodeWithoutChildren() {
        return this.planHash(PlanHashable.CURRENT_FOR_CONTINUATION);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.ordinalPath, this.source});
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword(this.source.toString()).addOptionalWhitespace().addToString(":").addIdentifier(this.ordinalPath.toString()));
    }

    @Override
    @Nonnull
    public PIndexEntryObjectValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PIndexEntryObjectValue.Builder builder = PIndexEntryObjectValue.newBuilder().setIndexEntryAlias(this.indexEntryAlias.getId()).setSource(this.source.toProto(serializationContext));
        this.ordinalPath.forEach(builder::addOrdinalPath);
        return builder.setResultType(this.resultType.toTypeProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setIndexEntryObjectValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static String bindingName() {
        return Bindings.Internal.CORRELATION.bindingName(Quantifier.current().getId());
    }

    @Nonnull
    public static IndexEntryObjectValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexEntryObjectValue indexEntryObjectValueProto) {
        ImmutableIntArray.Builder ordinalPathBuilder = ImmutableIntArray.builder();
        for (int i = 0; i < indexEntryObjectValueProto.getOrdinalPathCount(); ++i) {
            ordinalPathBuilder.add(indexEntryObjectValueProto.getOrdinalPath(i));
        }
        return new IndexEntryObjectValue(CorrelationIdentifier.of(Objects.requireNonNull(indexEntryObjectValueProto.getIndexEntryAlias())), IndexKeyValueToPartialRecord.TupleSource.fromProto(serializationContext, Objects.requireNonNull(indexEntryObjectValueProto.getSource())), ordinalPathBuilder.build(), Type.fromTypeProto(serializationContext, Objects.requireNonNull(indexEntryObjectValueProto.getResultType())));
    }

    public static class Deserializer
    implements PlanDeserializer<PIndexEntryObjectValue, IndexEntryObjectValue> {
        @Override
        @Nonnull
        public Class<PIndexEntryObjectValue> getProtoMessageClass() {
            return PIndexEntryObjectValue.class;
        }

        @Override
        @Nonnull
        public IndexEntryObjectValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexEntryObjectValue indexEntryObjectValue) {
            return IndexEntryObjectValue.fromProto(serializationContext, indexEntryObjectValue);
        }
    }
}

