/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.planprotos.PIndexOnlyAggregateValue;
import com.apple.foundationdb.record.planprotos.PMaxEverValue;
import com.apple.foundationdb.record.planprotos.PMinEverValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Accumulator;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.IndexableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class IndexOnlyAggregateValue
extends AbstractValue
implements AggregateValue,
Value.NonEvaluableValue,
ValueWithChild,
IndexableAggregateValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Index-Only-Aggregate-Value");
    @Nonnull
    protected final PhysicalOperator operator;
    @Nonnull
    private final Value child;

    protected IndexOnlyAggregateValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexOnlyAggregateValue indexOnlyAggregateValueProto) {
        this(PhysicalOperator.fromProto(serializationContext, Objects.requireNonNull(indexOnlyAggregateValueProto.getOperator())), Value.fromValueProto(serializationContext, Objects.requireNonNull(indexOnlyAggregateValueProto.getChild())));
    }

    protected IndexOnlyAggregateValue(@Nonnull PhysicalOperator operator, @Nonnull Value child) {
        this.operator = operator;
        this.child = child;
    }

    @Override
    @Nonnull
    public Value getChild() {
        return this.child;
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.getChild());
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.child.getResultType();
    }

    @Override
    @Nonnull
    public Accumulator createAccumulatorWithInitialState(@Nonnull TypeRepository typeRepository, @Nullable List<RecordCursorProto.AccumulatorState> initialState) {
        throw new IllegalStateException("unable to create accumulator in a compile-time aggregation function");
    }

    @Override
    @Nullable
    public <M extends Message> Object evalToPartial(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        throw new IllegalStateException("unable to evalToPartial in a compile-time aggregation function");
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, new Object[]{BASE_HASH, this.operator});
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall(this.operator.name().toLowerCase(Locale.ROOT), Value.explainFunctionArguments(explainSuppliers)));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.operator, this.child});
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> this.operator.equals((Object)((IndexOnlyAggregateValue)other).operator));
    }

    @Nonnull
    PIndexOnlyAggregateValue toIndexOnlyAggregateValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PIndexOnlyAggregateValue.newBuilder().setOperator(this.operator.toProto(serializationContext)).setChild(this.child.toValueProto(serializationContext)).build();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    protected static enum PhysicalOperator {
        MAX_EVER_LONG,
        MIN_EVER_LONG;


        @Nonnull
        PIndexOnlyAggregateValue.PPhysicalOperator toProto(@Nonnull PlanSerializationContext serializationContext) {
            switch (this) {
                case MAX_EVER_LONG: {
                    return PIndexOnlyAggregateValue.PPhysicalOperator.MAX_EVER_LONG;
                }
                case MIN_EVER_LONG: {
                    return PIndexOnlyAggregateValue.PPhysicalOperator.MIN_EVER_LONG;
                }
            }
            throw new RecordCoreException("unknown operator mapping. did you forget to add it?", new Object[0]);
        }

        @Nonnull
        static PhysicalOperator fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexOnlyAggregateValue.PPhysicalOperator physicalOperatorProto) {
            switch (physicalOperatorProto) {
                case MAX_EVER_LONG: {
                    return MAX_EVER_LONG;
                }
                case MIN_EVER_LONG: {
                    return MIN_EVER_LONG;
                }
            }
            throw new RecordCoreException("unknown operator mapping. did you forget to add it?", new Object[0]);
        }
    }

    public static class MaxEverFn
    extends BuiltInFunction<AggregateValue> {
        public MaxEverFn() {
            super("MAX_EVER", ImmutableList.of(new Type.Any()), (BuiltInFunction<T> ignored, List<Typed> arguments) -> MaxEverValue.encapsulate(arguments));
        }
    }

    public static class MinEverFn
    extends BuiltInFunction<AggregateValue> {
        public MinEverFn() {
            super("MIN_EVER", ImmutableList.of(new Type.Any()), (BuiltInFunction<T> ignored, List<Typed> arguments) -> MinEverValue.encapsulate(arguments));
        }
    }

    public static class MaxEverValue
    extends IndexOnlyAggregateValue {
        MaxEverValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMaxEverValue maxEverValueProto) {
            super(serializationContext, Objects.requireNonNull(maxEverValueProto.getSuper()));
        }

        MaxEverValue(@Nonnull PhysicalOperator operator, @Nonnull Value child) {
            super(operator, child);
        }

        @Override
        @Nonnull
        public String getIndexTypeName() {
            return "max_ever";
        }

        @Nonnull
        private static AggregateValue encapsulate(@Nonnull List<? extends Typed> arguments) {
            Verify.verify(arguments.size() == 1);
            Typed arg0 = arguments.get(0);
            return new MaxEverValue(PhysicalOperator.MAX_EVER_LONG, (Value)arg0);
        }

        @Override
        @Nonnull
        public ValueWithChild withNewChild(@Nonnull Value rebasedChild) {
            return new MaxEverValue(this.operator, rebasedChild);
        }

        @Override
        @Nonnull
        public PMaxEverValue toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PMaxEverValue.newBuilder().setSuper(this.toIndexOnlyAggregateValueProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValue.newBuilder().setMaxEverValue(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static MaxEverValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMaxEverValue maxEverValueProto) {
            return new MaxEverValue(serializationContext, maxEverValueProto);
        }

        public static class Deserializer
        implements PlanDeserializer<PMaxEverValue, MaxEverValue> {
            @Override
            @Nonnull
            public Class<PMaxEverValue> getProtoMessageClass() {
                return PMaxEverValue.class;
            }

            @Override
            @Nonnull
            public MaxEverValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMaxEverValue maxEverValueProto) {
                return MaxEverValue.fromProto(serializationContext, maxEverValueProto);
            }
        }
    }

    public static class MinEverValue
    extends IndexOnlyAggregateValue {
        MinEverValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMinEverValue minEverValueProto) {
            super(serializationContext, Objects.requireNonNull(minEverValueProto.getSuper()));
        }

        MinEverValue(@Nonnull PhysicalOperator operator, @Nonnull Value child) {
            super(operator, child);
        }

        @Override
        @Nonnull
        public String getIndexTypeName() {
            return "min_ever";
        }

        @Nonnull
        private static AggregateValue encapsulate(@Nonnull List<? extends Typed> arguments) {
            Verify.verify(arguments.size() == 1);
            Typed arg0 = arguments.get(0);
            return new MinEverValue(PhysicalOperator.MIN_EVER_LONG, (Value)arg0);
        }

        @Override
        @Nonnull
        public ValueWithChild withNewChild(@Nonnull Value rebasedChild) {
            return new MinEverValue(this.operator, rebasedChild);
        }

        @Override
        @Nonnull
        public PMinEverValue toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PMinEverValue.newBuilder().setSuper(this.toIndexOnlyAggregateValueProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValue.newBuilder().setMinEverValue(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static MinEverValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMinEverValue minEverValueProto) {
            return new MinEverValue(serializationContext, minEverValueProto);
        }

        public static class Deserializer
        implements PlanDeserializer<PMinEverValue, MinEverValue> {
            @Override
            @Nonnull
            public Class<PMinEverValue> getProtoMessageClass() {
                return PMinEverValue.class;
            }

            @Override
            @Nonnull
            public MinEverValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMinEverValue minEverValueProto) {
                return MinEverValue.fromProto(serializationContext, minEverValueProto);
            }
        }
    }
}

