/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PIndexedValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class IndexedValue
extends AbstractValue
implements LeafValue,
Value.NonEvaluableValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Indexed-Value");
    @Nonnull
    private final Type resultType;

    public IndexedValue() {
        this(Type.primitiveType(Type.TypeCode.UNKNOWN));
    }

    public IndexedValue(@Nonnull Type resultType) {
        this.resultType = resultType;
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        return false;
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, (Object)BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("indexed"));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PIndexedValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PIndexedValue.newBuilder().setResultType(this.resultType.toTypeProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setIndexedValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static IndexedValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexedValue indexedValueProto) {
        return new IndexedValue(Type.fromTypeProto(serializationContext, Objects.requireNonNull(indexedValueProto.getResultType())));
    }

    public static class Deserializer
    implements PlanDeserializer<PIndexedValue, IndexedValue> {
        @Override
        @Nonnull
        public Class<PIndexedValue> getProtoMessageClass() {
            return PIndexedValue.class;
        }

        @Override
        @Nonnull
        public IndexedValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexedValue indexedValueProto) {
            return IndexedValue.fromProto(serializationContext, indexedValueProto);
        }
    }
}

